/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.ClassAnalyzer;
import com.sun.corba.ee.impl.encoding.fast.ClassMarshalerFactory;
import com.sun.corba.ee.impl.encoding.fast.OutputStream;
import com.sun.corba.ee.impl.io.ObjectStreamField;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import sun.corba.Bridge;

public class ClassMarshaler {
    private static final Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Bridge.get();
        }
    });
    private char[] typeName;
    private LinkedList<ClassMarshaler> cmChain;
    private ObjectWriter writer;
    private ClassAnalyzer classAnalyzer;
    private static final FieldWriter byteWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            byte val = bridge.getByte(obj, offset);
            os.writeByte(val);
        }
    };
    private static final FieldWriter booleanWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            boolean val = bridge.getBoolean(obj, offset);
            os.writeBoolean(val);
        }
    };
    private static final FieldWriter charWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            char val = bridge.getChar(obj, offset);
            os.writeChar(val);
        }
    };
    private static final FieldWriter shortWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            short val = bridge.getShort(obj, offset);
            os.writeShort(val);
        }
    };
    private static final FieldWriter intWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            int val = bridge.getInt(obj, offset);
            os.writeInt(val);
        }
    };
    private static final FieldWriter longWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            long val = bridge.getLong(obj, offset);
            os.writeLong(val);
        }
    };
    private static final FieldWriter floatWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            float val = bridge.getFloat(obj, offset);
            os.writeFloat(val);
        }
    };
    private static final FieldWriter doubleWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            double val = bridge.getDouble(obj, offset);
            os.writeDouble(val);
        }
    };
    private static final FieldWriter nonPrimitiveWriter = new FieldWriter(){

        @Override
        public void write(Object obj, long offset, OutputStream os) throws IOException {
            Object val = bridge.getObject(obj, offset);
            os.writeObject(val);
        }
    };

    public ClassMarshaler(ClassAnalyzer ca) {
        this.typeName = ca.getName().toCharArray();
        this.cmChain = new LinkedList();
        this.classAnalyzer = ca;
        ClassAnalyzer current = ca;
        do {
            ClassMarshaler cm = ClassMarshalerFactory.getClassMarshaler(current.getClass());
            this.cmChain.addFirst(cm);
        } while ((current = current.getSuperClassAnalyzer()) != null);
        if (ca.isSerializable() && !ca.hasWriteObjectMethod()) {
            this.writer = this.makeObjectWriter(ca.forClass(), ca.getFields());
        }
    }

    public boolean isImmutable() {
        return false;
    }

    public char[] getTypeName() {
        return this.cmChain.get(0).getClassAnalyzer().getNameAsCharArray();
    }

    public ClassAnalyzer getClassAnalyzer() {
        return this.classAnalyzer;
    }

    public ObjectOutputStream.PutField getPutField() {
        throw new UnsupportedOperationException("PutField not yet supported");
    }

    public Object handleReplace(Object obj, Holder<ClassMarshaler> cmHolder) throws IOException {
        ClassAnalyzer currentCa = ((ClassMarshaler)cmHolder.content()).getClassAnalyzer();
        Object replacement = obj;
        while (currentCa.hasWriteReplaceMethod()) {
            Object newReplacement = currentCa.invokeWriteReplace(replacement);
            if (newReplacement == null) {
                cmHolder.content(null);
                replacement = null;
                break;
            }
            if (newReplacement == replacement) break;
            ClassMarshaler cm = ClassMarshalerFactory.getClassMarshaler(newReplacement.getClass());
            cmHolder.content((Object)cm);
            currentCa = cm.getClassAnalyzer();
            replacement = newReplacement;
        }
        return replacement;
    }

    public void writeObject(Object obj, OutputStream os) throws IOException {
        os.startValue(obj, this.cmChain.size());
        ClassAnalyzer ca = this.cmChain.get(0).getClassAnalyzer();
        if (ca.isExternalizable()) {
            this.writeExternalData(obj, os);
        } else if (ca.isSerializable()) {
            this.writeSerialData(obj, os);
        }
    }

    private FieldWriter getFieldWriter(Class fldType) {
        if (fldType.isPrimitive()) {
            if (fldType == Byte.TYPE) {
                return byteWriter;
            }
            if (fldType == Boolean.TYPE) {
                return booleanWriter;
            }
            if (fldType == Character.TYPE) {
                return charWriter;
            }
            if (fldType == Short.TYPE) {
                return shortWriter;
            }
            if (fldType == Integer.TYPE) {
                return intWriter;
            }
            if (fldType == Long.TYPE) {
                return longWriter;
            }
            if (fldType == Float.TYPE) {
                return floatWriter;
            }
            if (fldType == Double.TYPE) {
                return doubleWriter;
            }
            throw new IllegalStateException("This can't happen");
        }
        return nonPrimitiveWriter;
    }

    private ObjectWriter makeObjectWriter(Class cls, ObjectStreamField[] info) {
        int size = info.length;
        final long[] offsets = new long[size];
        final FieldWriter[] fieldWriters = new FieldWriter[size];
        try {
            int ctr = 0;
            for (ObjectStreamField osf : info) {
                String fieldName = osf.getName();
                Class fieldType = osf.getClazz();
                Field fld = cls.getDeclaredField(fieldName);
                if (fld.getType() != fieldType) {
                    // empty if block
                }
                offsets[ctr] = bridge.objectFieldOffset(fld);
                fieldWriters[ctr] = this.getFieldWriter(fieldType);
                ++ctr;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        return new ObjectWriter(){

            @Override
            public void write(Object obj, OutputStream os) throws IOException {
                for (int ctr = 0; ctr < offsets.length; ++ctr) {
                    fieldWriters[ctr].write(obj, offsets[ctr], os);
                }
            }
        };
    }

    private void writeExternalData(Object obj, OutputStream os) throws IOException {
        if (!(obj instanceof Externalizable)) {
            // empty if block
        }
        Externalizable ext = (Externalizable)obj;
        ext.writeExternal(os);
    }

    void writeClassFields(Object obj, OutputStream os) throws IOException {
        this.writer.write(obj, os);
    }

    private void writeSerialData(Object obj, OutputStream os) throws IOException {
        for (int ctr = this.cmChain.size(); ctr >= 0; --ctr) {
            ClassMarshaler cm = this.cmChain.get(ctr);
            ClassAnalyzer ca = cm.getClassAnalyzer();
            char[] typeName = ca.getNameAsCharArray();
            os.startClass(ca.hasWriteObjectMethod(), typeName, ca.getFields().length);
            if (ca.hasWriteObjectMethod()) {
                os.startCustomPart(obj, cm);
                ca.invokeWriteObject(obj, os);
                os.endCustomPart();
                continue;
            }
            cm.writeClassFields(obj, os);
        }
    }

    public Object create() {
        try {
            ClassMarshaler cm = this.cmChain.get(0);
            ClassAnalyzer ca = cm.getClassAnalyzer();
            if (!ca.isInstantiable()) {
                // empty if block
            }
            return ca.newInstance();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private static interface FieldWriter {
        public void write(Object var1, long var2, OutputStream var4) throws IOException;
    }

    private static interface ObjectWriter {
        public void write(Object var1, OutputStream var2) throws IOException;
    }
}

