/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.EmergeStreamEventHandler;
import com.sun.corba.ee.impl.encoding.fast.EmergeStreamParser;
import com.sun.corba.ee.impl.encoding.fast.LabelManager;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Reader;
import com.sun.corba.ee.spi.orbutil.misc.Printer;
import java.io.PrintStream;

public class EmergeDecoder {
    private EmergeStreamEventHandler makeHandler(final PrintStream ps) {
        return new EmergeStreamEventHandler(){
            Printer pr;
            private static final int INIT_INDEX_WIDTH = 5;
            private static final String INIT_SEPARATOR = ": ";
            private static final int LINE_LENGTH = 90;
            {
                this.pr = new Printer(ps);
            }

            @Override
            public void nullEvent() {
                this.pr.nl().p("NULL");
            }

            @Override
            public void indirEvent(LabelManager.Label label) {
                this.pr.nl().p("INDIR: ").p((Object)label);
            }

            @Override
            public void boolEvent(boolean value) {
                this.pr.nl().p("BOOL: ").p((Object)value);
            }

            @Override
            public void byteEvent(byte value) {
                this.pr.nl().p("BYTE: ").p((Object)value);
            }

            @Override
            public void charEvent(char value) {
                this.pr.nl().p("CHAR: ").p((Object)Character.valueOf(value));
            }

            @Override
            public void shortEvent(short value) {
                this.pr.nl().p("SHORT: ").p((Object)value);
            }

            @Override
            public void intEvent(int value) {
                this.pr.nl().p("INT: ").p((Object)value);
            }

            @Override
            public void longEvent(long value) {
                this.pr.nl().p("LONG: ").p((Object)value);
            }

            @Override
            public void floatEvent(float value) {
                this.pr.nl().p("FLOAT: ").p((Object)Float.valueOf(value));
            }

            @Override
            public void doubleEvent(double value) {
                this.pr.nl().p("DOUBLE: ").p((Object)value);
            }

            private void displayAsStrings(Object[] data) {
                int length = data.length;
                int maxSize = 0;
                for (int ctr = 0; ctr < length; ++ctr) {
                    int strlen = data[ctr].toString().length();
                    if (strlen <= maxSize) continue;
                    maxSize = strlen;
                }
                int numPerLine = (90 - this.pr.indent() - 5 - INIT_SEPARATOR.length()) / (maxSize + 1);
                int numFullLines = length / numPerLine;
                int numInLastLine = length - numFullLines * numPerLine;
                for (int lineCtr = 0; lineCtr < numFullLines; ++lineCtr) {
                    int startIndex = lineCtr * numPerLine;
                    this.pr.nl().rj(5).p((Object)startIndex).p(INIT_SEPARATOR);
                    for (int innerCtr = 0; innerCtr < numPerLine; ++innerCtr) {
                        this.pr.rj(maxSize).p(data[startIndex + innerCtr]).p((Object)Character.valueOf(' '));
                    }
                }
                if (numInLastLine > 0) {
                    int startIndex = numFullLines * numPerLine;
                    this.pr.nl().rj(5).p((Object)startIndex).p(INIT_SEPARATOR);
                    for (int ctr = 0; ctr < numInLastLine; ++ctr) {
                        this.pr.rj(maxSize).p(data[startIndex + ctr]).p((Object)Character.valueOf(' '));
                    }
                }
            }

            @Override
            public void boolArrEvent(LabelManager.Label selfLabel, long offset, long length, boolean[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("BOOL_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void charArrEvent(LabelManager.Label selfLabel, long offset, long length, char[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = Character.valueOf(value[ctr]);
                }
                this.pr.nl().p("CHAR_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void byteArrEvent(LabelManager.Label selfLabel, long offset, long length, byte[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("BYTE_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void shortArrEvent(LabelManager.Label selfLabel, long offset, long length, short[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("SHORT_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void intArrEvent(LabelManager.Label selfLabel, long offset, long length, int[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("INT_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void longArrEvent(LabelManager.Label selfLabel, long offset, long length, long[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("LONG_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void floatArrEvent(LabelManager.Label selfLabel, long offset, long length, float[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = Float.valueOf(value[ctr]);
                }
                this.pr.nl().p("FLOAT_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void doubleArrEvent(LabelManager.Label selfLabel, long offset, long length, double[] value) {
                Object[] objs = new Object[value.length];
                for (int ctr = 0; ctr < value.length; ++ctr) {
                    objs[ctr] = value[ctr];
                }
                this.pr.nl().p("DOUBLE_ARR: ").p("selfLabel=").p((Object)selfLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings(objs);
                this.pr.out();
            }

            @Override
            public void refArrEvent(LabelManager.Label selfLabel, LabelManager.Label typeLabel, long offset, long length, LabelManager.Label[] value) {
                this.pr.nl().p("REF_ARR:").p(" selfLabel=").p((Object)selfLabel).p(" typeLabel=").p((Object)typeLabel).p(" offset=").p((Object)offset).p(" length=").p((Object)length).in();
                this.displayAsStrings((Object[])value);
                this.pr.out();
            }

            @Override
            public void refEvent(LabelManager.Label selfLabel, long numParts) {
            }

            @Override
            public void simplePartEvent(LabelManager.Label typeLabel, long offset, long length) {
            }

            @Override
            public void customPartEvent(LabelManager.Label typeLabel, long offset, long length) {
            }

            @Override
            public void tupleStartEvent() {
                this.pr.nl().p("TUPLE (START)").in();
            }

            @Override
            public void tupleEndEvent() {
                this.pr.out().nl().p("TUPLE (END)");
            }

            @Override
            public void labelMessageRequestEvent(LabelManager.Label label) {
            }

            @Override
            public void labelMessageReplyGoodEvent(LabelManager.Label label) {
            }

            @Override
            public void labelMessageReplyBadEvent(LabelManager.Label label, long reasonCodeCategory, long reasonCodeMinorCode) {
                this.pr.nl().p("LABEL_MSG (REPLY_ERROR)").p(" label=").p((Object)label).p(" reason code category=").p((Object)reasonCodeCategory).p(" reason code minor code=").p((Object)reasonCodeMinorCode);
            }

            @Override
            public void closeSessionMessageEvent(long sessionId) {
                this.pr.nl().p("CLOSE_SESSION: ").p("sessionId=").p((Object)sessionId);
            }

            @Override
            public void rejectRequestMessageEvent(long reasonCodeCategory, long reasonCodeMinorCode) {
            }

            @Override
            public void fiberListMessageEvent(long[] fibers) {
            }

            @Override
            public void messageStartEvent(long requestId, long sessionId, long fiberId, long numArgs) {
                this.pr.nl().p("MESSAGE (end):").p(" requestId=").p((Object)requestId).p(" sessionId=").p((Object)sessionId).p(" fiberId=").p((Object)fiberId).p(" numArgs=").p((Object)numArgs).in();
            }

            @Override
            public void messageEndEvent(long requestId, long sessionId, long fiberId, long numArgs) {
                this.pr.out().nl().p("MESSAGE (end):").p(" requestId=").p((Object)requestId).p(" sessionId=").p((Object)sessionId).p(" fiberId=").p((Object)fiberId).p(" numArgs=").p((Object)numArgs);
            }
        };
    }

    public EmergeDecoder(PrintStream ps, Reader reader) {
        EmergeStreamParser parser = new EmergeStreamParser(reader);
        parser.parse(this.makeHandler(ps));
    }
}

