/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Allocator;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.AllocatorBase;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Slab;
import java.nio.ByteBuffer;

public class BufferWrapper {
    private AllocatorBase allocator;
    private Slab slab;
    private int slabPosition;
    private int headerSize;
    private ByteBuffer backingStore;
    private ByteBuffer visible;

    public BufferWrapper(Allocator allocator, Slab slab, int headerSize, int size) {
        this.allocator = (AllocatorBase)AllocatorBase.class.cast(allocator);
        this.headerSize = headerSize;
        this.slab = slab;
        this.slabPosition = slab.currentPosition();
        this.backingStore = slab.allocate(headerSize + size);
        this.backingStore.position(headerSize);
        this.visible = this.backingStore.slice();
    }

    private void checkDispose() {
        if (this.visible == null) {
            throw new IllegalStateException("BufferWrapper has already been disposed");
        }
    }

    public ByteBuffer buffer() {
        this.checkDispose();
        return this.visible;
    }

    public ByteBuffer reset() {
        this.checkDispose();
        this.visible.flip();
        return this.visible;
    }

    public int remaining() {
        this.checkDispose();
        return this.visible.remaining();
    }

    public ByteBuffer prepend(ByteBuffer header) {
        this.checkDispose();
        if (header.remaining() > this.headerSize) {
            throw new IllegalArgumentException("header size is greater than reserved space");
        }
        if (header.remaining() > 0) {
            int startPosition = this.backingStore.position() - header.remaining();
            this.backingStore.position(startPosition);
            this.backingStore.put(header);
            this.backingStore.position(startPosition);
            this.visible = this.backingStore.slice();
        }
        return this.visible;
    }

    public void trim() {
        this.checkDispose();
        int sizeNeeded = this.headerSize + this.visible.position();
        this.backingStore = this.slab.trim(this.slabPosition, this.backingStore, sizeNeeded);
        this.backingStore.position(this.headerSize);
        this.visible = this.backingStore.slice();
        this.visible.position(0);
    }

    public void dispose() {
        this.checkDispose();
        this.allocator.dispose(this.slab, this.backingStore);
        this.allocator = null;
        this.slab = null;
        this.backingStore = null;
        this.visible = null;
    }
}

