/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.transport.ListenerThreadImpl;
import com.sun.corba.ee.impl.transport.ReaderThreadImpl;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.EventHandler;
import com.sun.corba.ee.spi.transport.ListenerThread;
import com.sun.corba.ee.spi.transport.ReaderThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@Transport
@ManagedObject
@Description(value="The Selector, which handles incoming requests to the ORB")
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class SelectorImpl
extends Thread
implements com.sun.corba.ee.spi.transport.Selector {
    private ORB orb;
    private Selector selector;
    private long timeout;
    private final List<EventHandler> deferredRegistrations;
    private final List<SelectionKeyAndOp> interestOpsList;
    private final Map<EventHandler, ListenerThread> listenerThreads;
    private final Map<EventHandler, ReaderThread> readerThreads;
    private boolean selectorStarted;
    private volatile boolean closed;
    private ORBUtilSystemException wrapper;
    private static SynchronizedHolder __$mm$__0;

    @ManagedAttribute
    @Description(value="List of listener threads dedicated to listening for new connections on an acceptor")
    private synchronized List<ListenerThread> getListenerThreads() {
        return new ArrayList<ListenerThread>(this.listenerThreads.values());
    }

    @ManagedAttribute
    @Description(value="List of reader threads dedicated to listening for new messages on a connection")
    private synchronized List<ReaderThread> getReaderThreads() {
        return new ArrayList<ReaderThread>(this.readerThreads.values());
    }

    public SelectorImpl(ORB orb) {
        this.orb = orb;
        this.selector = null;
        this.selectorStarted = false;
        this.timeout = 60000L;
        this.deferredRegistrations = new ArrayList<EventHandler>();
        this.interestOpsList = new ArrayList<SelectionKeyAndOp>();
        this.listenerThreads = new HashMap<EventHandler, ListenerThread>();
        this.readerThreads = new HashMap<EventHandler, ReaderThread>();
        this.closed = false;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    @ManagedAttribute
    @Description(value="The selector timeout")
    public long getTimeout() {
        return this.timeout;
    }

    @InfoMethod
    private void display(String string, Object object, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, object}, n, 10);
        }
    }

    @InfoMethod
    private void display(String string, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string}, n, 10);
        }
    }

    @InfoMethod
    private void closedEventHandler(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 4);
        }
    }

    @InfoMethod
    private void defaultCaseForEventHandler(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void registerInterestOps(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(18, new Object[]{eventHandler});
        }
        try {
            void __$mm$__;
            void eventHandler2;
            SelectionKey selectionKey = eventHandler2.getSelectionKey();
            if (selectionKey.isValid()) {
                int ehOps = eventHandler2.getInterestOps();
                SelectionKeyAndOp keyAndOp = new SelectionKeyAndOp(selectionKey, ehOps);
                List<SelectionKeyAndOp> list = this.interestOpsList;
                synchronized (list) {
                    try {
                        this.interestOpsList.add(keyAndOp);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 10] lbl17 : MonitorExitStatement: MONITOREXIT : var7_6
                        Throwable throwable2 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(18, throwable2);
                        }
                        throw throwable2;
                    }
                }
                this.selector.wakeup();
            } else {
                this.wrapper.selectionKeyInvalid(eventHandler2.toString());
                this.display("EventHandler SelectionKey not valid", eventHandler2, (MethodMonitor)__$mm$__, 18);
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(18);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(18);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void registerForEvent(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(17, new Object[]{eventHandler});
        }
        try {
            void eventHandler2;
            void __$mm$__;
            if (this.isClosed()) {
                this.closedEventHandler((MethodMonitor)__$mm$__, 17);
                if (__$mm$__ != null) {
                    __$mm$__.exit(17);
                }
                return;
            }
            if (eventHandler2.shouldUseSelectThreadToWait()) {
                List<EventHandler> list = this.deferredRegistrations;
                synchronized (list) {
                    try {
                        this.deferredRegistrations.add((EventHandler)eventHandler2);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 18, 2, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var4_3
                        Throwable throwable2 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(17, throwable2);
                        }
                        throw throwable2;
                    }
                }
                if (!this.selectorStarted) {
                    this.startSelector();
                }
                this.selector.wakeup();
                if (__$mm$__ != null) {
                    __$mm$__.exit(17);
                }
                return;
            }
            switch (eventHandler2.getInterestOps()) {
                case 16: {
                    this.createListenerThread((EventHandler)eventHandler2);
                    break;
                }
                case 1: {
                    this.createReaderThread((EventHandler)eventHandler2);
                    break;
                }
                default: {
                    this.defaultCaseForEventHandler((MethodMonitor)__$mm$__, 17);
                    RuntimeException runtimeException = new RuntimeException("SelectorImpl.registerForEvent: unknown interest ops");
                    if (__$mm$__ != null) {
                        __$mm$__.exception(17, (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(17);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(17);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void unregisterForEvent(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(25, new Object[]{eventHandler});
        }
        try {
            void eventHandler2;
            void __$mm$__;
            if (this.isClosed()) {
                this.closedEventHandler((MethodMonitor)__$mm$__, 25);
                if (__$mm$__ != null) {
                    __$mm$__.exit(25);
                }
                return;
            }
            if (eventHandler2.shouldUseSelectThreadToWait()) {
                SelectionKey selectionKey = eventHandler2.getSelectionKey();
                if (selectionKey != null) {
                    selectionKey.cancel();
                    this.selector.wakeup();
                }
                if (__$mm$__ != null) {
                    __$mm$__.exit(25);
                }
                return;
            }
            switch (eventHandler2.getInterestOps()) {
                case 16: {
                    this.destroyListenerThread((EventHandler)eventHandler2);
                    break;
                }
                case 1: {
                    this.destroyReaderThread((EventHandler)eventHandler2);
                    break;
                }
                default: {
                    this.defaultCaseForEventHandler((MethodMonitor)__$mm$__, 25);
                    RuntimeException runtimeException = new RuntimeException("SelectorImpl.uregisterForEvent: unknown interest ops");
                    if (__$mm$__ != null) {
                        __$mm$__.exception(25, (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(25);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(25);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void close() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[0]);
        }
        try {
            void __$mm$__;
            if (this.isClosed()) {
                this.closedEventHandler((MethodMonitor)__$mm$__, 3);
                if (__$mm$__ != null) {
                    __$mm$__.exit(3);
                }
                return;
            }
            this.setClosed(true);
            SelectorImpl selectorImpl = this;
            synchronized (selectorImpl) {
                try {
                    for (ListenerThread lthread : this.listenerThreads.values()) {
                        lthread.close();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var3_2
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(3, throwable2);
                    }
                    throw throwable2;
                }
            }
            selectorImpl = this;
            synchronized (selectorImpl) {
                try {
                    for (ReaderThread rthread : this.readerThreads.values()) {
                        rthread.close();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 7] lbl38 : MonitorExitStatement: MONITOREXIT : var3_2
                    Throwable throwable3 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(3, throwable3);
                    }
                    throw throwable3;
                }
            }
            try {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            catch (Throwable t) {
                this.display("Exception in close", t, (MethodMonitor)__$mm$__, 3);
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(3);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void beginSelect(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 0);
        }
    }

    @InfoMethod
    private void endSelect(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 13);
        }
    }

    @InfoMethod
    private void selectorClosed(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 22);
        }
    }

    @InfoMethod
    private void selectResult(boolean bl, int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{bl, n}, n2, 21);
        }
    }

    @InfoMethod
    private void skippingEventForCancelledKey(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void run() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(20, new Object[0]);
        }
        try {
            void __$mm$__;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SelectorImpl.this.setName("SelectorThread");
                    return null;
                }
            });
            while (!this.closed) {
                int n;
                block15: {
                    block16: {
                        this.beginSelect((MethodMonitor)__$mm$__, 20);
                        n = 0;
                        this.handleDeferredRegistrations();
                        this.enableInterestOps();
                        try {
                            n = this.selector.select(this.timeout);
                        }
                        catch (IOException e) {
                            this.display("Exception in select:", e, (MethodMonitor)__$mm$__, 20);
                        }
                        if (!this.closed) break block15;
                        this.selector.close();
                        this.selectorClosed((MethodMonitor)__$mm$__, 20);
                        if (__$mm$__ == null) break block16;
                        __$mm$__.exit(20);
                    }
                    return;
                }
                try {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    this.selectResult(iterator.hasNext(), n, (MethodMonitor)__$mm$__, 20);
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (selectionKey.isValid()) {
                            EventHandler eventHandler = (EventHandler)selectionKey.attachment();
                            try {
                                eventHandler.handleEvent();
                            }
                            catch (Throwable t) {
                                this.wrapper.exceptionInSelector(t, (Object)eventHandler);
                            }
                            continue;
                        }
                        this.wrapper.canceledSelectionKey(selectionKey);
                        this.skippingEventForCancelledKey((MethodMonitor)__$mm$__, 20);
                    }
                    this.endSelect((MethodMonitor)__$mm$__, 20);
                }
                catch (Throwable t) {
                    this.display("Ignoring exception", t, (MethodMonitor)__$mm$__, 20);
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(20);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(20);
            }
            throw throwable;
        }
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void startSelector() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(24, new Object[0]);
        }
        try {
            void __$mm$__;
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException(".startSelector: Selector.open exception");
                rte.initCause(e);
                RuntimeException runtimeException = rte;
                if (__$mm$__ != null) {
                    __$mm$__.exception(24, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            this.setDaemon(true);
            this.start();
            this.selectorStarted = true;
            if (__$mm$__ != null) {
                __$mm$__.exit(24);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(24);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void registeringEventHandler(EventHandler eventHandler, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{eventHandler}, n, 19);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void handleDeferredRegistrations() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(14, new Object[0]);
        }
        try {
            void __$mm$__;
            List<EventHandler> list = this.deferredRegistrations;
            synchronized (list) {
                try {
                    for (EventHandler eventHandler : this.deferredRegistrations) {
                        this.registeringEventHandler(eventHandler, (MethodMonitor)__$mm$__, 14);
                        SelectableChannel channel = eventHandler.getChannel();
                        SelectionKey selectionKey = null;
                        try {
                            selectionKey = channel.register(this.selector, eventHandler.getInterestOps(), eventHandler);
                        }
                        catch (ClosedChannelException e) {
                            this.display("Exception", e, (MethodMonitor)__$mm$__, 14);
                        }
                        eventHandler.setSelectionKey(selectionKey);
                    }
                    this.deferredRegistrations.clear();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl25 : MonitorExitStatement: MONITOREXIT : var3_2
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(14, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(14);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(14);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void ignoringCancelledKeyException(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 15);
        }
    }

    @InfoMethod
    private void keyAndOpInfo(SelectionKeyAndOp selectionKeyAndOp, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{selectionKeyAndOp}, n, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void enableInterestOps() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(12, new Object[0]);
        }
        try {
            void __$mm$__;
            List<SelectionKeyAndOp> list = this.interestOpsList;
            synchronized (list) {
                try {
                    for (SelectionKeyAndOp keyAndOp : this.interestOpsList) {
                        SelectionKey selectionKey = keyAndOp.selectionKey;
                        if (!selectionKey.isValid()) continue;
                        this.keyAndOpInfo(keyAndOp, (MethodMonitor)__$mm$__, 12);
                        int keyOp = keyAndOp.keyOp;
                        try {
                            int selectionKeyOps = selectionKey.interestOps();
                            selectionKey.interestOps(selectionKeyOps | keyOp);
                        }
                        catch (CancelledKeyException cke) {
                            this.ignoringCancelledKeyException((MethodMonitor)__$mm$__, 12);
                        }
                    }
                    this.interestOpsList.clear();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl27 : MonitorExitStatement: MONITOREXIT : var3_2
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(12, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(12);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(12);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void createListenerThread(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(5, new Object[]{eventHandler});
        }
        try {
            void __$mm$__;
            void eventHandler2;
            CorbaAcceptor acceptor = eventHandler2.getAcceptor();
            ListenerThreadImpl listenerThread = new ListenerThreadImpl(this.orb, acceptor);
            SelectorImpl selectorImpl = this;
            synchronized (selectorImpl) {
                try {
                    this.listenerThreads.put((EventHandler)eventHandler2, listenerThread);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var6_5
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(5, throwable2);
                    }
                    throw throwable2;
                }
            }
            Throwable throwable = null;
            try {
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork((Work)listenerThread);
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                RuntimeException rte = new RuntimeException(throwable.toString());
                rte.initCause(throwable);
                RuntimeException runtimeException = rte;
                if (__$mm$__ != null) {
                    __$mm$__.exception(5, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(5);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(5);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void cannotFindListenerThread(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Transport
    private void destroyListenerThread(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(8, new Object[]{eventHandler});
        }
        try {
            void __$mm$__;
            ListenerThread listenerThread;
            void eventHandler2;
            block7: {
                SelectorImpl selectorImpl = this;
                // MONITORENTER : selectorImpl
                try {
                    listenerThread = this.listenerThreads.get(eventHandler2);
                    if (listenerThread != null) break block7;
                    this.cannotFindListenerThread((MethodMonitor)__$mm$__, 8);
                    // MONITOREXIT : selectorImpl
                    if (__$mm$__ == null) return;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : selectorImpl
                    Throwable throwable2 = throwable;
                    if (__$mm$__ == null) throw throwable2;
                    __$mm$__.exception(8, throwable2);
                    throw throwable2;
                }
                __$mm$__.exit(8);
                return;
            }
            this.listenerThreads.remove(eventHandler2);
            // MONITOREXIT : selectorImpl
            listenerThread.close();
            if (__$mm$__ == null) return;
            __$mm$__.exit(8);
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor == null) throw throwable;
            methodMonitor.exit(8);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void createReaderThread(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(6, new Object[]{eventHandler});
        }
        try {
            void __$mm$__;
            void eventHandler2;
            CorbaConnection connection = eventHandler2.getConnection();
            ReaderThreadImpl readerThread = new ReaderThreadImpl(this.orb, connection);
            SelectorImpl selectorImpl = this;
            synchronized (selectorImpl) {
                try {
                    this.readerThreads.put((EventHandler)eventHandler2, readerThread);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var6_5
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(6, throwable2);
                    }
                    throw throwable2;
                }
            }
            Throwable throwable = null;
            try {
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork((Work)readerThread);
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                RuntimeException rte = new RuntimeException(throwable.toString());
                rte.initCause(throwable);
                RuntimeException runtimeException = rte;
                if (__$mm$__ != null) {
                    __$mm$__.exception(6, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(6);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(6);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void cannotFindReaderThread(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Transport
    private void destroyReaderThread(EventHandler eventHandler) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(9, new Object[]{eventHandler});
        }
        try {
            void __$mm$__;
            ReaderThread readerThread;
            void eventHandler2;
            block7: {
                SelectorImpl selectorImpl = this;
                // MONITORENTER : selectorImpl
                try {
                    readerThread = this.readerThreads.get(eventHandler2);
                    if (readerThread != null) break block7;
                    this.cannotFindReaderThread((MethodMonitor)__$mm$__, 9);
                    // MONITOREXIT : selectorImpl
                    if (__$mm$__ == null) return;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : selectorImpl
                    Throwable throwable2 = throwable;
                    if (__$mm$__ == null) throw throwable2;
                    __$mm$__.exception(9, throwable2);
                    throw throwable2;
                }
                __$mm$__.exit(9);
                return;
            }
            this.readerThreads.remove(eventHandler2);
            // MONITOREXIT : selectorImpl
            readerThread.close();
            if (__$mm$__ == null) return;
            __$mm$__.exit(9);
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor == null) throw throwable;
            methodMonitor.exit(9);
            throw throwable;
        }
    }

    static {
        MethodMonitorRegistry.registerClass(SelectorImpl.class);
    }

    private static class SelectionKeyAndOp {
        public int keyOp;
        public SelectionKey selectionKey;

        public SelectionKeyAndOp(SelectionKey selectionKey, int keyOp) {
            this.selectionKey = selectionKey;
            this.keyOp = keyOp;
        }
    }
}

