/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.cosnaming;

import com.sun.corba.ee.impl.logging.NamingSystemException;
import com.sun.corba.ee.impl.naming.cosnaming.NamingUtils;
import com.sun.corba.ee.impl.naming.cosnaming.TransientNameService;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.org.omg.CORBA.ORB;
import java.util.Arrays;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class TransientNameServer {
    private static boolean debug = false;
    private static NamingSystemException wrapper = com.sun.corba.ee.spi.orb.ORB.getStaticLogWrapperTable().get_NAMING_Naming();

    public static void trace(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static void initDebug(String[] args) {
        if (debug) {
            return;
        }
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (!args[ctr].equalsIgnoreCase("-debug")) continue;
            debug = true;
            return;
        }
        debug = false;
    }

    private static Object initializeRootNamingContext(org.omg.CORBA.ORB orb) {
        java.lang.Object rootContext = null;
        try {
            com.sun.corba.ee.spi.orb.ORB coreORB = (com.sun.corba.ee.spi.orb.ORB)orb;
            TransientNameService tns = new TransientNameService(coreORB);
            return tns.initialNamingContext();
        }
        catch (SystemException e) {
            throw wrapper.transNsCannotCreateInitialNcSys(e);
        }
        catch (Exception e) {
            throw wrapper.transNsCannotCreateInitialNc(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TransientNameServer.initDebug(args);
        boolean invalidHostOption = false;
        boolean orbInitialPort0 = false;
        int initialPort = 0;
        try {
            java.lang.Object sync;
            TransientNameServer.trace("Transient name server started with args " + Arrays.asList(args));
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBServerId", "1000000");
            props.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
            try {
                String ips = System.getProperty("org.omg.CORBA.ORBInitialPort");
                if (ips != null && ips.length() > 0 && (initialPort = Integer.parseInt(ips)) == 0) {
                    orbInitialPort0 = true;
                    throw wrapper.transientNameServerBadPort();
                }
                String hostName = System.getProperty("org.omg.CORBA.ORBInitialHost");
                if (hostName != null) {
                    invalidHostOption = true;
                    throw wrapper.transientNameServerBadHost();
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-ORBInitialPort") && i < args.length - 1 && (initialPort = Integer.parseInt(args[i + 1])) == 0) {
                    orbInitialPort0 = true;
                    throw wrapper.transientNameServerBadPort();
                }
                if (!args[i].equals("-ORBInitialHost")) continue;
                invalidHostOption = true;
                throw wrapper.transientNameServerBadHost();
            }
            if (initialPort == 0) {
                initialPort = 900;
                props.put("org.omg.CORBA.ORBInitialPort", Integer.toString(initialPort));
            }
            props.put("com.sun.corba.ee.POA.ORBPersistentServerPort", Integer.toString(initialPort));
            org.omg.CORBA.ORB corb = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            TransientNameServer.trace("ORB object returned from init: " + corb);
            Object ns = TransientNameServer.initializeRootNamingContext(corb);
            ((ORB)corb).register_initial_reference("NamingService", ns);
            String stringifiedIOR = null;
            if (ns != null) {
                stringifiedIOR = corb.object_to_string(ns);
            } else {
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.exception", initialPort));
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.usage"));
                System.exit(1);
            }
            TransientNameServer.trace("name service created");
            System.out.println(CorbaResourceUtil.getText("tnameserv.hs1", stringifiedIOR));
            System.out.println(CorbaResourceUtil.getText("tnameserv.hs2", initialPort));
            System.out.println(CorbaResourceUtil.getText("tnameserv.hs3"));
            java.lang.Object object = sync = new java.lang.Object();
            synchronized (object) {
                sync.wait();
            }
        }
        catch (Exception e) {
            if (invalidHostOption) {
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.invalidhostoption"));
            } else if (orbInitialPort0) {
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.orbinitialport0"));
            } else {
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.exception", initialPort));
                NamingUtils.errprint(CorbaResourceUtil.getText("tnameserv.usage"));
            }
            e.printStackTrace();
        }
    }

    private TransientNameServer() {
    }
}

