/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol.giopmsgheaders;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orb.ObjectKeyCacheEntryNoObjectAdapterImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.AddressingDispositionException;
import com.sun.corba.ee.impl.protocol.CorbaRequestIdImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.IORAddressingInfo;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.TargetAddress;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.RequestPartitioningComponent;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ObjectKeyCacheEntry;
import com.sun.corba.ee.spi.orbutil.ORBClassLoader;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.protocol.CorbaRequestId;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.trace.Giop;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.IOP.TaggedProfile;

@Giop
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public abstract class MessageBase
implements Message {
    public byte[] giopHeader;
    private ByteBuffer byteBuffer;
    private int threadPoolToUse;
    private byte encodingVersion = 0;
    private static ORBUtilSystemException wrapper;
    private static SynchronizedHolder __$mm$__0;

    public static String typeToString(int type) {
        return MessageBase.typeToString((byte)type);
    }

    public static String typeToString(byte type) {
        String result = type + "/";
        switch (type) {
            case 0: {
                result = result + "GIOPRequest";
                break;
            }
            case 1: {
                result = result + "GIOPReply";
                break;
            }
            case 2: {
                result = result + "GIOPCancelRequest";
                break;
            }
            case 3: {
                result = result + "GIOPLocateRequest";
                break;
            }
            case 4: {
                result = result + "GIOPLocateReply";
                break;
            }
            case 5: {
                result = result + "GIOPCloseConnection";
                break;
            }
            case 6: {
                result = result + "GIOPMessageError";
                break;
            }
            case 7: {
                result = result + "GIOPFragment";
                break;
            }
            default: {
                result = result + "Unknown";
            }
        }
        return result;
    }

    public static MessageBase readGIOPMessage(ORB orb, CorbaConnection connection) {
        MessageBase msg = MessageBase.readGIOPHeader(orb, connection);
        msg = (MessageBase)MessageBase.readGIOPBody(orb, connection, msg);
        return msg;
    }

    public static MessageBase readGIOPHeader(ORB orb, CorbaConnection connection) {
        ByteBuffer buf = null;
        try {
            buf = connection.read(12, 0, 12);
        }
        catch (IOException e) {
            throw wrapper.ioexceptionWhenReadingConnection(e, (Object)connection.toString());
        }
        MessageBase msg = MessageBase.parseGiopHeader(orb, connection, buf, 0);
        return msg;
    }

    public static MessageBase parseGiopHeader(ORB orb, CorbaConnection connection, ByteBuffer buf, int startPosition) {
        int b4;
        int b3;
        int b2;
        int b1;
        int magic;
        CorbaTransportManager ctm = orb.getTransportManager();
        MessageTraceManagerImpl mtm = (MessageTraceManagerImpl)ctm.getMessageTraceManager();
        if (mtm.isEnabled()) {
            mtm.recordHeaderReceived(buf);
        }
        byte[] it = new byte[12];
        buf.position(startPosition);
        buf.get(it);
        if (orb.giopDebugFlag) {
            ByteBuffer viewBuf = ByteBuffer.wrap(it);
            viewBuf.position(viewBuf.limit());
            MessageBase.dprint(".parseGIOPHeader: " + MessageBase.typeToString(it[7]));
            MessageBase.dprint(".parseGIOPHeader: GIOP header is: ");
            ORBUtility.printBuffer("GIOP Message Header", viewBuf, System.out);
        }
        if ((magic = (b1 = it[0] << 24 & 0xFF000000) | (b2 = it[1] << 16 & 0xFF0000) | (b3 = it[2] << 8 & 0xFF00) | (b4 = it[3] << 0 & 0xFF)) != 1195986768) {
            throw wrapper.giopMagicError(CompletionStatus.COMPLETED_MAYBE);
        }
        byte requestEncodingVersion = 0;
        if (it[4] == GIOPVersion.V13_XX.getMajor() && it[5] <= 1 && it[5] > 0) {
            requestEncodingVersion = it[5];
            buf.put(startPosition + 4, GIOPVersion.V1_2.getMajor());
            buf.put(startPosition + 5, GIOPVersion.V1_2.getMinor());
            it[4] = GIOPVersion.V1_2.getMajor();
            it[5] = GIOPVersion.V1_2.getMinor();
        }
        GIOPVersion orbVersion = orb.getORBData().getGIOPVersion();
        if (orb.giopDebugFlag) {
            MessageBase.dprint(".parseGIOPHeader: Message GIOP version: " + it[4] + '.' + it[5]);
            MessageBase.dprint(".parseGIOPHeader: ORB Max GIOP Version: " + orbVersion);
        }
        if ((it[4] > orbVersion.getMajor() || it[4] == orbVersion.getMajor() && it[5] > orbVersion.getMinor()) && it[7] != 6) {
            throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
        }
        MessageBase.AreFragmentsAllowed(it[4], it[5], it[6], it[7]);
        MessageBase msg = null;
        switch (it[7]) {
            case 0: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating RequestMessage");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new RequestMessage_1_0(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new RequestMessage_1_1(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new RequestMessage_1_2(orb);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 3: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating LocateRequestMessage");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new LocateRequestMessage_1_0(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new LocateRequestMessage_1_1(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new LocateRequestMessage_1_2(orb);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating CancelRequestMessage");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new CancelRequestMessage_1_0();
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new CancelRequestMessage_1_1();
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new CancelRequestMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating ReplyMessage");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new ReplyMessage_1_0(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new ReplyMessage_1_1(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new ReplyMessage_1_2(orb);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 4: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating LocateReplyMessage");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new LocateReplyMessage_1_0(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new LocateReplyMessage_1_1(orb);
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new LocateReplyMessage_1_2(orb);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 5: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: received CloseConnection message");
                }
                connection.purgeCalls((SystemException)wrapper.connectionRebind(), false, true);
                throw wrapper.connectionRebind();
            }
            case 6: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating Message for CloseConnection or MessageError");
                }
                if (it[4] == 1 && it[5] == 0) {
                    msg = new Message_1_0();
                    break;
                }
                if (it[4] == 1 && it[5] == 1) {
                    msg = new Message_1_1();
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new Message_1_1();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 7: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: creating FragmentMessage");
                }
                if (it[4] == 1 && it[5] == 0) break;
                if (it[4] == 1 && it[5] == 1) {
                    msg = new FragmentMessage_1_1();
                    break;
                }
                if (it[4] == 1 && it[5] == 2) {
                    msg = new FragmentMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (orb.giopDebugFlag) {
                    MessageBase.dprint(".parseGIOPHeader: UNKNOWN MESSAGE TYPE: " + it[7]);
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (it[4] == 1 && it[5] == 0) {
            Message_1_0 msg10 = (Message_1_0)msg;
            msg10.magic = magic;
            msg10.GIOP_version = new GIOPVersion(it[4], it[5]);
            msg10.byte_order = it[6] == 1;
            msg.threadPoolToUse = 0;
            msg10.message_type = it[7];
            msg10.message_size = MessageBase.readSize(it[8], it[9], it[10], it[11], msg10.isLittleEndian()) + 12;
        } else {
            Message_1_1 msg11 = (Message_1_1)msg;
            msg11.magic = magic;
            msg11.GIOP_version = new GIOPVersion(it[4], it[5]);
            msg11.flags = (byte)(it[6] & 3);
            msg.threadPoolToUse = it[6] >>> 2 & 0x3F;
            msg11.message_type = it[7];
            msg11.message_size = MessageBase.readSize(it[8], it[9], it[10], it[11], msg11.isLittleEndian()) + 12;
            if (orb.giopSizeDebugFlag) {
                StringBuilder sb = new StringBuilder();
                sb.append(MessageBase.typeToString(msg11.message_type));
                sb.append("(");
                sb.append(msg11.message_size);
                sb.append(" bytes)");
                MessageBase.dprint(sb.toString());
            }
        }
        if (orb.giopDebugFlag) {
            MessageBase.dprint(".parseGIOPHeader: header construction complete.");
            ByteBuffer viewBuf = buf.asReadOnlyBuffer();
            byte[] msgBuf = new byte[12];
            viewBuf.position(startPosition).limit(startPosition + 12);
            viewBuf.get(msgBuf, 0, msgBuf.length);
            msg.giopHeader = msgBuf;
        }
        msg.setByteBuffer(buf);
        msg.setEncodingVersion(requestEncodingVersion);
        return msg;
    }

    public static Message readGIOPBody(ORB orb, CorbaConnection connection, Message msg) {
        CorbaTransportManager ctm = orb.getTransportManager();
        MessageTraceManagerImpl mtm = (MessageTraceManagerImpl)ctm.getMessageTraceManager();
        ByteBuffer buf = msg.getByteBuffer();
        buf.position(12);
        int msgSizeMinusHeader = msg.getSize() - 12;
        try {
            buf = connection.read(buf, 12, msgSizeMinusHeader);
        }
        catch (IOException e) {
            throw wrapper.ioexceptionWhenReadingConnection(e, (Object)connection.toString());
        }
        msg.setByteBuffer(buf);
        if (mtm.isEnabled()) {
            mtm.recordBodyReceived(buf);
        }
        if (orb.giopDebugFlag) {
            ByteBuffer viewBuf = buf.asReadOnlyBuffer();
            viewBuf.limit(buf.capacity()).position(buf.limit());
            MessageBase.dprint(".readGIOPBody: received message:");
            ORBUtility.printBuffer("GIOP Message Body", viewBuf, System.out);
        }
        return msg;
    }

    private static RequestMessage createRequest(ORB orb, GIOPVersion gv, byte encodingVersion, int request_id, boolean response_expected, byte[] object_key, String operation, ServiceContexts service_contexts, Principal requesting_principal) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new RequestMessage_1_0(orb, service_contexts, request_id, response_expected, object_key, operation, requesting_principal);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new RequestMessage_1_1(orb, service_contexts, request_id, response_expected, new byte[]{0, 0, 0}, object_key, operation, requesting_principal);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            byte response_flags = 3;
            response_flags = response_expected ? (byte)3 : 0;
            TargetAddress target = new TargetAddress();
            target.object_key(object_key);
            RequestMessage_1_2 msg = new RequestMessage_1_2(orb, request_id, response_flags, new byte[]{0, 0, 0}, target, operation, service_contexts);
            msg.setEncodingVersion(encodingVersion);
            return msg;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static RequestMessage createRequest(ORB orb, GIOPVersion gv, byte encodingVersion, int request_id, boolean response_expected, IOR ior, short addrDisp, String operation, ServiceContexts service_contexts, Principal requesting_principal) {
        RequestMessage requestMessage = null;
        IIOPProfile profile = ior.getProfile();
        if (addrDisp == 0) {
            profile = ior.getProfile();
            ObjectKey objKey = profile.getObjectKey();
            byte[] object_key = objKey.getBytes((org.omg.CORBA.ORB)orb);
            requestMessage = MessageBase.createRequest(orb, gv, encodingVersion, request_id, response_expected, object_key, operation, service_contexts, requesting_principal);
        } else {
            if (!gv.equals(GIOPVersion.V1_2)) {
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            byte response_flags = 3;
            response_flags = response_expected ? (byte)3 : 0;
            TargetAddress target = new TargetAddress();
            if (addrDisp == 1) {
                profile = ior.getProfile();
                target.profile(profile.getIOPProfile());
            } else if (addrDisp == 2) {
                IORAddressingInfo iorInfo = new IORAddressingInfo(0, ior.getIOPIOR());
                target.ior(iorInfo);
            } else {
                throw wrapper.illegalTargetAddressDisposition(CompletionStatus.COMPLETED_NO);
            }
            requestMessage = new RequestMessage_1_2(orb, request_id, response_flags, new byte[]{0, 0, 0}, target, operation, service_contexts);
            requestMessage.setEncodingVersion(encodingVersion);
        }
        if (gv.supportsIORIIOPProfileComponents()) {
            int poolToUse = 0;
            IIOPProfileTemplate temp = (IIOPProfileTemplate)profile.getTaggedProfileTemplate();
            Iterator<TaggedComponent> iter = temp.iteratorById(1398099457);
            if (iter.hasNext()) {
                poolToUse = ((RequestPartitioningComponent)iter.next()).getRequestPartitioningId();
            }
            if (poolToUse < 0 || poolToUse > 63) {
                throw wrapper.invalidRequestPartitioningId(poolToUse, 0, 63);
            }
            requestMessage.setThreadPoolToUse(poolToUse);
        }
        return requestMessage;
    }

    public static ReplyMessage createReply(ORB orb, GIOPVersion gv, byte encodingVersion, int request_id, int reply_status, ServiceContexts service_contexts, IOR ior) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new ReplyMessage_1_0(orb, service_contexts, request_id, reply_status, ior);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new ReplyMessage_1_1(orb, service_contexts, request_id, reply_status, ior);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            ReplyMessage_1_2 msg = new ReplyMessage_1_2(orb, request_id, reply_status, service_contexts, ior);
            msg.setEncodingVersion(encodingVersion);
            return msg;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateRequestMessage createLocateRequest(ORB orb, GIOPVersion gv, byte encodingVersion, int request_id, byte[] object_key) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new LocateRequestMessage_1_0(orb, request_id, object_key);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new LocateRequestMessage_1_1(orb, request_id, object_key);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            TargetAddress target = new TargetAddress();
            target.object_key(object_key);
            LocateRequestMessage_1_2 msg = new LocateRequestMessage_1_2(orb, request_id, target);
            msg.setEncodingVersion(encodingVersion);
            return msg;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateReplyMessage createLocateReply(ORB orb, GIOPVersion gv, byte encodingVersion, int request_id, int locate_status, IOR ior) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new LocateReplyMessage_1_0(orb, request_id, locate_status, ior);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new LocateReplyMessage_1_1(orb, request_id, locate_status, ior);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            LocateReplyMessage_1_2 msg = new LocateReplyMessage_1_2(orb, request_id, locate_status, ior);
            msg.setEncodingVersion(encodingVersion);
            return msg;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static CancelRequestMessage createCancelRequest(GIOPVersion gv, int request_id) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new CancelRequestMessage_1_0(request_id);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new CancelRequestMessage_1_1(request_id);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            return new CancelRequestMessage_1_2(request_id);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createCloseConnection(GIOPVersion gv) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 5, 0);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 5, 0);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 5, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createMessageError(GIOPVersion gv) {
        if (gv.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 6, 0);
        }
        if (gv.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 6, 0);
        }
        if (gv.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 6, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static void setFlag(ByteBuffer byteBuffer, int flag) {
        byte b = byteBuffer.get(6);
        b = (byte)(b | flag);
        byteBuffer.put(6, b);
    }

    private static void AreFragmentsAllowed(byte major, byte minor, byte flag, byte msgType) {
        if (major == 1 && minor == 0 && msgType == 7) {
            throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
        }
        if ((flag & 2) == 2) {
            switch (msgType) {
                case 2: 
                case 5: 
                case 6: {
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
                case 3: 
                case 4: {
                    if (major != 1 || minor != 1) break;
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
    }

    static ObjectKeyCacheEntry extractObjectKeyCacheEntry(TargetAddress target, ORB orb) {
        short orbTargetAddrPref = orb.getORBData().getGIOPTargetAddressPreference();
        short reqAddrDisp = target.discriminator();
        switch (orbTargetAddrPref) {
            case 0: {
                if (reqAddrDisp == 0) break;
                throw new AddressingDispositionException(0);
            }
            case 1: {
                if (reqAddrDisp == 1) break;
                throw new AddressingDispositionException(1);
            }
            case 2: {
                if (reqAddrDisp == 2) break;
                throw new AddressingDispositionException(2);
            }
            case 3: {
                break;
            }
            default: {
                throw wrapper.orbTargetAddrPreferenceInExtractObjectkeyInvalid();
            }
        }
        try {
            Object result = null;
            switch (reqAddrDisp) {
                case 0: {
                    byte[] objKey = target.object_key();
                    if (objKey == null) break;
                    return orb.extractObjectKeyCacheEntry(objKey);
                }
                case 1: {
                    IIOPProfile iiopProfile = null;
                    TaggedProfile profile = target.profile();
                    if (profile == null) break;
                    iiopProfile = IIOPFactories.makeIIOPProfile(orb, profile);
                    ObjectKey objectKey = iiopProfile.getObjectKey();
                    return new ObjectKeyCacheEntryNoObjectAdapterImpl(objectKey);
                }
                case 2: {
                    IORAddressingInfo iorInfo = target.ior();
                    if (iorInfo == null) break;
                    TaggedProfile profile = iorInfo.ior.profiles[iorInfo.selected_profile_index];
                    IIOPProfile iiopProfile = IIOPFactories.makeIIOPProfile(orb, profile);
                    ObjectKey objectKey = iiopProfile.getObjectKey();
                    return new ObjectKeyCacheEntryNoObjectAdapterImpl(objectKey);
                }
            }
        }
        catch (Exception e) {
            throw wrapper.invalidObjectKey(e);
        }
        throw wrapper.invalidObjectKey();
    }

    private static int readSize(byte b1, byte b2, byte b3, byte b4, boolean littleEndian) {
        int a4;
        int a3;
        int a2;
        int a1;
        if (!littleEndian) {
            a1 = b1 << 24 & 0xFF000000;
            a2 = b2 << 16 & 0xFF0000;
            a3 = b3 << 8 & 0xFF00;
            a4 = b4 << 0 & 0xFF;
        } else {
            a1 = b4 << 24 & 0xFF000000;
            a2 = b3 << 16 & 0xFF0000;
            a3 = b2 << 8 & 0xFF00;
            a4 = b1 << 0 & 0xFF;
        }
        return a1 | a2 | a3 | a4;
    }

    static void nullCheck(Object obj) {
        if (obj == null) {
            throw wrapper.nullNotAllowed();
        }
    }

    static SystemException getSystemException(String exClassName, int minorCode, CompletionStatus completionStatus, String message, ORBUtilSystemException wrapper) {
        SystemException sysEx = null;
        try {
            Class clazz = ORBClassLoader.loadClass(exClassName);
            if (message == null) {
                sysEx = (SystemException)((Object)clazz.newInstance());
            } else {
                Class[] types = new Class[]{String.class};
                Constructor constructor = clazz.getConstructor(types);
                Object[] args = new Object[]{message};
                sysEx = (SystemException)((Object)constructor.newInstance(args));
            }
        }
        catch (Exception someEx) {
            throw wrapper.badSystemExceptionInReply(CompletionStatus.COMPLETED_MAYBE, someEx);
        }
        sysEx.minor = minorCode;
        sysEx.completed = completionStatus;
        return sysEx;
    }

    @Override
    public void callback(MessageHandler handler) throws IOException {
        handler.handleInput(this);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int getThreadPoolToUse() {
        return this.threadPoolToUse;
    }

    @Override
    public byte getEncodingVersion() {
        return this.encodingVersion;
    }

    @Override
    public void setEncodingVersion(byte version) {
        this.encodingVersion = version;
    }

    @Override
    public CorbaRequestId getCorbaRequestId() {
        return CorbaRequestIdImpl.UNKNOWN_CORBA_REQUEST_ID;
    }

    public static boolean messageSupportsFragments(Message message) {
        boolean result;
        ByteBuffer byteBuffer = message.getByteBuffer();
        byte major = byteBuffer.get(4);
        byte minor = byteBuffer.get(5);
        byte msgType = byteBuffer.get(7);
        if (major == 1 && minor == 2) {
            switch (msgType) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 7: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (major == 1 && minor == 1) {
            switch (msgType) {
                case 0: 
                case 1: 
                case 7: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public static CorbaRequestId getRequestIdFromMessageBytes(Message message) {
        ByteBuffer byteBuffer = message.getByteBuffer();
        byte major = byteBuffer.get(4);
        byte minor = byteBuffer.get(5);
        if (major == 1 && minor == 2 && message.getSize() >= 16) {
            CorbaRequestIdImpl requestId = new CorbaRequestIdImpl(MessageBase.unmarshalRequestHeaderRequestId(message));
            return requestId;
        }
        return CorbaRequestIdImpl.UNKNOWN_CORBA_REQUEST_ID;
    }

    private static int unmarshalRequestHeaderRequestId(Message message) {
        int b4;
        int b3;
        int b2;
        int b1;
        ByteBuffer byteBuffer = message.getByteBuffer();
        int offset = 12;
        if (!message.isLittleEndian()) {
            b1 = byteBuffer.get(12) << 24 & 0xFF000000;
            b2 = byteBuffer.get(13) << 16 & 0xFF0000;
            b3 = byteBuffer.get(14) << 8 & 0xFF00;
            b4 = byteBuffer.get(15) << 0 & 0xFF;
        } else {
            b1 = byteBuffer.get(15) << 24 & 0xFF000000;
            b2 = byteBuffer.get(14) << 16 & 0xFF0000;
            b3 = byteBuffer.get(13) << 8 & 0xFF00;
            b4 = byteBuffer.get(12) << 0 & 0xFF;
        }
        return b1 | b2 | b3 | b4;
    }

    private static void dprint(String msg) {
        ORBUtility.dprint("MessageBase", msg);
    }

    static {
        MethodMonitorRegistry.registerClass(MessageBase.class);
        wrapper = ORB.getStaticLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
    }
}

