/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.tf;

import com.sun.corba.ee.spi.orbutil.generic.Algorithms;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEventController;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerManager;
import com.sun.corba.ee.spi.orbutil.newtimer.TimingPointType;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorBase;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorFactory;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMonitorFactoryDefaults {
    private static Map<String, String> prefixTable = new HashMap<String, String>();
    private static MethodMonitorFactory operationTracerImpl = new MethodMonitorFactory(){

        @Override
        public MethodMonitor create(final Class<?> cls) {
            return new MethodMonitor(){

                @Override
                public Class<?> myClass() {
                    return cls;
                }

                @Override
                public void enter(int ident, Object ... args) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    OperationTracer.enter(mname, args);
                }

                @Override
                public void info(Object[] args, int callerIdent, int selfIdent) {
                }

                @Override
                public void exit(int ident) {
                    OperationTracer.exit();
                }

                @Override
                public void exit(int ident, Object result) {
                    OperationTracer.exit();
                }

                @Override
                public void exception(int ident, Throwable thr) {
                }

                @Override
                public void clear() {
                    OperationTracer.clear();
                }
            };
        }
    };
    private static MethodMonitorFactory dprintImpl = new MethodMonitorFactory(){
        private static final boolean USE_LOGGER = false;

        @Override
        public MethodMonitor create(final Class<?> cls) {
            return new MethodMonitorBase(cls){
                final String loggerName;
                final String sourceClassName;
                {
                    super(x0);
                    this.loggerName = null;
                    this.sourceClassName = MethodMonitorFactoryDefaults.compressClassName(cls.getName());
                }

                public synchronized void dprint(String mname, String msg) {
                    String prefix = "(" + Thread.currentThread().getName() + "): ";
                    System.out.println(prefix + this.sourceClassName + "." + mname + msg);
                }

                private String makeString(Object ... args) {
                    if (args.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append('(');
                    boolean first = true;
                    for (Object obj : args) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(' ');
                        }
                        sb.append(Algorithms.convertToString((Object)obj));
                    }
                    sb.append(')');
                    return sb.toString();
                }

                @Override
                public void enter(int ident, Object ... args) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    String str = this.makeString(args);
                    this.dprint(mname, "->" + str);
                }

                @Override
                public void exception(int ident, Throwable thr) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, ":throw:" + thr);
                }

                @Override
                public void info(Object[] args, int callerId, int selfId) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, callerId);
                    String infoName = MethodMonitorRegistry.getMethodName(cls, selfId);
                    String str = this.makeString(args);
                    this.dprint(mname, "::(" + infoName + ")" + str);
                }

                @Override
                public void exit(int ident) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, "<-");
                }

                @Override
                public void exit(int ident, Object retVal) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, "<-(" + retVal + ")");
                }

                @Override
                public void clear() {
                }
            };
        }
    };
    private static MethodMonitorFactory noOpImpl = new MethodMonitorFactory(){

        @Override
        public MethodMonitor create(Class<?> cls) {
            return new MethodMonitorBase(cls){

                @Override
                public void enter(int ident, Object ... args) {
                }

                @Override
                public void info(Object[] args, int callerId, int selfId) {
                }

                @Override
                public void exit(int ident) {
                }

                @Override
                public void exit(int ident, Object result) {
                }

                @Override
                public void exception(int ident, Throwable thr) {
                }

                @Override
                public void clear() {
                }
            };
        }
    };

    private MethodMonitorFactoryDefaults() {
    }

    public static void addPrefix(String pkg, String symbol) {
        if (pkg.charAt(pkg.length() - 1) == '.') {
            String str = pkg;
        } else {
            String str = pkg + '.';
        }
        prefixTable.put(pkg, symbol);
    }

    private static String compressClassName(String name) {
        for (Map.Entry<String, String> entry : prefixTable.entrySet()) {
            if (!name.startsWith(entry.getKey())) continue;
            return "(" + entry.getValue() + ")." + name.substring(entry.getKey().length());
        }
        return name;
    }

    public static <T> MethodMonitorFactory makeTimingImpl(final TimerManager<T> tm) {
        return new MethodMonitorFactory(){

            @Override
            public MethodMonitor create(final Class<?> cls) {
                return new MethodMonitorBase(cls){
                    private TimerEventController tec;
                    private final List<Timer> timers;
                    private final List<TimingPointType> timerTypes;
                    {
                        super(x0);
                        this.tec = tm.controller();
                        this.timers = tm.getTimers(cls);
                        this.timerTypes = MethodMonitorRegistry.getTimerTypes(cls);
                    }

                    @Override
                    public void enter(int ident, Object ... args) {
                        Timer tp = this.timers.get(ident);
                        this.tec.enter(tp);
                    }

                    @Override
                    public void info(Object[] args, int callerId, int selfId) {
                        Timer tp = this.timers.get(selfId);
                        if (tp != null) {
                            TimingPointType tpt = this.timerTypes.get(selfId);
                            if (tpt == TimingPointType.ENTER) {
                                this.tec.enter(tp);
                            } else if (tpt == TimingPointType.EXIT) {
                                this.tec.exit(tp);
                            }
                        }
                    }

                    @Override
                    public void exit(int ident) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void exit(int ident, Object result) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void exception(int ident, Throwable thr) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void clear() {
                    }
                };
            }
        };
    }

    public static MethodMonitorFactory operationTracer() {
        return operationTracerImpl;
    }

    public static MethodMonitorFactory noOp() {
        return noOpImpl;
    }

    public static MethodMonitorFactory dprint() {
        return dprintImpl;
    }

    public static MethodMonitorFactory compose(final Collection<MethodMonitorFactory> factories) {
        return new MethodMonitorFactory(){

            @Override
            public MethodMonitor create(Class<?> cls) {
                if (factories.size() == 0) {
                    return null;
                }
                if (factories.size() == 1) {
                    MethodMonitorFactory mmf = factories.toArray(new MethodMonitorFactory[1])[0];
                    return mmf.create(cls);
                }
                final ArrayList<MethodMonitor> mms = new ArrayList<MethodMonitor>();
                for (MethodMonitorFactory f : factories) {
                    mms.add(f.create(cls));
                }
                return new MethodMonitorBase(cls){

                    @Override
                    public void enter(int ident, Object ... args) {
                        for (MethodMonitor mm : mms) {
                            mm.enter(ident, args);
                        }
                    }

                    @Override
                    public void info(Object[] args, int callerId, int selfId) {
                        for (MethodMonitor mm : mms) {
                            mm.info(args, callerId, selfId);
                        }
                    }

                    @Override
                    public void exit(int ident) {
                        for (MethodMonitor mm : mms) {
                            mm.exit(ident);
                        }
                    }

                    @Override
                    public void exit(int ident, Object result) {
                        for (MethodMonitor mm : mms) {
                            mm.exit(ident, result);
                        }
                    }

                    @Override
                    public void exception(int ident, Throwable thr) {
                        for (MethodMonitor mm : mms) {
                            mm.exception(ident, thr);
                        }
                    }

                    @Override
                    public void clear() {
                        for (MethodMonitor mm : mms) {
                            mm.clear();
                        }
                    }
                };
            }
        };
    }

    public static class OperationTracer {
        private static boolean enabled = true;
        private static ThreadLocal<List<Pair<String, Object[]>>> state = new ThreadLocal<List<Pair<String, Object[]>>>(){

            @Override
            public List<Pair<String, Object[]>> initialValue() {
                return new ArrayList<Pair<String, Object[]>>();
            }
        };

        public static void enable() {
            enabled = true;
        }

        public static void disable() {
            enabled = false;
        }

        private OperationTracer() {
        }

        private static String format(Pair<String, Object[]> arg) {
            String name = (String)arg.first();
            Object[] args = (Object[])arg.second();
            StringBuilder sb = new StringBuilder();
            if (name == null) {
                sb.append("!NULL_NAME!");
            } else {
                sb.append(name);
            }
            sb.append('(');
            boolean first = true;
            for (Object obj : args) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(Algorithms.convertToString((Object)obj));
            }
            sb.append(')');
            return sb.toString();
        }

        public static String getAsString() {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            List<Pair<String, Object[]>> elements = state.get();
            int ctr = 0;
            for (Pair<String, Object[]> elem : elements) {
                fmt.format("\n\t(%3d): %s", ctr++, OperationTracer.format(elem));
            }
            return sb.toString();
        }

        public static void clear() {
            if (enabled) {
                state.get().clear();
            }
        }

        public static void enter(String name, Object ... args) {
            if (enabled) {
                state.get().add((Pair<String, Object[]>)new Pair((Object)name, (Object)args));
            }
        }

        public static void exit() {
            List<Pair<String, Object[]>> elements;
            int size;
            if (enabled && (size = (elements = state.get()).size()) > 0) {
                elements.remove(size - 1);
            }
        }
    }
}

