/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.MultiSet;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.protocol.PIHandler;
import com.sun.corba.ee.spi.trace.Poa;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.ParameterNames;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

@Poa
@ManagedObject
@Description(value="A POAManager which controls invocations of its POAs")
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class POAManagerImpl
extends LocalObject
implements POAManager {
    private static final long serialVersionUID = -751471445699682659L;
    private final POAFactory factory;
    private ORB orb;
    private State state;
    private Set<POAImpl> poas = new HashSet<POAImpl>(4);
    private int nInvocations = 0;
    private int nWaiters = 0;
    private int myId = 0;
    private boolean explicitStateChange;
    private static ThreadLocal<MultiSet<POAManagerImpl>> activeManagers;
    private static SynchronizedHolder __$mm$__0;

    @ManagedAttribute
    @Description(value="The set of POAs managed by this POAManager")
    Set<POAImpl> getManagedPOAs() {
        return new HashSet<POAImpl>(this.poas);
    }

    @ManagedAttribute
    @Description(value="Number of active invocations executing in this POAManager")
    public synchronized int numberOfInvocations() {
        return this.nInvocations;
    }

    @ManagedAttribute
    @Description(value="Number of threads waiting for invocations to complete in this POAManager")
    public synchronized int numberOfWaiters() {
        return this.nWaiters;
    }

    @ManagedAttribute
    @Description(value="The current state of this POAManager")
    public synchronized String displayState() {
        return this.stateToString(this.state);
    }

    private String stateToString(State state) {
        switch (state.value()) {
            case 0: {
                return "HOLDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "DISCARDING";
            }
            case 3: {
                return "INACTIVE";
            }
        }
        return "State[UNKNOWN]";
    }

    public int hashCode() {
        return this.myId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof POAManagerImpl)) {
            return false;
        }
        POAManagerImpl other = (POAManagerImpl)((Object)obj);
        return other.myId == this.myId;
    }

    public synchronized String toString() {
        return "POAManagerImpl[" + this.myId + "," + this.stateToString(this.state) + ",nInvocations=" + this.nInvocations + ",nWaiters=" + this.nWaiters + "]";
    }

    @ManagedAttribute
    @Description(value="The POAFactory that manages this POAManager")
    POAFactory getFactory() {
        return this.factory;
    }

    PIHandler getPIHandler() {
        return this.orb.getPIHandler();
    }

    private void reportStateChange() {
        PIHandler pih = this.getPIHandler();
        if (pih != null) {
            pih.adapterManagerStateChanged(this.myId, this.getORTState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Poa
    private void countedWait() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(6, new Object[0]);
        }
        try {
            void __$mm$__;
            try {
                ++this.nWaiters;
                ((Object)((Object)this)).wait((long)this.nWaiters * 1000L);
                --this.nWaiters;
            }
            catch (InterruptedException interruptedException) {
                --this.nWaiters;
                catch (Throwable throwable) {
                    --this.nWaiters;
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(6, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(6);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(6);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void nWaiters(int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{n}, n2, 12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    private void notifyWaiters() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(13, new Object[0]);
        }
        try {
            void __$mm$__;
            this.nWaiters(this.nWaiters, (MethodMonitor)__$mm$__, 13);
            if (this.nWaiters > 0) {
                ((Object)((Object)this)).notifyAll();
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(13);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(13);
            }
            throw throwable;
        }
    }

    @ManagedAttribute
    @NameValue
    @Description(value="The ID of this POAManager")
    public int getManagerId() {
        return this.myId;
    }

    POAManagerImpl(POAFactory factory, ORB orb) {
        this.factory = factory;
        factory.addPoaManager(this);
        this.orb = orb;
        this.myId = factory.newPOAManagerId();
        this.state = State.HOLDING;
        this.explicitStateChange = false;
    }

    synchronized void addPOA(POA poa) {
        if (this.state.value() == 3) {
            POASystemException wrapper = this.factory.getWrapper();
            throw wrapper.addPoaInactive(CompletionStatus.COMPLETED_NO);
        }
        this.poas.add((POAImpl)poa);
    }

    synchronized void removePOA(POA poa) {
        this.poas.remove((POAImpl)poa);
        if (this.poas.isEmpty()) {
            this.factory.removePoaManager(this);
        }
    }

    @ManagedAttribute
    @Description(value="The ObjectReferenceTemplate state of this POAManager")
    public short getORTState() {
        switch (this.state.value()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @Description(value="Make this POAManager active, so it can handle new requests")
    public synchronized void activate() throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[0]);
        }
        try {
            void __$mm$__;
            this.explicitStateChange = true;
            if (this.state.value() == 3) {
                AdapterInactive adapterInactive = new AdapterInactive();
                if (__$mm$__ != null) {
                    __$mm$__.exception(0, (Throwable)adapterInactive);
                }
                throw adapterInactive;
            }
            this.state = State.ACTIVE;
            this.reportStateChange();
            this.notifyWaiters();
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @Description(value="Hold all requests to this POAManager")
    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(11, new Object[]{bl});
        }
        try {
            void wait_for_completion;
            void __$mm$__;
            this.explicitStateChange = true;
            if (this.state.value() == 3) {
                AdapterInactive adapterInactive = new AdapterInactive();
                if (__$mm$__ != null) {
                    __$mm$__.exception(11, (Throwable)adapterInactive);
                }
                throw adapterInactive;
            }
            this.state = State.HOLDING;
            this.reportStateChange();
            this.notifyWaiters();
            if (wait_for_completion != false) {
                while (this.state.value() == 0 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(11);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(11);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @ParameterNames(value={"waitForCompletion"})
    @Description(value="Make this POAManager discard all incoming requests")
    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(8, new Object[]{bl});
        }
        try {
            void wait_for_completion;
            void __$mm$__;
            this.explicitStateChange = true;
            if (this.state.value() == 3) {
                AdapterInactive adapterInactive = new AdapterInactive();
                if (__$mm$__ != null) {
                    __$mm$__.exception(8, (Throwable)adapterInactive);
                }
                throw adapterInactive;
            }
            this.state = State.DISCARDING;
            this.reportStateChange();
            this.notifyWaiters();
            if (wait_for_completion != false) {
                while (this.state.value() == 2 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(8);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(7, new Object[]{bl, bl2});
        }
        try {
            void wait_for_completion;
            void etherealize_objects;
            void __$mm$__;
            POAManagerImpl pOAManagerImpl = this;
            synchronized (pOAManagerImpl) {
                try {
                    this.explicitStateChange = true;
                    if (this.state.value() == 3) {
                        AdapterInactive adapterInactive = new AdapterInactive();
                        if (__$mm$__ != null) {
                            __$mm$__.exception(7, (Throwable)adapterInactive);
                        }
                        throw adapterInactive;
                    }
                    this.state = State.INACTIVE;
                    this.reportStateChange();
                    this.notifyWaiters();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var5_4
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(7, throwable2);
                    }
                    throw throwable2;
                }
            }
            POAManagerDeactivator deactivator = new POAManagerDeactivator(this, (boolean)etherealize_objects);
            if (wait_for_completion != false) {
                deactivator.run();
            } else {
                Thread thr = new Thread(deactivator);
                thr.start();
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(7);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(7);
            }
            throw throwable;
        }
    }

    public State get_state() {
        return this.state;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @InfoMethod
    private void activeManagers(MultiSet multiSet, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{multiSet}, n, 2);
        }
    }

    @InfoMethod
    private void alreadyActive(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 4);
        }
    }

    @InfoMethod
    private void activeInDifferentPoaManager(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    private void checkState() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(5, new Object[0]);
        }
        try {
            void __$mm$__;
            MultiSet<POAManagerImpl> am = activeManagers.get();
            this.activeManagers(am, (MethodMonitor)__$mm$__, 5);
            block7: while (this.state.value() != 1) {
                switch (this.state.value()) {
                    case 0: {
                        if (am.contains((Object)this)) {
                            this.alreadyActive(this, (MethodMonitor)__$mm$__, 5);
                            if (__$mm$__ != null) {
                                __$mm$__.exit(5);
                            }
                            return;
                        }
                        if (am.size() == 0) {
                            while (this.state.value() == 0) {
                                this.countedWait();
                            }
                            continue block7;
                        }
                        this.activeInDifferentPoaManager((MethodMonitor)__$mm$__, 5);
                        TRANSIENT tRANSIENT = this.factory.getWrapper().poaManagerMightDeadlock();
                        if (__$mm$__ != null) {
                            __$mm$__.exception(5, (Throwable)tRANSIENT);
                        }
                        throw tRANSIENT;
                    }
                    case 2: {
                        TRANSIENT tRANSIENT = this.factory.getWrapper().poaDiscarding();
                        if (__$mm$__ != null) {
                            __$mm$__.exception(5, (Throwable)tRANSIENT);
                        }
                        throw tRANSIENT;
                    }
                    case 3: {
                        OBJ_ADAPTER oBJ_ADAPTER = this.factory.getWrapper().poaInactive();
                        if (__$mm$__ != null) {
                            __$mm$__.exception(5, (Throwable)oBJ_ADAPTER);
                        }
                        throw oBJ_ADAPTER;
                    }
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(5);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(5);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void addingThreadToActiveManagers(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 3);
        }
    }

    @InfoMethod
    private void removingThreadFromActiveManagers(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    synchronized void enter() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(9, new Object[0]);
        }
        try {
            void __$mm$__;
            this.checkState();
            ++this.nInvocations;
            activeManagers.get().add((Object)this);
            this.addingThreadToActiveManagers(this, (MethodMonitor)__$mm$__, 9);
            if (__$mm$__ != null) {
                __$mm$__.exit(9);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    synchronized void exit() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(10, new Object[0]);
        }
        try {
            void __$mm$__;
            try {
                activeManagers.get().remove((Object)this);
                this.removingThreadFromActiveManagers(this, (MethodMonitor)__$mm$__, 10);
                --this.nInvocations;
                if (this.nInvocations == 0) {
                    this.notifyWaiters();
                }
            }
            catch (Throwable throwable) {
                --this.nInvocations;
                if (this.nInvocations == 0) {
                    this.notifyWaiters();
                }
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(10, throwable2);
                }
                throw throwable2;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(10);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(10);
            }
            throw throwable;
        }
    }

    public synchronized void implicitActivation() {
        if (!this.explicitStateChange) {
            try {
                this.activate();
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    static {
        MethodMonitorRegistry.registerClass(POAManagerImpl.class);
        activeManagers = new ThreadLocal<MultiSet<POAManagerImpl>>(){

            @Override
            public MultiSet<POAManagerImpl> initialValue() {
                return new MultiSet();
            }
        };
    }

    @Poa
    @TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
    private static class POAManagerDeactivator
    implements Runnable {
        private boolean etherealize_objects;
        private final POAManagerImpl pmi;
        private static SynchronizedHolder __$mm$__0;

        @InfoMethod
        private void poaManagerDeactivatorCall(boolean bl, POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{bl, pOAManagerImpl}, n, 0);
            }
        }

        @InfoMethod
        private void preparingToEtherealize(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{pOAManagerImpl}, n, 1);
            }
        }

        @InfoMethod
        private void removeAndClear(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{pOAManagerImpl}, n, 2);
            }
        }

        POAManagerDeactivator(POAManagerImpl pmi, boolean etherealize_objects) {
            this.etherealize_objects = etherealize_objects;
            this.pmi = pmi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Poa
        public void run() {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(3, new Object[0]);
            }
            try {
                void __$mm$__;
                POAManagerImpl pOAManagerImpl = this.pmi;
                synchronized (pOAManagerImpl) {
                    try {
                        this.poaManagerDeactivatorCall(this.etherealize_objects, this.pmi, (MethodMonitor)__$mm$__, 3);
                        while (this.pmi.nInvocations > 0) {
                            this.pmi.countedWait();
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl15 : MonitorExitStatement: MONITOREXIT : var3_2
                        Throwable throwable2 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(3, throwable2);
                        }
                        throw throwable2;
                    }
                }
                if (this.etherealize_objects) {
                    HashSet copyOfPOAs;
                    POAManagerImpl pOAManagerImpl2 = this.pmi;
                    synchronized (pOAManagerImpl2) {
                        try {
                            this.preparingToEtherealize(this.pmi, (MethodMonitor)__$mm$__, 3);
                            copyOfPOAs = new HashSet(this.pmi.poas);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 19, 5, 8] lbl29 : MonitorExitStatement: MONITOREXIT : var4_4
                            Throwable throwable3 = throwable;
                            if (__$mm$__ != null) {
                                __$mm$__.exception(3, throwable3);
                            }
                            throw throwable3;
                        }
                    }
                    for (POAImpl poa : copyOfPOAs) {
                        poa.etherealizeAll();
                    }
                    pOAManagerImpl2 = this.pmi;
                    synchronized (pOAManagerImpl2) {
                        try {
                            this.removeAndClear(this.pmi, (MethodMonitor)__$mm$__, 3);
                            this.pmi.factory.removePoaManager(this.pmi);
                            this.pmi.poas.clear();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 19, 6, 9] lbl48 : MonitorExitStatement: MONITOREXIT : var4_4
                            Throwable throwable4 = throwable;
                            if (__$mm$__ != null) {
                                __$mm$__.exception(3, throwable4);
                            }
                            throw throwable4;
                        }
                    }
                }
                if (__$mm$__ != null) {
                    __$mm$__.exit(3);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(3);
                }
                throw throwable;
            }
        }

        static {
            MethodMonitorRegistry.registerClass(POAManagerDeactivator.class);
        }
    }
}

