/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected RuntimeException failureException;
    protected ORBUtilSystemException wrapper;
    private boolean usePRLB;
    protected TcpTimeouts tcpTimeouts;
    protected Iterator<CorbaContactInfo> effectiveTargetIORIterator;
    protected CorbaContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected boolean retryWithPreviousContactInfo;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected CorbaContactInfo primaryContactInfo;
    protected List<CorbaContactInfo> listOfContactInfos;
    protected TcpTimeouts.Waiter waiter;
    protected Set<CorbaContactInfo> failedEndpoints;
    private static SynchronizedHolder __$mm$__0;

    public CorbaContactInfoListIteratorImpl(ORB orb, CorbaContactInfoList corbaContactInfoList, CorbaContactInfo primaryContactInfo, List listOfContactInfos, boolean usePerRequestLoadBalancing) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.tcpTimeouts = orb.getORBData().getTransportTcpConnectTimeouts();
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = primaryContactInfo;
        if (listOfContactInfos != null) {
            this.effectiveTargetIORIterator = listOfContactInfos.iterator();
        }
        this.listOfContactInfos = listOfContactInfos;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.retryWithPreviousContactInfo = false;
        this.failureException = null;
        this.waiter = this.tcpTimeouts.waiter();
        this.failedEndpoints = new HashSet<CorbaContactInfo>();
        this.usePRLB = usePerRequestLoadBalancing;
        this.primaryToContactInfo = usePerRequestLoadBalancing ? null : orb.getORBData().getIIOPPrimaryToContactInfo();
    }

    @InfoMethod
    private void display(String string, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string}, n, 0);
        }
    }

    @InfoMethod
    private void display(String string, Object object, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, object}, n, 0);
        }
    }

    @InfoMethod
    private void display(String string, long l, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, l}, n, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public boolean hasNext() {
        boolean bl = false;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[0]);
        }
        try {
            boolean __$result$__;
            void __$mm$__;
            boolean result = false;
            if (this.retryWithPreviousContactInfo) {
                this.display("backoff before retry previous", (MethodMonitor)__$mm$__, 3);
                if (this.waiter.isExpired()) {
                    this.display("time to wait for connection exceeded ", this.tcpTimeouts.get_max_time_to_wait(), (MethodMonitor)__$mm$__, 3);
                    this.failureException = this.wrapper.communicationsRetryTimeout(this.failureException, (Object)Long.toString(this.tcpTimeouts.get_max_time_to_wait()));
                    __$result$__ = false;
                    if (__$mm$__ != null) {
                        __$mm$__.exit(3, (Object)__$result$__);
                    }
                    return __$result$__;
                }
                this.waiter.sleepTime();
                this.waiter.advance();
                __$result$__ = true;
                if (__$mm$__ != null) {
                    __$mm$__.exit(3, (Object)__$result$__);
                }
                return __$result$__;
            }
            if (this.isAddrDispositionRetry) {
                __$result$__ = true;
                if (__$mm$__ != null) {
                    __$mm$__.exit(3, (Object)__$result$__);
                }
                return __$result$__;
            }
            result = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
            if (!result && !this.waiter.isExpired()) {
                this.display("Reached end of ContactInfoList list. Starting at beginning", (MethodMonitor)__$mm$__, 3);
                this.previousContactInfo = null;
                if (this.primaryToContactInfo != null) {
                    this.primaryToContactInfo.reset(this.primaryContactInfo);
                } else {
                    this.effectiveTargetIORIterator = this.listOfContactInfos.iterator();
                }
                __$result$__ = result = this.hasNext();
                if (__$mm$__ != null) {
                    __$mm$__.exit(3, (Object)__$result$__);
                }
                return __$result$__;
            }
            __$result$__ = result;
            if (__$mm$__ != null) {
                __$mm$__.exit(3, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3, (Object)bl);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public CorbaContactInfo next() {
        Object var1_1 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(4, new Object[0]);
        }
        try {
            void __$mm$__;
            CorbaContactInfo __$result$__;
            if (this.retryWithPreviousContactInfo) {
                this.retryWithPreviousContactInfo = false;
                __$result$__ = this.previousContactInfo;
                if (__$mm$__ != null) {
                    __$mm$__.exit(4, (Object)__$result$__);
                }
                return __$result$__;
            }
            if (this.isAddrDispositionRetry) {
                this.isAddrDispositionRetry = false;
                __$result$__ = this.previousContactInfo;
                if (__$mm$__ != null) {
                    __$mm$__.exit(4, (Object)__$result$__);
                }
                return __$result$__;
            }
            this.previousContactInfo = this.primaryToContactInfo != null ? this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.next();
            if (this.failedEndpoints.contains(this.previousContactInfo)) {
                this.failedEndpoints.clear();
                this.waiter.sleepTime();
                this.waiter.advance();
            }
            __$result$__ = this.previousContactInfo;
            if (__$mm$__ != null) {
                __$mm$__.exit(4, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(4, var1_1);
            }
            throw throwable;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CorbaContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void reportSuccess(CorbaContactInfo corbaContactInfo) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(8, new Object[]{corbaContactInfo});
        }
        try {
            void __$mm$__;
            void contactInfo;
            this.display("contactInfo", contactInfo, (MethodMonitor)__$mm$__, 8);
            this.failedEndpoints.clear();
            this.waiter.reset();
            if (__$mm$__ != null) {
                __$mm$__.exit(8);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public boolean reportException(CorbaContactInfo corbaContactInfo, RuntimeException runtimeException) {
        boolean bl = false;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(6, new Object[]{corbaContactInfo, runtimeException});
        }
        try {
            boolean __$result$__;
            void ex;
            void __$mm$__;
            void contactInfo;
            boolean result = false;
            this.display("contactInfo", contactInfo, (MethodMonitor)__$mm$__, 6);
            this.failedEndpoints.add((CorbaContactInfo)contactInfo);
            this.failureException = ex;
            if (ex instanceof COMM_FAILURE) {
                SystemException se = (SystemException)ex;
                if (se.minor == 1398079697) {
                    this.display("COMM_FAILURE(connection rebind): retry with previous contact info", ex, (MethodMonitor)__$mm$__, 6);
                    this.retryWithPreviousContactInfo = true;
                    __$result$__ = result = true;
                    if (__$mm$__ != null) {
                        __$mm$__.exit(6, (Object)__$result$__);
                    }
                    return __$result$__;
                }
                if (se.completed == CompletionStatus.COMPLETED_NO) {
                    if (this.hasNext()) {
                        this.display("COMM_FAILURE(COMPLETED_NO, hasNext true): retry with next contact info", ex, (MethodMonitor)__$mm$__, 6);
                        __$result$__ = result = true;
                        if (__$mm$__ != null) {
                            __$mm$__.exit(6, (Object)__$result$__);
                        }
                        return __$result$__;
                    }
                    if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                        this.display("COMM_FAILURE(COMPLETED_NO, hasNext false, effective != target): retry with target", ex, (MethodMonitor)__$mm$__, 6);
                        this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                        __$result$__ = result = true;
                        if (__$mm$__ != null) {
                            __$mm$__.exit(6, (Object)__$result$__);
                        }
                        return __$result$__;
                    }
                }
            } else if (ex instanceof TRANSIENT) {
                this.display("TRANSIENT: retry with previous contact info", ex, (MethodMonitor)__$mm$__, 6);
                this.retryWithPreviousContactInfo = true;
                __$result$__ = result = true;
                if (__$mm$__ != null) {
                    __$mm$__.exit(6, (Object)__$result$__);
                }
                return __$result$__;
            }
            result = false;
            this.waiter.reset();
            __$result$__ = result;
            if (__$mm$__ != null) {
                __$mm$__.exit(6, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(6, (Object)bl);
            }
            throw throwable;
        }
    }

    @Override
    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return this.orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil().invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void reportAddrDispositionRetry(CorbaContactInfo corbaContactInfo, short s) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(5, new Object[]{corbaContactInfo, s});
        }
        try {
            void __$mm$__;
            void disposition;
            this.previousContactInfo.setAddressingDisposition((short)disposition);
            this.isAddrDispositionRetry = true;
            this.waiter.reset();
            if (__$mm$__ != null) {
                __$mm$__.exit(5);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(5);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void reportRedirect(CorbaContactInfo corbaContactInfo, IOR iOR) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(7, new Object[]{corbaContactInfo, iOR});
        }
        try {
            void __$mm$__;
            void forwardedIOR;
            this.updateEffectiveTargetIOR((IOR)forwardedIOR);
            this.waiter.reset();
            if (__$mm$__ != null) {
                __$mm$__.exit(7);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(7);
            }
            throw throwable;
        }
    }

    public void updateEffectiveTargetIOR(IOR newIOR) {
        this.contactInfoList.setEffectiveTargetIOR(newIOR);
        CorbaContactInfoListImpl.setSkipRotate();
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }

    static {
        MethodMonitorRegistry.registerClass(CorbaContactInfoListIteratorImpl.class);
    }
}

