/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEventController;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactoryBuilder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.gmbal.ManagedObjectManager;

public class TimerManager<T> {
    private final TimerFactory tf;
    private final TimerEventController controller;
    private volatile T tp;
    private volatile boolean isInitialized = false;
    private final Map<Class<?>, List<Timer>> classToTimers = new HashMap();

    public TimerManager(ManagedObjectManager mom, String name, boolean doGmbalRegistration) {
        this.tf = TimerFactoryBuilder.make(mom, name, name, doGmbalRegistration);
        this.controller = this.tf.makeController(name);
    }

    public TimerManager(String name) {
        this(null, name, false);
    }

    public void destroy() {
        TimerFactoryBuilder.destroy(this.tf);
    }

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TimerManager is not initialized");
        }
    }

    public void initialize(T tp) {
        if (this.isInitialized) {
            throw new IllegalStateException("TimerManager is already initialized");
        }
        this.tp = tp;
        this.isInitialized = true;
    }

    public T points() {
        this.checkInitialized();
        return this.tp;
    }

    public TimerFactory factory() {
        return this.tf;
    }

    public TimerEventController controller() {
        return this.controller;
    }

    public synchronized List<Timer> getTimers(Class<?> cls) {
        this.checkInitialized();
        List<Timer> result = this.classToTimers.get(cls);
        if (result == null) {
            result = new ArrayList<Timer>();
            List<String> names = MethodMonitorRegistry.getTimerNames(cls);
            for (String name : names) {
                String tname = TimerFactoryBuilder.getTimerName(cls.getSimpleName(), name);
                Timer timer = this.tf.timers().get(tname);
                result.add(timer);
            }
            this.classToTimers.put(cls, result);
        }
        return result;
    }
}

