/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.MarkAndResetHandler;
import com.sun.corba.ee.impl.encoding.RestorableInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class BufferManagerReadStream
implements BufferManagerRead,
MarkAndResetHandler {
    private boolean receivedCancel = false;
    private int cancelReqId = 0;
    private boolean endOfStream = true;
    private BufferQueue fragmentQueue = new BufferQueue();
    private static final long FRAGMENT_TIMEOUT = 6000L;
    private final com.sun.corba.ee.spi.orb.ORB orb;
    private final ORBUtilSystemException wrapper;
    private boolean markEngaged = false;
    private LinkedList<ByteBufferWithInfo> fragmentStack = null;
    private RestorableInputStream inputStream = null;
    private Object streamMemento = null;
    private static SynchronizedHolder __$mm$__0;

    BufferManagerReadStream(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelProcessing(int requestId) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.receivedCancel = true;
            this.cancelReqId = requestId;
            this.fragmentQueue.notify();
        }
    }

    @InfoMethod
    private void bufferMessage(String string, int n, String string2, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, n, string2}, n2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void processFragment(ByteBuffer byteBuffer, FragmentMessage fragmentMessage) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(2, new Object[]{byteBuffer, fragmentMessage});
        }
        try {
            void __$mm$__;
            void msg;
            void byteBuffer2;
            ByteBufferWithInfo bbwi = new ByteBufferWithInfo((ORB)this.orb, (ByteBuffer)byteBuffer2, msg.getHeaderLength());
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                try {
                    if (this.orb.transportDebugFlag) {
                        int bbAddress = System.identityHashCode(byteBuffer2);
                        this.bufferMessage("processFragment() - queuing ByteByffer id (", bbAddress, ") to fragment queue.", (MethodMonitor)__$mm$__, 2);
                    }
                    this.fragmentQueue.enqueue(bbwi);
                    this.endOfStream = !msg.moreFragmentsToFollow();
                    this.fragmentQueue.notify();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var6_5
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(2, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(2);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(2);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void underflowMessage(String string, int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, n}, n2, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public ByteBufferWithInfo underflow(ByteBufferWithInfo byteBufferWithInfo) {
        Object var2_2 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[]{byteBufferWithInfo});
        }
        try {
            Object __$result$__;
            block24: {
                void __$mm$__;
                ByteBufferWithInfo result = null;
                try {
                    Object object = this.fragmentQueue;
                    synchronized (object) {
                        try {
                            Object bbwi;
                            if (this.receivedCancel) {
                                this.underflowMessage("underflow() - Cancel request id:", this.cancelReqId, (MethodMonitor)__$mm$__, 3);
                                RequestCanceledException requestCanceledException = new RequestCanceledException(this.cancelReqId);
                                if (__$mm$__ != null) {
                                    __$mm$__.exception(3, (Throwable)requestCanceledException);
                                }
                                throw requestCanceledException;
                            }
                            while (this.fragmentQueue.size() == 0) {
                                if (this.endOfStream) {
                                    MARSHAL mARSHAL = this.wrapper.endOfStream();
                                    if (__$mm$__ != null) {
                                        __$mm$__.exception(3, (Throwable)mARSHAL);
                                    }
                                    throw mARSHAL;
                                }
                                boolean interrupted = false;
                                try {
                                    this.fragmentQueue.wait(6000L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                                if (!interrupted && this.fragmentQueue.size() == 0) {
                                    COMM_FAILURE cOMM_FAILURE = this.wrapper.bufferReadManagerTimeout();
                                    if (__$mm$__ != null) {
                                        __$mm$__.exception(3, (Throwable)cOMM_FAILURE);
                                    }
                                    throw cOMM_FAILURE;
                                }
                                if (!this.receivedCancel) continue;
                                this.underflowMessage("underflow() - Cancel request id after wait:", this.cancelReqId, (MethodMonitor)__$mm$__, 3);
                                RequestCanceledException requestCanceledException = new RequestCanceledException(this.cancelReqId);
                                if (__$mm$__ != null) {
                                    __$mm$__.exception(3, (Throwable)requestCanceledException);
                                }
                                throw requestCanceledException;
                            }
                            result = this.fragmentQueue.dequeue();
                            result.setFragmented(true);
                            if (this.orb.transportDebugFlag) {
                                int bbAddr = System.identityHashCode(result.getByteBuffer());
                                this.bufferMessage("underflow() - dequeued ByteBuffer id (", bbAddr, ") from fragment queue.", (MethodMonitor)__$mm$__, 3);
                            }
                            if (!this.markEngaged && bbwi != null && bbwi.getByteBuffer() != null) {
                                ByteBufferPool byteBufferPool = this.getByteBufferPool();
                                if (this.orb.transportDebugFlag) {
                                    int bbAddress = System.identityHashCode(bbwi.getByteBuffer());
                                    this.bufferMessage("underflow() - releasing ByteBuffer id (", bbAddress, ") to ByteBufferPool.", (MethodMonitor)__$mm$__, 3);
                                }
                                byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
                                bbwi.setByteBuffer(null);
                                bbwi = null;
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 6] lbl56 : MonitorExitStatement: MONITOREXIT : var6_5
                            Throwable throwable2 = throwable;
                            if (__$mm$__ != null) {
                                __$mm$__.exception(3, throwable2);
                            }
                            throw throwable2;
                        }
                    }
                    __$result$__ = object = result;
                    if (__$mm$__ == null) break block24;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(3, throwable3);
                    }
                    throw throwable3;
                }
                __$mm$__.exit(3, __$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3, var2_2);
            }
            throw throwable;
        }
    }

    @Override
    public void init(Message msg) {
        if (msg != null) {
            this.endOfStream = !msg.moreFragmentsToFollow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void close(ByteBufferWithInfo byteBufferWithInfo) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(1, new Object[]{byteBufferWithInfo});
        }
        try {
            void __$mm$__;
            int bbAddress;
            void bbwi;
            int inputBbAddress = 0;
            if (bbwi != null) {
                inputBbAddress = System.identityHashCode(bbwi.getByteBuffer());
            }
            ByteBufferPool byteBufferPool = this.getByteBufferPool();
            if (this.fragmentQueue != null) {
                BufferQueue bufferQueue = this.fragmentQueue;
                synchronized (bufferQueue) {
                    try {
                        ByteBufferWithInfo abbwi = null;
                        while (this.fragmentQueue.size() != 0) {
                            abbwi = this.fragmentQueue.dequeue();
                            if (abbwi == null || abbwi.getByteBuffer() == null) continue;
                            if (this.orb.transportDebugFlag && inputBbAddress != (bbAddress = System.identityHashCode(abbwi.getByteBuffer()))) {
                                this.bufferMessage(" close() - fragmentQueue is  releasing ByteBuffer id (", bbAddress, ") to ByteBufferPool.", (MethodMonitor)__$mm$__, 1);
                            }
                            byteBufferPool.releaseByteBuffer(abbwi.getByteBuffer());
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 15] lbl24 : MonitorExitStatement: MONITOREXIT : var6_5
                        Throwable throwable2 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(1, throwable2);
                        }
                        throw throwable2;
                    }
                }
                this.fragmentQueue = null;
            }
            if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
                for (ByteBufferWithInfo abbwi : this.fragmentStack) {
                    if (abbwi == null || abbwi.getByteBuffer() == null || inputBbAddress == (bbAddress = System.identityHashCode(abbwi.getByteBuffer()))) continue;
                    if (this.orb.transportDebugFlag) {
                        this.bufferMessage("close() - fragmentStack - releasing ByteBuffer id (", bbAddress, ") to ByteBufferPool.", (MethodMonitor)__$mm$__, 1);
                    }
                    byteBufferPool.releaseByteBuffer(abbwi.getByteBuffer());
                }
                this.fragmentStack = null;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(1);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(1);
            }
            throw throwable;
        }
    }

    protected ByteBufferPool getByteBufferPool() {
        return this.orb.getByteBufferPool();
    }

    @Override
    public void mark(RestorableInputStream inputStream) {
        this.inputStream = inputStream;
        this.markEngaged = true;
        this.streamMemento = inputStream.createStreamMemento();
        if (this.fragmentStack != null) {
            this.fragmentStack.clear();
        }
    }

    @Override
    public void fragmentationOccured(ByteBufferWithInfo newFragment) {
        if (!this.markEngaged) {
            return;
        }
        if (this.fragmentStack == null) {
            this.fragmentStack = new LinkedList();
        }
        this.fragmentStack.addFirst(new ByteBufferWithInfo(newFragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this.markEngaged) {
            return;
        }
        this.markEngaged = false;
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                for (ByteBufferWithInfo bbwi : this.fragmentStack) {
                    this.fragmentQueue.push(bbwi);
                }
            }
            this.fragmentStack.clear();
        }
        this.inputStream.restoreInternalState(this.streamMemento);
    }

    @Override
    public MarkAndResetHandler getMarkAndResetHandler() {
        return this;
    }

    static {
        MethodMonitorRegistry.registerClass(BufferManagerReadStream.class);
    }
}

