/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.cosnaming;

import com.sun.corba.ee.impl.logging.NamingSystemException;
import com.sun.corba.ee.impl.naming.cosnaming.InternalBindingKey;
import com.sun.corba.ee.impl.naming.cosnaming.InternalBindingValue;
import com.sun.corba.ee.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.ee.impl.naming.cosnaming.NamingContextImpl;
import com.sun.corba.ee.impl.naming.cosnaming.TransientBindingIterator;
import com.sun.corba.ee.spi.logging.LogWrapperName;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TransientNamingContext
extends NamingContextImpl
implements NamingContextDataStore {
    private Logger readLogger;
    private Logger updateLogger;
    private Logger lifecycleLogger;
    private NamingSystemException wrapper;
    private final Map<InternalBindingKey, InternalBindingValue> bindingMap = new HashMap<InternalBindingKey, InternalBindingValue>();
    public Object localRoot;

    public TransientNamingContext(com.sun.corba.ee.spi.orb.ORB orb, Object initial, POA nsPOA) throws Exception {
        super(orb, nsPOA);
        this.wrapper = orb.getLogWrapperTable().get_NAMING_Naming();
        this.localRoot = initial;
        this.readLogger = com.sun.corba.ee.spi.orb.ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.read"));
        this.updateLogger = com.sun.corba.ee.spi.orb.ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.update"));
        this.lifecycleLogger = com.sun.corba.ee.spi.orb.ORB.getLogger(LogWrapperName.getLoggerName(orb, "naming.lifecycle"));
        this.lifecycleLogger.fine("Root TransientNamingContext LIFECYCLE.CREATED");
    }

    @Override
    public final void bindImpl(NameComponent n, Object obj, BindingType bt) throws SystemException {
        InternalBindingKey key = new InternalBindingKey(n);
        NameComponent[] name = new NameComponent[]{n};
        Binding b = new Binding(name, bt);
        InternalBindingValue value = new InternalBindingValue(b, null);
        value.theObjectRef = obj;
        InternalBindingValue oldValue = this.bindingMap.put(key, value);
        if (oldValue != null) {
            this.updateLogger.warning("<<NAMING BIND>>Name " + this.getName(n) + " Was Already Bound");
            throw this.wrapper.transNcBindAlreadyBound();
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING BIND>><<SUCCESS>>Name Component: " + n.id + "." + n.kind);
        }
    }

    @Override
    public final Object resolveImpl(NameComponent n, BindingTypeHolder bth) throws SystemException {
        if (n.id.length() == 0 && n.kind.length() == 0) {
            bth.value = BindingType.ncontext;
            return this.localRoot;
        }
        InternalBindingKey key = new InternalBindingKey(n);
        InternalBindingValue value = this.bindingMap.get(key);
        if (value == null) {
            return null;
        }
        if (this.readLogger.isLoggable(Level.FINE)) {
            this.readLogger.fine("<<NAMING RESOLVE>><<SUCCESS>>Namecomponent :" + this.getName(n));
        }
        bth.value = value.theBinding.binding_type;
        return value.theObjectRef;
    }

    @Override
    public final Object unbindImpl(NameComponent n) throws SystemException {
        InternalBindingKey key = new InternalBindingKey(n);
        InternalBindingValue value = this.bindingMap.remove(key);
        if (value == null) {
            if (this.updateLogger.isLoggable(Level.FINE)) {
                this.updateLogger.fine("<<NAMING UNBIND>><<FAILURE>> There was no binding with the name " + this.getName(n) + " to Unbind ");
            }
            return null;
        }
        if (this.updateLogger.isLoggable(Level.FINE)) {
            this.updateLogger.fine("<<NAMING UNBIND>><<SUCCESS>> NameComponent:  " + this.getName(n));
        }
        return value.theObjectRef;
    }

    @Override
    public final void listImpl(int how_many, BindingListHolder bl, BindingIteratorHolder bi) throws SystemException {
        try {
            BindingIterator bindingRef;
            HashMap<InternalBindingKey, InternalBindingValue> copy = new HashMap<InternalBindingKey, InternalBindingValue>(this.bindingMap);
            TransientBindingIterator bindingIterator = new TransientBindingIterator((ORB)this.orb, copy, this.nsPOA);
            bindingIterator.list(how_many, bl);
            byte[] objectId = this.nsPOA.activate_object((Servant)bindingIterator);
            Object obj = this.nsPOA.id_to_reference(objectId);
            bi.value = bindingRef = BindingIteratorHelper.narrow((Object)obj);
        }
        catch (SystemException e) {
            this.readLogger.warning("<<NAMING LIST>><<FAILURE>>" + (java.lang.Object)((java.lang.Object)e));
            throw e;
        }
        catch (Exception e) {
            this.readLogger.severe("<<NAMING LIST>><<FAILURE>>" + e);
            throw this.wrapper.transNcListGotExc(e);
        }
    }

    @Override
    public final NamingContext newContextImpl() throws SystemException {
        try {
            TransientNamingContext transContext = new TransientNamingContext(this.orb, this.localRoot, this.nsPOA);
            byte[] objectId = this.nsPOA.activate_object((Servant)transContext);
            Object obj = this.nsPOA.id_to_reference(objectId);
            this.lifecycleLogger.fine("TransientNamingContext LIFECYCLE.CREATE SUCCESSFUL");
            return NamingContextHelper.narrow((Object)obj);
        }
        catch (SystemException e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", e);
            throw e;
        }
        catch (Exception e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE CREATE>><<FAILURE>>", e);
            throw this.wrapper.transNcNewctxGotExc(e);
        }
    }

    @Override
    public final void destroyImpl() throws SystemException {
        try {
            byte[] objectId = this.nsPOA.servant_to_id((Servant)this);
            if (objectId != null) {
                this.nsPOA.deactivate_object(objectId);
            }
            if (this.lifecycleLogger.isLoggable(Level.FINE)) {
                this.lifecycleLogger.fine("<<LIFECYCLE DESTROY>><<SUCCESS>>");
            }
        }
        catch (SystemException e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", e);
            throw e;
        }
        catch (Exception e) {
            this.lifecycleLogger.log(Level.WARNING, "<<LIFECYCLE DESTROY>><<FAILURE>>", e);
            throw this.wrapper.transNcDestroyGotExc(e);
        }
    }

    private String getName(NameComponent n) {
        return n.id + "." + n.kind;
    }

    @Override
    public final boolean isEmptyImpl() {
        return this.bindingMap.isEmpty();
    }
}

