/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.toa;

import com.sun.corba.ee.impl.oa.toa.Element;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@com.sun.corba.ee.spi.trace.TransientObjectManager
@ManagedData
@Description(value="Maintains mapping from Object ID to servant")
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public final class TransientObjectManager {
    private ORB orb;
    private int maxSize = 128;
    private Element[] elementArray;
    private Element freeList;
    private static SynchronizedHolder __$mm$__0;

    @ManagedAttribute
    @Description(value="The element array mapping indices into servants")
    private synchronized Element[] getElements() {
        return (Element[])this.elementArray.clone();
    }

    public TransientObjectManager(ORB orb) {
        this.orb = orb;
        this.elementArray = new Element[this.maxSize];
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (int i = this.maxSize - 2; i >= 0; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @com.sun.corba.ee.spi.trace.TransientObjectManager
    public synchronized byte[] storeServant(Object object, Object object2) {
        Object var3_3 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(4, new Object[]{object, object2});
        }
        try {
            void __$mm$__;
            void servantData;
            void servant;
            byte[] result;
            if (this.freeList == null) {
                this.doubleSize();
            }
            Element elem = this.freeList;
            this.freeList = (Element)this.freeList.servant;
            byte[] __$result$__ = result = elem.getKey(servant, servantData);
            if (__$mm$__ != null) {
                __$mm$__.exit(4, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(4, var3_3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @com.sun.corba.ee.spi.trace.TransientObjectManager
    public synchronized Object lookupServant(byte[] byArray) {
        Object var2_2 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(2, new Object[]{byArray});
        }
        try {
            void __$mm$__;
            Object __$result$__;
            void transientKey;
            int index = ORBUtility.bytesToInt((byte[])transientKey, 0);
            int counter = ORBUtility.bytesToInt((byte[])transientKey, 4);
            if (this.elementArray[index].counter == counter && this.elementArray[index].valid) {
                __$result$__ = this.elementArray[index].servant;
                if (__$mm$__ != null) {
                    __$mm$__.exit(2, __$result$__);
                }
                return __$result$__;
            }
            __$result$__ = null;
            if (__$mm$__ != null) {
                __$mm$__.exit(2, __$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(2, var2_2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @com.sun.corba.ee.spi.trace.TransientObjectManager
    public synchronized Object lookupServantData(byte[] byArray) {
        Object var2_2 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[]{byArray});
        }
        try {
            void __$mm$__;
            Object __$result$__;
            void transientKey;
            int index = ORBUtility.bytesToInt((byte[])transientKey, 0);
            int counter = ORBUtility.bytesToInt((byte[])transientKey, 4);
            if (this.elementArray[index].counter == counter && this.elementArray[index].valid) {
                __$result$__ = this.elementArray[index].servantData;
                if (__$mm$__ != null) {
                    __$mm$__.exit(3, __$result$__);
                }
                return __$result$__;
            }
            __$result$__ = null;
            if (__$mm$__ != null) {
                __$mm$__.exit(3, __$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3, var2_2);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void deleteAtIndex(int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{n}, n2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @com.sun.corba.ee.spi.trace.TransientObjectManager
    public synchronized void deleteServant(byte[] byArray) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(1, new Object[]{byArray});
        }
        try {
            void __$mm$__;
            void transientKey;
            int index = ORBUtility.bytesToInt((byte[])transientKey, 0);
            this.deleteAtIndex(index, (MethodMonitor)__$mm$__, 1);
            this.elementArray[index].delete(this.freeList);
            this.freeList = this.elementArray[index];
            if (__$mm$__ != null) {
                __$mm$__.exit(1);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(1);
            }
            throw throwable;
        }
    }

    public synchronized byte[] getKey(Object servant) {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid || this.elementArray[i].servant != servant) continue;
            return this.elementArray[i].toBytes();
        }
        return null;
    }

    private void doubleSize() {
        int i;
        Element[] old = this.elementArray;
        int oldSize = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        for (i = 0; i < oldSize; ++i) {
            this.elementArray[i] = old[i];
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (i = this.maxSize - 2; i >= oldSize; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[oldSize];
    }

    static {
        MethodMonitorRegistry.registerClass(TransientObjectManager.class);
    }
}

