/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.ListenerThread;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class ListenerThreadImpl
implements ListenerThread,
Work {
    private ORB orb;
    private CorbaAcceptor acceptor;
    private boolean keepRunning;
    private long enqueueTime;
    private ORBUtilSystemException wrapper;
    private static SynchronizedHolder __$mm$__0;

    public ListenerThreadImpl(ORB orb, CorbaAcceptor acceptor) {
        this.orb = orb;
        this.acceptor = acceptor;
        this.keepRunning = true;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public CorbaAcceptor getAcceptor() {
        return this.acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public synchronized void close() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[0]);
        }
        try {
            void __$mm$__;
            this.keepRunning = false;
            this.acceptor.close();
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    private synchronized boolean isRunning() {
        return this.keepRunning;
    }

    @InfoMethod
    private void display(String string, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string}, n, 1);
        }
    }

    @InfoMethod
    private void display(String string, Object object, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, object}, n, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transport
    public void doWork() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[0]);
        }
        try {
            void __$mm$__;
            while (this.isRunning()) {
                this.display("acceptor", this.acceptor, (MethodMonitor)__$mm$__, 3);
                try {
                    this.display("Before Accept cycle", (MethodMonitor)__$mm$__, 3);
                    this.acceptor.processSocket(this.acceptor.getAcceptedSocket());
                    this.display("After Accept cycle", (MethodMonitor)__$mm$__, 3);
                }
                catch (Throwable t) {
                    this.wrapper.exceptionInListenerThread(t);
                    this.display("Exception in accept", t, (MethodMonitor)__$mm$__, 3);
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getAcceptor().getEventHandler());
                    try {
                        if (!this.isRunning()) continue;
                        this.getAcceptor().close();
                    }
                    catch (Exception exc) {
                        this.wrapper.ioExceptionOnClose(exc);
                    }
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(3);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3);
            }
            throw throwable;
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ListenerThread";
    }

    static {
        MethodMonitorRegistry.registerClass(ListenerThreadImpl.class);
    }
}

