/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.logging;

import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.misc.OperationTracer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogWrapperBase {
    private Logger logger = null;
    protected String loggerName;

    protected LogWrapperBase(String loggerName) {
        this.loggerName = loggerName;
    }

    protected synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = ORB.getLogger(this.loggerName);
        }
        return this.logger;
    }

    private String getOpTraceValue() {
        String otval = OperationTracer.getAsString();
        if (otval.length() == 0) {
            return "";
        }
        return "<<Context:" + otval + ">>";
    }

    protected void doLog(Level level, String key, Object[] params, Class wrapperClass, Throwable thr) {
        Object[] newParams;
        LogRecord lrec = new LogRecord(level, key);
        if (params == null) {
            newParams = new Object[]{this.getOpTraceValue()};
        } else {
            newParams = new Object[params.length + 1];
            for (int ctr = 0; ctr < params.length; ++ctr) {
                newParams[ctr] = params[ctr];
            }
            newParams[params.length] = this.getOpTraceValue();
        }
        lrec.setParameters(newParams);
        if (level != Level.INFO) {
            this.inferCaller(wrapperClass, lrec);
            lrec.setThrown(thr);
        }
        lrec.setLoggerName(this.loggerName);
        Logger lgr = this.getLogger();
        lrec.setResourceBundle(lgr.getResourceBundle());
        lgr.log(lrec);
    }

    private void inferCaller(Class wrapperClass, LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = wrapperClass.getName();
        String baseName = LogWrapperBase.class.getName();
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).equals(wcname) || cname.equals(baseName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    protected void doLog(Level level, String key, Class wrapperClass, Throwable thr) {
        this.doLog(level, key, null, wrapperClass, thr);
    }
}

