/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.TcpTimeouts;

public class TcpTimeoutsImpl
implements TcpTimeouts {
    private ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_UTIL_ORBUtil();
    private final int initial_time_to_wait;
    private final int max_time_to_wait;
    private int backoff_factor;
    private final int max_single_wait_time;

    public TcpTimeoutsImpl(String args) {
        String[] data = args.split(":");
        if (data.length < 3 || data.length > 4) {
            throw this.wrapper.badTimeoutDataLength();
        }
        this.initial_time_to_wait = this.parseArg("initial_time_to_wait", data[0]);
        this.max_time_to_wait = this.parseArg("max_time_to_wait", data[1]);
        this.setBackoffFactor(this.parseArg("backoff_factor", data[2]));
        this.max_single_wait_time = data.length == 4 ? this.parseArg("max_single_wait_time", data[3]) : Integer.MAX_VALUE;
    }

    public TcpTimeoutsImpl(int initial_time, int max_time, int backoff_percent) {
        this(initial_time, max_time, backoff_percent, Integer.MAX_VALUE);
    }

    public TcpTimeoutsImpl(int initial_time, int max_time, int backoff_percent, int max_single_wait_time) {
        this.initial_time_to_wait = initial_time;
        this.max_time_to_wait = max_time;
        this.setBackoffFactor(backoff_percent);
        this.max_single_wait_time = max_single_wait_time;
    }

    private void setBackoffFactor(int backoff_percent) {
        this.backoff_factor = 100 + backoff_percent;
    }

    private int parseArg(String name, String value) {
        try {
            int result = Integer.parseInt(value);
            if (result <= 0) {
                throw this.wrapper.badTimeoutStringData(value, name);
            }
            return result;
        }
        catch (NumberFormatException exc) {
            throw this.wrapper.badTimeoutStringData(exc, (Object)value, (Object)name);
        }
    }

    @Override
    public int get_initial_time_to_wait() {
        return this.initial_time_to_wait;
    }

    @Override
    public int get_max_time_to_wait() {
        return this.max_time_to_wait;
    }

    @Override
    public int get_backoff_factor() {
        return this.backoff_factor;
    }

    @Override
    public int get_max_single_wait_time() {
        return this.max_single_wait_time;
    }

    @Override
    public TcpTimeouts.Waiter waiter() {
        return new TcpTimeouts.Waiter(){
            private long current_wait;
            private long total_time;
            {
                this.current_wait = TcpTimeoutsImpl.this.initial_time_to_wait;
                this.total_time = 0L;
            }

            @Override
            public void advance() {
                if (this.current_wait != (long)TcpTimeoutsImpl.this.max_single_wait_time) {
                    this.current_wait = this.current_wait * (long)TcpTimeoutsImpl.this.backoff_factor / 100L;
                    if (this.current_wait > (long)TcpTimeoutsImpl.this.max_single_wait_time) {
                        this.current_wait = TcpTimeoutsImpl.this.max_single_wait_time;
                    }
                }
            }

            @Override
            public void reset() {
                this.current_wait = TcpTimeoutsImpl.this.initial_time_to_wait;
            }

            @Override
            public int getTime() {
                return (int)this.current_wait;
            }

            @Override
            public int getTimeForSleep() {
                int result = (int)this.current_wait;
                if (this.total_time < (long)TcpTimeoutsImpl.this.max_time_to_wait) {
                    this.total_time += this.current_wait;
                }
                return result;
            }

            @Override
            public int timeWaiting() {
                return (int)this.total_time;
            }

            @Override
            public boolean sleepTime() {
                if (this.isExpired()) {
                    return false;
                }
                try {
                    Thread.sleep(this.getTimeForSleep());
                    return true;
                }
                catch (InterruptedException exc) {
                    TcpTimeoutsImpl.this.wrapper.interruptedExceptionInTimeout();
                    return false;
                }
            }

            @Override
            public boolean isExpired() {
                return this.total_time > (long)TcpTimeoutsImpl.this.max_time_to_wait;
            }
        };
    }

    public String toString() {
        return "TcpTimeoutsImpl[" + this.initial_time_to_wait + ":" + this.max_time_to_wait + ":" + this.backoff_factor + ":" + this.max_single_wait_time + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TcpTimeouts)) {
            return false;
        }
        TcpTimeouts other = (TcpTimeouts)obj;
        return this.initial_time_to_wait == other.get_initial_time_to_wait() && this.max_time_to_wait == other.get_max_time_to_wait() && this.backoff_factor == other.get_backoff_factor() && this.max_single_wait_time == other.get_max_single_wait_time();
    }

    public int hashCode() {
        return this.initial_time_to_wait ^ this.max_time_to_wait ^ this.backoff_factor ^ this.max_single_wait_time;
    }
}

