/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.orbutil.fsm.Action;
import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.FSMImpl;
import com.sun.corba.ee.spi.orbutil.fsm.Guard;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.Runner;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.PoaFSM;
import java.util.concurrent.locks.Condition;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;

@PoaFSM
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class AOMEntry
extends FSMImpl {
    private static final POASystemException wrapper;
    private Runner runner = new Runner((FSM)this);
    private final Thread[] etherealizer;
    private final int[] counter;
    private final Condition wait;
    final POAImpl poa;
    public static final State INVALID;
    public static final State INCARN;
    public static final State VALID;
    public static final State ETHP;
    public static final State ETH;
    public static final State DESTROYED;
    static final Input START_ETH;
    static final Input ETH_DONE;
    static final Input INC_DONE;
    static final Input INC_FAIL;
    static final Input ACTIVATE;
    static final Input ENTER;
    static final Input EXIT;
    private static final Action incrementAction;
    private static final Action decrementAction;
    private static final Action throwIllegalStateExceptionAction;
    private static final Action oaaAction;
    private static final Guard waitGuard;
    private static final Guard.Base.IntFunc counterFunc;
    private static final Guard.Base.IntFunc one;
    private static final Guard.Base.IntFunc zero;
    private static final Guard greaterZeroGuard;
    private static final Guard zeroGuard;
    private static final Guard greaterOneGuard;
    private static final Guard oneGuard;
    private static final StateEngine engine;
    private static SynchronizedHolder __$mm$__0;

    public AOMEntry(POAImpl poa) {
        super(engine, INVALID);
        this.poa = poa;
        this.etherealizer = new Thread[1];
        this.etherealizer[0] = null;
        this.counter = new int[1];
        this.counter[0] = 0;
        this.wait = poa.makeCondition();
    }

    @InfoMethod
    private void state(State state, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{state}, n, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @PoaFSM
    public void setState(State state) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[]{state});
        }
        try {
            void __$mm$__;
            void state2;
            super.setState((State)state2);
            this.state(this.getState(), (MethodMonitor)__$mm$__, 0);
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    public void startEtherealize(Thread etherealizer) {
        this.etherealizer[0] = etherealizer;
        this.runner.doIt(START_ETH);
    }

    public void etherealizeComplete() {
        this.runner.doIt(ETH_DONE);
    }

    public void incarnateComplete() {
        this.runner.doIt(INC_DONE);
    }

    public void incarnateFailure() {
        this.runner.doIt(INC_FAIL);
    }

    public void enter() {
        this.runner.doIt(ENTER);
    }

    public void exit() {
        this.runner.doIt(EXIT);
    }

    public void activateObject() throws ObjectAlreadyActive {
        try {
            this.runner.doIt(ACTIVATE);
        }
        catch (RuntimeException exc) {
            Throwable thr = exc.getCause();
            if (thr instanceof ObjectAlreadyActive) {
                throw (ObjectAlreadyActive)thr;
            }
            throw exc;
        }
    }

    static {
        MethodMonitorRegistry.registerClass(AOMEntry.class);
        wrapper = POASystemException.self;
        INVALID = new State("Invalid", State.Kind.INITIAL);
        INCARN = new State("Incarnating"){

            public void postAction(FSM fsm) {
                AOMEntry entry = (AOMEntry)fsm;
                entry.wait.signalAll();
            }
        };
        VALID = new State("Valid");
        ETHP = new State("EtherealizePending");
        ETH = new State("Etherealizing"){

            public FSM preAction(FSM fsm) {
                AOMEntry entry = (AOMEntry)fsm;
                Thread etherealizer = entry.etherealizer[0];
                if (etherealizer != null) {
                    etherealizer.start();
                }
                return null;
            }

            public void postAction(FSM fsm) {
                AOMEntry entry = (AOMEntry)fsm;
                entry.wait.signalAll();
            }
        };
        DESTROYED = new State("Destroyed");
        START_ETH = new Input.Base("startEtherealize");
        ETH_DONE = new Input.Base("etherealizeDone");
        INC_DONE = new Input.Base("incarnateDone");
        INC_FAIL = new Input.Base("incarnateFailure");
        ACTIVATE = new Input.Base("activateObject");
        ENTER = new Input.Base("enter");
        EXIT = new Input.Base("exit");
        incrementAction = new Action.Base("increment"){

            public void doIt(FSM fsm, Input in) {
                AOMEntry entry = (AOMEntry)fsm;
                int[] nArray = entry.counter;
                nArray[0] = nArray[0] + 1;
            }
        };
        decrementAction = new Action.Base("decrement"){

            public void doIt(FSM fsm, Input in) {
                AOMEntry entry = (AOMEntry)fsm;
                if (entry.counter[0] <= 0) {
                    throw wrapper.aomEntryDecZero();
                }
                int[] nArray = entry.counter;
                nArray[0] = nArray[0] - 1;
            }
        };
        throwIllegalStateExceptionAction = new Action.Base("throwIllegalStateException"){

            public void doIt(FSM fsm, Input in) {
                throw new IllegalStateException("No transitions allowed from the DESTROYED state");
            }
        };
        oaaAction = new Action.Base("throwObjectAlreadyActive"){

            public void doIt(FSM fsm, Input in) {
                throw new RuntimeException((Throwable)new ObjectAlreadyActive());
            }
        };
        waitGuard = new Guard.Base("wait"){

            public Guard.Result evaluate(FSM fsm, Input in) {
                AOMEntry entry = (AOMEntry)fsm;
                try {
                    entry.wait.await();
                }
                catch (InterruptedException exc) {
                    wrapper.waitGuardInterrupted();
                }
                return Guard.Result.DEFERRED;
            }
        };
        counterFunc = new Guard.Base.IntFunc("counterFunc"){

            public int evaluate(FSM fsm, Input in) {
                AOMEntry entry = (AOMEntry)fsm;
                return entry.counter[0];
            }
        };
        one = Guard.Base.constant((int)1);
        zero = Guard.Base.constant((int)0);
        greaterZeroGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)zero));
        zeroGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)zero));
        greaterOneGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)one));
        oneGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)one));
        engine = StateEngine.create();
        engine.add(INVALID, ENTER, incrementAction, INCARN);
        engine.add(INVALID, ACTIVATE, null, VALID);
        engine.setDefault(INVALID);
        engine.add(INCARN, ENTER, waitGuard, null, INCARN);
        engine.add(INCARN, EXIT, null, INCARN);
        engine.add(INCARN, START_ETH, waitGuard, null, INCARN);
        engine.add(INCARN, INC_DONE, null, VALID);
        engine.add(INCARN, INC_FAIL, decrementAction, INVALID);
        engine.add(INCARN, ACTIVATE, oaaAction, INCARN);
        engine.add(VALID, ENTER, incrementAction, VALID);
        engine.add(VALID, EXIT, decrementAction, VALID);
        engine.add(VALID, START_ETH, greaterZeroGuard, null, ETHP);
        engine.add(VALID, START_ETH, zeroGuard, null, ETH);
        engine.add(VALID, ACTIVATE, oaaAction, VALID);
        engine.add(ETHP, ENTER, waitGuard, null, ETHP);
        engine.add(ETHP, START_ETH, null, ETHP);
        engine.add(ETHP, EXIT, greaterOneGuard, decrementAction, ETHP);
        engine.add(ETHP, EXIT, oneGuard, decrementAction, ETH);
        engine.add(ETHP, ACTIVATE, oaaAction, ETHP);
        engine.add(ETH, START_ETH, null, ETH);
        engine.add(ETH, ETH_DONE, null, DESTROYED);
        engine.add(ETH, ENTER, waitGuard, null, ETH);
        engine.add(ETH, ACTIVATE, oaaAction, ETH);
        engine.setDefault(DESTROYED, throwIllegalStateExceptionAction, DESTROYED);
        engine.done();
    }
}

