/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.osgi.loader;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGIListener
implements BundleActivator,
SynchronousBundleListener {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final boolean FINE_DEBUG = false;
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final String ORB_PROVIDER_KEY = "ORB-Class-Provider";
    private static PackageAdmin pkgAdmin;
    private static Map<String, Bundle> classNameMap;
    private static Map<String, Bundle> packageNameMap;
    private static final boolean DEBUG;
    private static UnaryFunction<String, Class<?>> classNameResolver;
    private static ClassCodeBaseHandler ccbHandler;

    private static void setPackageAdmin(PackageAdmin pa) {
        pkgAdmin = pa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapContents() {
        lock.readLock().lock();
        try {
            if (DEBUG) {
                OSGIListener.msg("Contents of classNameMap:");
                for (Map.Entry<String, Bundle> entry : classNameMap.entrySet()) {
                    OSGIListener.msg(entry.getKey() + "=>" + entry.getValue().getSymbolicName());
                }
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static void msg(String arg) {
        ClassLoader cl = OSGIListener.class.getClassLoader();
        System.out.println("OSGIListener(" + cl + "): " + arg);
    }

    private static String getBundleEventType(int type) {
        if (type == 1) {
            return "INSTALLED";
        }
        if (type == 512) {
            return "LAZY_ACTIVATION";
        }
        if (type == 32) {
            return "RESOLVED";
        }
        if (type == 2) {
            return "STARTED";
        }
        if (type == 128) {
            return "STARTING";
        }
        if (type == 4) {
            return "STOPPED";
        }
        if (type == 256) {
            return "STOPPING";
        }
        if (type == 16) {
            return "UNINSTALLED";
        }
        if (type == 64) {
            return "UNRESOLVED";
        }
        if (type == 8) {
            return "UPDATED";
        }
        return "ILLEGAL-EVENT-TYPE";
    }

    public static UnaryFunction<String, Class<?>> classNameResolver() {
        return classNameResolver;
    }

    public static ClassCodeBaseHandler classCodeBaseHandler() {
        return ccbHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClasses(Bundle bundle) {
        lock.writeLock().lock();
        try {
            ExportedPackage[] epkgs;
            String orbProvider;
            Dictionary dict = bundle.getHeaders();
            String name = bundle.getSymbolicName();
            if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
                for (String string : orbProvider.split(",")) {
                    String className = string.trim();
                    classNameMap.put(className, bundle);
                    wrapper.insertOrbProvider(className, name);
                }
            }
            if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
                for (ExportedPackage exportedPackage : epkgs) {
                    String pname = exportedPackage.getName();
                    packageNameMap.put(pname, bundle);
                    wrapper.insertBundlePackage(pname, bundle.getSymbolicName());
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClasses(Bundle bundle) {
        lock.writeLock().lock();
        try {
            ExportedPackage[] epkgs;
            String orbProvider;
            Dictionary dict = bundle.getHeaders();
            String name = bundle.getSymbolicName();
            if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
                for (String string : orbProvider.split(",")) {
                    classNameMap.remove(string);
                    wrapper.removeOrbProvider(string, name);
                }
            }
            if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
                for (ExportedPackage exportedPackage : epkgs) {
                    String pname = exportedPackage.getName();
                    packageNameMap.remove(pname);
                    wrapper.removeBundlePackage(pname, bundle.getSymbolicName());
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bundle getBundleForClass(String className) {
        lock.readLock().lock();
        try {
            Bundle result = classNameMap.get(className);
            if (result == null) {
                wrapper.classNotFoundInClassNameMap(className);
                int index = className.lastIndexOf(46);
                if (index > 0) {
                    String packageName = className.substring(0, index);
                    result = packageNameMap.get(packageName);
                    if (result == null) {
                        wrapper.classNotFoundInPackageNameMap(className);
                    } else {
                        wrapper.classFoundInPackageNameMap(className, result.getSymbolicName());
                    }
                }
            } else {
                wrapper.classFoundInClassNameMap(className, result.getSymbolicName());
            }
            Bundle bundle = result;
            return bundle;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public void start(BundleContext context) {
        ServiceReference sref = context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        OSGIListener.setPackageAdmin((PackageAdmin)context.getService(sref));
        if (pkgAdmin == null) {
            wrapper.packageAdminServiceNotAvailable();
        }
        context.addBundleListener((BundleListener)this);
        wrapper.probeBundlesForProviders();
        for (Bundle bundle : context.getBundles()) {
            this.insertClasses(bundle);
        }
        OSGIListener.mapContents();
    }

    public void stop(BundleContext context) {
        Bundle myBundle = context.getBundle();
        this.removeClasses(myBundle);
        OSGIListener.mapContents();
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        String name = bundle.getSymbolicName();
        wrapper.receivedBundleEvent(OSGIListener.getBundleEventType(type), name);
        if (type == 2) {
            this.insertClasses(bundle);
        } else if (type == 1) {
            this.removeClasses(bundle);
        }
        OSGIListener.mapContents();
    }

    static {
        classNameMap = new ConcurrentHashMap<String, Bundle>();
        packageNameMap = new ConcurrentHashMap<String, Bundle>();
        DEBUG = Boolean.getBoolean("com.sun.corba.ee.ORBDebugOSGIListener");
        classNameResolver = new ClassNameResolverImpl();
        ccbHandler = new ClassCodeBaseHandlerImpl();
    }

    private static class ClassCodeBaseHandlerImpl
    implements ClassCodeBaseHandler {
        private static final String PREFIX = "osgi://";

        private ClassCodeBaseHandlerImpl() {
        }

        @Override
        public String getCodeBase(Class<?> cls) {
            String hver;
            if (cls == null) {
                return null;
            }
            if (pkgAdmin == null) {
                return null;
            }
            Bundle bundle = pkgAdmin.getBundle(cls);
            if (bundle == null) {
                return null;
            }
            String name = bundle.getSymbolicName();
            Dictionary headers = bundle.getHeaders();
            String version = "0.0.0";
            if (headers != null && (hver = (String)headers.get("Bundle-Version")) != null) {
                version = hver;
            }
            return PREFIX + name + "/" + version;
        }

        @Override
        public Class<?> loadClass(String codebase, String className) {
            String rest;
            int index;
            if (codebase == null) {
                Bundle bundle = OSGIListener.getBundleForClass(className);
                if (bundle != null) {
                    try {
                        return bundle.loadClass(className);
                    }
                    catch (ClassNotFoundException exc) {
                        return null;
                    }
                }
                return null;
            }
            if (codebase.startsWith(PREFIX) && (index = (rest = codebase.substring(PREFIX.length())).indexOf(47)) > 0) {
                Bundle[] defBundles;
                String name = rest.substring(0, index);
                String version = rest.substring(index + 1);
                if (pkgAdmin != null && (defBundles = pkgAdmin.getBundles(name, version)) != null) {
                    try {
                        return defBundles[0].loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    private static class ClassNameResolverImpl
    implements UnaryFunction<String, Class<?>> {
        private ClassNameResolverImpl() {
        }

        public Class<?> evaluate(String arg) {
            Bundle bundle = OSGIListener.getBundleForClass(arg);
            if (bundle == null) {
                return null;
            }
            try {
                return bundle.loadClass(arg);
            }
            catch (ClassNotFoundException ex) {
                throw wrapper.bundleCouldNotLoadClass(ex, arg, bundle.getSymbolicName());
            }
        }

        public String toString() {
            return "OSGiClassNameResolver";
        }
    }
}

