/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.copyobject;

import com.sun.corba.ee.impl.orbutil.copyobject.CachingClassCopierFactory;
import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopier;
import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopierFactory;
import com.sun.corba.ee.impl.orbutil.copyobject.DefaultClassCopierFactories;
import com.sun.corba.ee.impl.orbutil.copyobject.DefaultClassCopiers;
import com.sun.corba.ee.impl.orbutil.copyobject.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.orbutil.copyobject.ReflectiveCopyException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ClassCopierFactoryPipelineImpl
implements PipelineClassCopierFactory {
    private static final Class<?>[] notCopyable = new Class[]{Thread.class, ThreadGroup.class, ProcessBuilder.class};
    private static final Class<?>[] immutable = new Class[]{Process.class, Class.class, ClassLoader.class, SecurityManager.class, Runtime.class, System.class, Package.class, Field.class, Method.class, Constructor.class, AccessControlContext.class, Object.class, String.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, Logger.class, LogManager.class};
    private static final Class<?>[] mapClasses = new Class[]{ConcurrentHashMap.class, ConcurrentSkipListMap.class, EnumMap.class, HashMap.class, Hashtable.class, IdentityHashMap.class, LinkedHashMap.class, Properties.class, TreeMap.class, WeakHashMap.class};
    private CachingClassCopierFactory factoryCache;
    private ClassCopierFactory specialFactory;
    private ClassCopierFactory arrayFactory;
    private ClassCopierFactory ordinaryFactory;
    private ClassCopier errorCopier;
    public ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();

    public ClassCopierFactoryPipelineImpl() {
        this.factoryCache = DefaultClassCopierFactories.makeCachingClassCopierFactory();
        this.specialFactory = DefaultClassCopierFactories.getNullClassCopierFactory();
        this.arrayFactory = DefaultClassCopierFactories.makeArrayClassCopierFactory(this);
        this.ordinaryFactory = DefaultClassCopierFactories.makeOrdinaryClassCopierFactory(this);
        this.errorCopier = DefaultClassCopiers.getErrorClassCopier();
        for (Class<?> cls : immutable) {
            this.registerImmutable(cls);
        }
        ClassCopier mapCopier = DefaultClassCopiers.makeMapClassCopier(this);
        for (Class<?> cls : mapClasses) {
            this.factoryCache.put(cls, mapCopier);
        }
        for (Class<?> cls : notCopyable) {
            this.factoryCache.put(cls, this.errorCopier);
        }
    }

    @Override
    public boolean reflectivelyCopyable(Class<?> cls) {
        for (Class<?> cl : notCopyable) {
            if (cls != cl) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClassCopier lookupInCache(Class<?> cls) {
        try {
            return this.factoryCache.getClassCopier(cls);
        }
        catch (ReflectiveCopyException exc) {
            return null;
        }
    }

    @Override
    public final synchronized void registerImmutable(Class<?> cls) {
        this.factoryCache.put(cls, DefaultClassCopiers.getIdentityClassCopier());
    }

    @Override
    public void setSpecialClassCopierFactory(ClassCopierFactory ccf) {
        this.specialFactory = ccf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassCopier getClassCopier(Class<?> cls) throws ReflectiveCopyException {
        if (cls.isInterface()) {
            throw new IllegalArgumentException("Cannot create a ClassCopier for an interface.");
        }
        this.rwlock.readLock().lock();
        boolean readLocked = true;
        try {
            ClassCopier result = this.factoryCache.getClassCopier(cls);
            if (result == null) {
                if (Enum.class.isAssignableFrom(cls)) {
                    result = DefaultClassCopiers.getIdentityClassCopier();
                }
                if (result == null) {
                    result = this.specialFactory.getClassCopier(cls);
                }
                if (result == null) {
                    result = this.arrayFactory.getClassCopier(cls);
                }
                if (result == null) {
                    result = this.ordinaryFactory.getClassCopier(cls);
                }
                if (result == null) {
                    throw new IllegalStateException("Could not find ClassCopier for " + cls.getClass());
                }
                this.rwlock.readLock().unlock();
                readLocked = false;
                this.rwlock.writeLock().lock();
                try {
                    if (this.factoryCache.getClassCopier(cls) == null) {
                        this.factoryCache.put(cls, result);
                    }
                }
                finally {
                    this.rwlock.writeLock().unlock();
                }
            }
            if (result == this.errorCopier) {
                throw new ReflectiveCopyException("Cannot copy class " + cls);
            }
            ClassCopier classCopier = result;
            return classCopier;
        }
        finally {
            if (readLocked) {
                this.rwlock.readLock().unlock();
            }
        }
    }
}

