/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.newtimer;

import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="Statistics recorded for a series of time intervals")
public class Statistics {
    private final long count;
    private final double min;
    private final double max;
    private final double average;
    private final double standardDeviation;

    public Statistics(long count, double min, double max, double average, double standardDeviation) {
        this.count = count;
        this.min = min;
        this.max = max;
        this.average = average;
        this.standardDeviation = standardDeviation;
    }

    @ManagedAttribute
    @Description(value="Total number of intervals recorded")
    public long count() {
        return this.count;
    }

    @ManagedAttribute
    @Description(value="Minimum interval duration recorded")
    public double min() {
        return this.min;
    }

    @ManagedAttribute
    @Description(value="Maximum interval duration recorded")
    public double max() {
        return this.max;
    }

    @ManagedAttribute
    @Description(value="Average interval duration recorded")
    public double average() {
        return this.average;
    }

    @ManagedAttribute
    @Description(value="Standard deviation of all durations recorded")
    public double standardDeviation() {
        return this.standardDeviation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics)Statistics.class.cast(obj);
        return this.count == other.count() && this.min == other.min() && this.max == other.max() && this.average == other.average() && this.standardDeviation == other.standardDeviation();
    }

    public int hashCode() {
        double sum = this.min + this.max + this.average + this.standardDeviation;
        Double dsum = sum += (double)this.count;
        return dsum.hashCode();
    }
}

