/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.protocol.CorbaRequestId;
import com.sun.corba.ee.spi.protocol.MessageParser;
import com.sun.corba.ee.spi.trace.Giop;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

@Transport
@Giop
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class MessageParserImpl
implements MessageParser {
    private final ORB orb;
    private boolean expectingMoreData;
    private boolean moreBytesToParse;
    private int nextMsgStartPos;
    private int sizeNeeded;
    private List<CorbaRequestId> fragmentList;
    private static SynchronizedHolder __$mm$__1;
    private static SynchronizedHolder __$mm$__0;

    public MessageParserImpl(ORB orb) {
        this.orb = orb;
        this.expectingMoreData = false;
        this.moreBytesToParse = false;
        this.nextMsgStartPos = 0;
        this.fragmentList = new LinkedList<CorbaRequestId>();
        this.sizeNeeded = orb.getORBData().getReadByteBufferSize();
    }

    @Override
    public boolean isExpectingMoreData() {
        return this.expectingMoreData;
    }

    @InfoMethod
    private void display(String string, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string}, n, 0);
        }
    }

    @InfoMethod
    private void display(String string, int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, n}, n2, 0);
        }
    }

    @InfoMethod
    private void display(String string, Object object, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, object}, n, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Giop
    private void parseBytesGiopInfo(ByteBuffer byteBuffer, Message message) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(4, new Object[]{byteBuffer, message});
        }
        try {
            void __$mm$__;
            if (this.orb.giopDebugFlag) {
                void message2;
                void msgByteBuffer;
                ByteBuffer viewBuf = msgByteBuffer.asReadOnlyBuffer();
                viewBuf.position(viewBuf.limit());
                CorbaRequestId requestId = MessageBase.getRequestIdFromMessageBytes((Message)message2);
                this.display("Message Type", message2.getType(), (MethodMonitor)__$mm$__, 4);
                this.display("Request Id", requestId.toString(), (MethodMonitor)__$mm$__, 4);
                this.display("Successfully parsed with sliced ByteBuffer", msgByteBuffer.toString(), (MethodMonitor)__$mm$__, 4);
                ORBUtility.printBuffer("GIOP Message Body", viewBuf, System.out);
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(4);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public Message parseBytes(ByteBuffer byteBuffer, CorbaConnection corbaConnection) {
        Object var3_3 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__1.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[]{byteBuffer, corbaConnection});
        }
        try {
            void __$mm$__;
            void byteBuffer2;
            MessageBase message = null;
            int bytesInBuffer = byteBuffer2.limit() - this.nextMsgStartPos;
            if (bytesInBuffer >= 12) {
                void connection;
                message = MessageBase.parseGiopHeader(this.orb, (CorbaConnection)connection, (ByteBuffer)byteBuffer2, this.nextMsgStartPos);
                if (bytesInBuffer >= message.getSize()) {
                    int savedLimit = byteBuffer2.limit();
                    byteBuffer2.position(this.nextMsgStartPos).limit(this.nextMsgStartPos + message.getSize());
                    ByteBuffer msgByteBuffer = byteBuffer2.slice();
                    this.nextMsgStartPos = byteBuffer2.limit();
                    byteBuffer2.position(this.nextMsgStartPos).limit(savedLimit);
                    message.setByteBuffer(msgByteBuffer);
                    this.parseBytesGiopInfo(msgByteBuffer, message);
                    if (MessageBase.messageSupportsFragments(message)) {
                        if (message.moreFragmentsToFollow()) {
                            CorbaRequestId requestId = MessageBase.getRequestIdFromMessageBytes(message);
                            if (!this.fragmentList.contains(requestId)) {
                                this.fragmentList.add(requestId);
                                this.display("Added to fragmentList", requestId, (MethodMonitor)__$mm$__, 3);
                            } else {
                                this.display("fragmentList alreadty has an entry for", requestId, (MethodMonitor)__$mm$__, 3);
                            }
                        } else if (message.getType() == 7 || message.getType() == 2) {
                            CorbaRequestId requestId = MessageBase.getRequestIdFromMessageBytes(message);
                            if (this.fragmentList.size() > 0 && this.fragmentList.remove(requestId)) {
                                this.display("Removed from fragmentList", requestId, (MethodMonitor)__$mm$__, 3);
                            }
                        }
                        this.expectingMoreData = this.fragmentList.size() > 0;
                    }
                    if (byteBuffer2.hasRemaining()) {
                        this.moreBytesToParse = true;
                    } else {
                        this.moreBytesToParse = false;
                        byteBuffer2.limit(byteBuffer2.capacity());
                    }
                    this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
                } else {
                    if (this.orb.transportDebugFlag) {
                        this.display("Not enough bytes available in ByteBuffer for a complete GIOP message: bytes available ", bytesInBuffer, (MethodMonitor)__$mm$__, 3);
                        this.display("bytes needed", message.getSize(), (MethodMonitor)__$mm$__, 3);
                        this.display("ByteBuffer state", byteBuffer2.toString(), (MethodMonitor)__$mm$__, 3);
                    }
                    this.moreBytesToParse = false;
                    this.expectingMoreData = true;
                    byteBuffer2.position(byteBuffer2.limit()).limit(byteBuffer2.capacity());
                    this.sizeNeeded = message.getSize();
                    message = null;
                }
            } else {
                if (this.orb.transportDebugFlag) {
                    this.display("Not enough bytes available in ByteBuffer to parse 12-byte GIOP header", (MethodMonitor)__$mm$__, 3);
                    this.display("bytes available", bytesInBuffer, (MethodMonitor)__$mm$__, 3);
                    this.display("ByteBuffer state", byteBuffer2.toString(), (MethodMonitor)__$mm$__, 3);
                }
                this.moreBytesToParse = false;
                this.expectingMoreData = true;
                byteBuffer2.position(byteBuffer2.limit()).limit(byteBuffer2.capacity());
                this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
            }
            MessageBase __$result$__ = message;
            if (__$mm$__ != null) {
                __$mm$__.exit(3, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3, var3_3);
            }
            throw throwable;
        }
    }

    @Override
    public boolean hasMoreBytesToParse() {
        return this.moreBytesToParse;
    }

    @Override
    public void setNextMessageStartPosition(int position) {
        this.nextMsgStartPos = position;
    }

    @Override
    public int getNextMessageStartPosition() {
        return this.nextMsgStartPos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPrefix()).append("]");
        return sb.toString();
    }

    private String stateString(ByteBuffer byteBuffer) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPrefix()).append(" ").append(byteBuffer.toString());
        return sb.toString();
    }

    private String toStringPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageParserImpl[nextMsgStartPos=" + this.nextMsgStartPos + ", expectingMoreData=" + this.expectingMoreData + ", moreBytesToParse=" + this.moreBytesToParse + ", fragmentList size=" + this.fragmentList.size() + ", size needed=" + this.sizeNeeded + "]");
        return sb.toString();
    }

    @Override
    public int getSizeNeeded() {
        return this.sizeNeeded;
    }

    static {
        MethodMonitorRegistry.registerClass(MessageParserImpl.class);
    }
}

