/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orb;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import com.sun.corba.ee.spi.orbutil.misc.ObjectUtility;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class OperationFactory {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static Operation suffixActionImpl = new SuffixAction();
    private static Operation valueActionImpl = new ValueAction();
    private static Operation identityActionImpl = new IdentityAction();
    private static Operation booleanActionImpl = new BooleanAction();
    private static Operation integerActionImpl = new IntegerAction();
    private static Operation stringActionImpl = new StringAction();
    private static Operation setFlagActionImpl = new SetFlagAction();
    private static Operation URLActionImpl = new URLAction();
    private static Operation convertIntegerToShortImpl = new ConvertIntegerToShort();

    private OperationFactory() {
    }

    private static String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw wrapper.stringExpectedInOperation();
    }

    private static Object[] getObjectArray(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        throw wrapper.objectArrayExpected();
    }

    private static Pair<String, String> getStringPair(Object obj) {
        if (obj instanceof Pair) {
            return (Pair)obj;
        }
        throw wrapper.pairStringStringExpected();
    }

    public static Operation maskErrorAction(Operation op) {
        return new MaskErrorAction(op);
    }

    public static Operation indexAction(int index) {
        return new IndexAction(index);
    }

    public static Operation identityAction() {
        return identityActionImpl;
    }

    public static Operation suffixAction() {
        return suffixActionImpl;
    }

    public static Operation valueAction() {
        return valueActionImpl;
    }

    public static Operation booleanAction() {
        return booleanActionImpl;
    }

    public static Operation integerAction() {
        return integerActionImpl;
    }

    public static Operation stringAction() {
        return stringActionImpl;
    }

    public static Operation classAction(UnaryFunction<String, Class<?>> resolver) {
        return new ClassAction(resolver);
    }

    public static Operation setFlagAction() {
        return setFlagActionImpl;
    }

    public static Operation URLAction() {
        return URLActionImpl;
    }

    public static Operation integerRangeAction(int min, int max) {
        return new IntegerRangeAction(min, max);
    }

    public static Operation listAction(String sep, Operation act) {
        return new ListAction(sep, act);
    }

    public static Operation sequenceAction(String sep, Operation[] actions) {
        return new SequenceAction(sep, actions);
    }

    public static Operation compose(Operation op1, Operation op2) {
        return new ComposeAction(op1, op2);
    }

    public static Operation mapAction(Operation op) {
        return new MapAction(op);
    }

    public static Operation mapSequenceAction(Operation[] op) {
        return new MapSequenceAction(op);
    }

    public static Operation convertIntegerToShort() {
        return convertIntegerToShortImpl;
    }

    private static class ConvertIntegerToShort
    extends OperationBase {
        private ConvertIntegerToShort() {
        }

        @Override
        public Object operate(Object value) {
            Integer val = (Integer)value;
            return val.shortValue();
        }

        public String toString() {
            return "ConvertIntegerToShort";
        }
    }

    private static class MapSequenceAction
    extends OperationBase {
        private Operation[] op;

        public MapSequenceAction(Operation[] op) {
            this.op = op;
        }

        @Override
        public Object operate(Object value) {
            Object[] values = (Object[])value;
            Object[] result = new Object[values.length];
            for (int ctr = 0; ctr < values.length; ++ctr) {
                result[ctr] = this.op[ctr].operate(values[ctr]);
            }
            return result;
        }

        public String toString() {
            return "mapSequenceAction(" + ObjectUtility.compactObjectToString((Object)this.op) + ")";
        }
    }

    private static class MapAction
    extends OperationBase {
        private Operation op;

        MapAction(Operation op) {
            this.op = op;
        }

        @Override
        public Object operate(Object value) {
            Object[] values = (Object[])value;
            Object[] result = new Object[values.length];
            for (int ctr = 0; ctr < values.length; ++ctr) {
                result[ctr] = this.op.operate(values[ctr]);
            }
            return result;
        }

        public String toString() {
            return "mapAction(" + this.op + ")";
        }
    }

    private static class ComposeAction
    extends OperationBase {
        private Operation op1;
        private Operation op2;

        ComposeAction(Operation op1, Operation op2) {
            this.op1 = op1;
            this.op2 = op2;
        }

        @Override
        public Object operate(Object value) {
            return this.op2.operate(this.op1.operate(value));
        }

        public String toString() {
            return "composition(" + this.op1 + "," + this.op2 + ")";
        }
    }

    private static class SequenceAction
    extends OperationBase {
        private String sep;
        private Operation[] actions;

        SequenceAction(String sep, Operation[] actions) {
            this.sep = sep;
            this.actions = actions;
        }

        @Override
        public Object operate(Object value) {
            StringTokenizer st = new StringTokenizer(OperationFactory.getString(value), this.sep);
            int numTokens = st.countTokens();
            if (numTokens != this.actions.length) {
                throw wrapper.numTokensActionsDontMatch(numTokens, this.actions.length);
            }
            int ctr = 0;
            Object[] result = new Object[numTokens];
            while (st.hasMoreTokens()) {
                Operation act = this.actions[ctr];
                String next = st.nextToken();
                result[ctr++] = act.operate(next);
            }
            return result;
        }

        public String toString() {
            return "sequenceAction(separator=\"" + this.sep + "\",actions=" + ObjectUtility.compactObjectToString((Object)this.actions) + ")";
        }
    }

    private static class ListAction
    extends OperationBase {
        private String sep;
        private Operation act;

        ListAction(String sep, Operation act) {
            this.sep = sep;
            this.act = act;
        }

        @Override
        public Object operate(Object value) {
            StringTokenizer st = new StringTokenizer(OperationFactory.getString(value), this.sep);
            int length = st.countTokens();
            Object result = null;
            int ctr = 0;
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                Object val = this.act.operate(next);
                if (result == null) {
                    result = Array.newInstance(val.getClass(), length);
                }
                Array.set(result, ctr++, val);
            }
            return result;
        }

        public String toString() {
            return "listAction(separator=\"" + this.sep + "\",action=" + this.act + ")";
        }
    }

    private static class IntegerRangeAction
    extends OperationBase {
        private int min;
        private int max;

        IntegerRangeAction(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Object operate(Object value) {
            int result = Integer.parseInt(OperationFactory.getString(value));
            if (result >= this.min && result <= this.max) {
                return result;
            }
            throw wrapper.valueNotInRange(result, this.min, this.max);
        }

        public String toString() {
            return "integerRangeAction(" + this.min + "," + this.max + ")";
        }
    }

    private static class URLAction
    extends OperationBase {
        private URLAction() {
        }

        @Override
        public Object operate(Object value) {
            String val = (String)value;
            try {
                return new URL(val);
            }
            catch (MalformedURLException exc) {
                throw wrapper.badUrlInAction(exc, val);
            }
        }

        public String toString() {
            return "URLAction";
        }
    }

    private static class SetFlagAction
    extends OperationBase {
        private SetFlagAction() {
        }

        @Override
        public Object operate(Object value) {
            return Boolean.TRUE;
        }

        public String toString() {
            return "setFlagAction";
        }
    }

    private static class ClassAction
    extends OperationBase {
        private UnaryFunction<String, Class<?>> resolver;

        public ClassAction(UnaryFunction<String, Class<?>> resolver) {
            this.resolver = resolver;
        }

        @Override
        public Object operate(Object value) {
            String className = OperationFactory.getString(value);
            try {
                Class result = (Class)this.resolver.evaluate((Object)className);
                return result;
            }
            catch (Exception exc) {
                throw wrapper.classActionException(exc, className);
            }
        }

        public String toString() {
            return "classAction[" + this.resolver + "]";
        }
    }

    private static class StringAction
    extends OperationBase {
        private StringAction() {
        }

        @Override
        public Object operate(Object value) {
            return value;
        }

        public String toString() {
            return "stringAction";
        }
    }

    private static class IntegerAction
    extends OperationBase {
        private IntegerAction() {
        }

        @Override
        public Object operate(Object value) {
            return Integer.valueOf(OperationFactory.getString(value));
        }

        public String toString() {
            return "integerAction";
        }
    }

    private static class BooleanAction
    extends OperationBase {
        private BooleanAction() {
        }

        @Override
        public Object operate(Object value) {
            return Boolean.valueOf(OperationFactory.getString(value));
        }

        public String toString() {
            return "booleanAction";
        }
    }

    private static class IdentityAction
    extends OperationBase {
        private IdentityAction() {
        }

        @Override
        public Object operate(Object value) {
            return value;
        }

        public String toString() {
            return "identityAction";
        }
    }

    private static class ValueAction
    extends OperationBase {
        private ValueAction() {
        }

        @Override
        public Object operate(Object value) {
            return OperationFactory.getStringPair(value).second();
        }

        public String toString() {
            return "valueAction";
        }
    }

    private static class SuffixAction
    extends OperationBase {
        private SuffixAction() {
        }

        @Override
        public Object operate(Object value) {
            return OperationFactory.getStringPair(value).first();
        }

        public String toString() {
            return "suffixAction";
        }
    }

    private static class IndexAction
    extends OperationBase {
        private int index;

        public IndexAction(int index) {
            this.index = index;
        }

        @Override
        public Object operate(Object value) {
            return OperationFactory.getObjectArray(value)[this.index];
        }

        public String toString() {
            return "indexAction(" + this.index + ")";
        }
    }

    private static class MaskErrorAction
    extends OperationBase {
        private Operation op;

        public MaskErrorAction(Operation op) {
            this.op = op;
        }

        @Override
        public Object operate(Object arg) {
            try {
                return this.op.operate(arg);
            }
            catch (Exception exc) {
                return null;
            }
        }

        public String toString() {
            return "maskErrorAction(" + this.op + ")";
        }
    }

    private static abstract class OperationBase
    implements Operation {
        private OperationBase() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OperationBase)) {
                return false;
            }
            OperationBase other = (OperationBase)obj;
            return this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

