/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaConnectionCache;
import java.util.Collection;
import java.util.Iterator;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.NameValue;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public abstract class CorbaConnectionCacheBase
implements CorbaConnectionCache {
    protected static final ORBUtilSystemException wrapper;
    private static final String STAT_UNIT = "count";
    private static final String TOTAL_ID_STD = "TotalConnections";
    private static final String TOTAL_ID = "totalconnections";
    private static final String IDLE_ID_STD = "ConnectionsIdle";
    private static final String IDLE_ID = "connectionsidle";
    private static final String BUSY_ID_STD = "ConnectionsBusy";
    private static final String BUSY_ID = "connectionsbusy";
    private static final String TOTAL_DESC = "Total number of connections in the connection cache";
    private static final String IDLE_DESC = "Number of connections in the connection cache that are idle";
    private static final String BUSY_DESC = "Number of connections in the connection cache that are in use";
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;
    private static SynchronizedHolder __$mm$__0;

    protected CorbaConnectionCacheBase(ORB orb, String cacheType, String monitoringName) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.monitoringName = monitoringName;
        this.dprintCreation();
    }

    @Override
    @NameValue
    public String getCacheType() {
        return this.cacheType;
    }

    @Override
    public synchronized void stampTime(CorbaConnection c) {
        c.setTimeStamp(this.timestamp++);
    }

    private CountStatistic makeCountStat(String name, String desc, long value) {
        CountStatisticImpl result = new CountStatisticImpl(name, STAT_UNIT, desc);
        result.setCount(value);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.backingStore();
        synchronized (object) {
            for (Object obj : this.values()) {
                ((CorbaConnection)obj).closeConnectionResources();
            }
        }
    }

    @ManagedAttribute(id="totalconnections")
    @Description(value="Total number of connections in the connection cache")
    private CountStatistic numberOfConnectionsAttr() {
        return this.makeCountStat(TOTAL_ID_STD, TOTAL_DESC, this.numberOfConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            count = this.values().size();
        }
        return count;
    }

    @ManagedAttribute(id="connectionsidle")
    @Description(value="Number of connections in the connection cache that are idle")
    private CountStatistic numberOfIdleConnectionsAttr() {
        return this.makeCountStat(IDLE_ID_STD, IDLE_DESC, this.numberOfIdleConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfIdleConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (((CorbaConnection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    @ManagedAttribute(id="connectionsbusy")
    @Description(value="Number of connections in the connection cache that are in use")
    private CountStatistic numberOfBusyConnectionsAttr() {
        return this.makeCountStat(BUSY_ID_STD, BUSY_DESC, this.numberOfBusyConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfBusyConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (!((CorbaConnection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Transport
    public synchronized boolean reclaim() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    @InfoMethod
    private void creationInfo(String string, String string2, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, string2}, n, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    protected void dprintCreation() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(5, new Object[0]);
        }
        try {
            void __$mm$__;
            this.creationInfo(this.getCacheType(), this.getMonitoringName(), (MethodMonitor)__$mm$__, 5);
            if (__$mm$__ != null) {
                __$mm$__.exit(5);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(5);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void cacheStatsInfo(long l, long l2, long l3, int n, int n2, MethodMonitor methodMonitor, int n3) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{l, l2, l3, n, n2}, n3, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    protected void cacheStatisticsInfo() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[0]);
        }
        try {
            void __$mm$__;
            this.cacheStatsInfo(this.numberOfConnections(), this.numberOfBusyConnections(), this.numberOfIdleConnections(), this.orb.getORBData().getHighWaterMark(), this.orb.getORBData().getNumberToReclaim(), (MethodMonitor)__$mm$__, 0);
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void reclaimInfo(long l, int n, int n2, MethodMonitor methodMonitor, int n3) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{l, n, n2}, n3, 7);
        }
    }

    @InfoMethod
    private void closingInfo(CorbaConnection corbaConnection, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{corbaConnection}, n, 2);
        }
    }

    @InfoMethod
    private void connectionsReclaimedInfo(long l, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{l}, n, 3);
        }
    }

    static {
        MethodMonitorRegistry.registerClass(CorbaConnectionCacheBase.class);
        wrapper = ORBUtilSystemException.self;
    }
}

