/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.presentation.rmi.DynamicStubImpl;
import com.sun.corba.ee.impl.presentation.rmi.StubInvocationHandlerImpl;
import com.sun.corba.ee.spi.orbutil.proxy.CompositeInvocationHandlerImpl;
import com.sun.corba.ee.spi.orbutil.proxy.DelegateInvocationHandlerImpl;
import com.sun.corba.ee.spi.orbutil.proxy.InvocationHandlerFactory;
import com.sun.corba.ee.spi.orbutil.proxy.LinkedInvocationHandler;
import com.sun.corba.ee.spi.presentation.rmi.DynamicStub;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.omg.CORBA.Object;

public class InvocationHandlerFactoryImpl
implements InvocationHandlerFactory {
    private final PresentationManager.ClassData classData;
    private final PresentationManager pm;
    private Class<?>[] proxyInterfaces;

    public InvocationHandlerFactoryImpl(PresentationManager pm, PresentationManager.ClassData classData) {
        this.classData = classData;
        this.pm = pm;
        Class[] remoteInterfaces = classData.getIDLNameTranslator().getInterfaces();
        this.proxyInterfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, this.proxyInterfaces, 0, remoteInterfaces.length);
        this.proxyInterfaces[remoteInterfaces.length] = DynamicStub.class;
    }

    public InvocationHandler getInvocationHandler() {
        DynamicStubImpl stub = new DynamicStubImpl(this.classData.getTypeIds());
        return this.getInvocationHandler(stub);
    }

    InvocationHandler getInvocationHandler(DynamicStub stub) {
        InvocationHandler dynamicStubHandler = DelegateInvocationHandlerImpl.create((java.lang.Object)stub);
        StubInvocationHandlerImpl stubMethodHandler = new StubInvocationHandlerImpl(this.pm, this.classData, stub);
        CustomCompositeInvocationHandlerImpl handler = new CustomCompositeInvocationHandlerImpl(stub);
        handler.addInvocationHandler(DynamicStub.class, dynamicStubHandler);
        handler.addInvocationHandler(Object.class, dynamicStubHandler);
        handler.addInvocationHandler(java.lang.Object.class, dynamicStubHandler);
        handler.setDefaultHandler((InvocationHandler)((java.lang.Object)stubMethodHandler));
        return handler;
    }

    public Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    private static class CustomCompositeInvocationHandlerImpl
    extends CompositeInvocationHandlerImpl
    implements LinkedInvocationHandler,
    Serializable {
        private transient DynamicStub stub;

        public void setProxy(Proxy proxy) {
            if (!(proxy instanceof DynamicStub)) {
                throw new RuntimeException("Proxy not instance of DynamicStub");
            }
            ((DynamicStubImpl)this.stub).setSelf((DynamicStub)((java.lang.Object)proxy));
        }

        public Proxy getProxy() {
            return (Proxy)((java.lang.Object)((DynamicStubImpl)this.stub).getSelf());
        }

        public CustomCompositeInvocationHandlerImpl(DynamicStub stub) {
            this.stub = stub;
        }

        public java.lang.Object writeReplace() throws ObjectStreamException {
            return this.stub;
        }
    }
}

