/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.LogLevel;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.logex.WrapperGenerator;
import com.sun.corba.ee.spi.orbutil.logex.stdcorba.StandardLogger;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;

@ExceptionWrapper(idPrefix="ORBIO")
public interface Exceptions {
    public static final Exceptions self = (Exceptions)WrapperGenerator.makeWrapper(Exceptions.class, (WrapperGenerator.Extension)StandardLogger.self);
    public static final int EXCEPTIONS_PER_CLASS = 100;
    public static final int IIS_START = 1;
    public static final int IOS_START = 101;
    public static final int ISH_START = 201;
    public static final int OSC_START = 301;
    public static final int OSH_START = 401;
    public static final int VHI_START = 501;

    @Message(value="No optional data exception constructor available")
    @Log(id=1)
    public ExceptionInInitializerError noOptionalDataExceptionConstructor(@Chain Exception var1);

    @Message(value="Can't create optional data exception")
    @Log(id=2)
    public Error cantCreateOptionalDataException(@Chain Exception var1);

    @Message(value="readLine method not supported")
    @Log(id=3)
    public IOException readLineMethodNotSupported();

    @Message(value="registerValidation method not supported")
    @Log(id=4)
    public Error registerValidationNotSupport();

    @Message(value="resolveClass method not supported")
    @Log(id=5)
    public IOException resolveClassNotSupported();

    @Message(value="resolveObject method not supported")
    @Log(id=6)
    public IOException resolveObjectNotSupported();

    @Message(value="IllegalAccessException when invoking readObject")
    @Log(id=7)
    public void illegalAccessInvokingObjectRead(@Chain IllegalAccessException var1);

    @Message(value="Bad type {0} for primitive field")
    @Log(id=8)
    public InvalidClassException invalidClassForPrimitive(String var1);

    @Message(value="Unknown call type {0} while reading object field: possible stream corruption")
    @Log(id=9)
    public StreamCorruptedException unknownCallType(int var1);

    @Message(value="Unknown typecode kind {0} while reading object field: possible stream corruption")
    @Log(id=10)
    public StreamCorruptedException unknownTypecodeKind(int var1);

    @Message(value="Assigning instance of class {0} to field {1}")
    @Log(id=11)
    public ClassCastException couldNotAssignObjectToField(@Chain IllegalArgumentException var1, String var2, String var3);

    @Message(value="Not setting field {0} on class {1}: likely that class has evolved")
    @Log(level=LogLevel.FINE, id=12)
    public void notSettingField(String var1, String var2);

    @Message(value="Stream corrupted")
    @Log(id=13)
    public StreamCorruptedException streamCorrupted(Throwable var1);

    @Log(id=14)
    @Message(value="Could not unmarshal enum with cls {0}, value {1} using EnumDesc")
    public IOException couldNotUnmarshalEnum(String var1, String var2);

    @Message(value="method annotateClass not supported")
    @Log(id=102)
    public IOException annotateClassNotSupported();

    @Message(value="method replaceObject not supported")
    @Log(id=103)
    public IOException replaceObjectNotSupported();

    @Message(value="serialization of ObjectStreamClass not supported")
    @Log(id=104)
    public IOException serializationObjectStreamClassNotSupported();

    @Message(value="serialization of ObjectStreamClass not supported")
    @Log(id=105)
    public NotSerializableException notSerializable(String var1);

    @Message(value="Invalid class {0} for writing field")
    @Log(id=106)
    public InvalidClassException invalidClassForWrite(String var1);

    @Message(value="Default data already read")
    @Log(id=202)
    public StreamCorruptedException defaultDataAlreadyRead();

    @Message(value="Default data must be read first")
    @Log(id=203)
    public StreamCorruptedException defaultDataMustBeReadFirst();

    @Message(value="Default data not sent or already read")
    @Log(id=204)
    public StreamCorruptedException defaultDataNotPresent();

    @Message(value="Default data not sent or already read")
    @Log(level=LogLevel.FINE, id=302)
    public void couldNotAccessSerialPersistentFields(@Chain Exception var1, String var2);

    @Message(value="Field type mismatch in Class {0} for field (name {1}, type {2})and reflected field (name {3}, type {4})")
    @Log(level=LogLevel.FINE, id=303)
    public void fieldTypeMismatch(String var1, String var2, Class<?> var3, String var4, Class<?> var5);

    @Message(value="Could not find field {1} in class {0}")
    @Log(level=LogLevel.FINE, id=304)
    public void noSuchField(@Chain NoSuchFieldException var1, String var2, String var3);

    @Message(value="Could not hasStaticInitializer method in class {0}")
    @Log(id=305)
    public InternalError cantFindHasStaticInitializer(String var1);

    @Message(value="Could not invoke hasStaticInitializer method")
    @Log(id=306)
    public InternalError errorInvokingHasStaticInitializer(@Chain Exception var1);

    @Message(value="Call writeObject twice")
    @Log(id=402)
    public IOException calledWriteObjectTwice();

    @Message(value="Call defaultWriteObject or writeFields twice")
    @Log(id=403)
    public IOException calledDefaultWriteObjectTwice();

    @Message(value="Cannot call defaultWriteObject or writeFields after writing custom data")
    @Log(id=404)
    public IOException defaultWriteObjectAfterCustomData();

    @Message(value="Invalid primitive type {0}")
    @Log(id=502)
    public Error invalidPrimitiveType(String var1);

    @Message(value="Invalid primitive component type {0}")
    @Log(id=503)
    public Error invalidPrimitiveComponentType(String var1);
}

