/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.util;

import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.util.PackagePrefixChecker;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.StubEntry;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.UtilSystemException;
import com.sun.corba.ee.spi.orbutil.ORBClassLoader;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import javax.rmi.CORBA.Tie;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.PortableServer.Servant;
import org.omg.stub.java.rmi._Remote_Stub;

public final class Utility {
    public static final String STUB_PREFIX = "_";
    public static final String RMI_STUB_SUFFIX = "_Stub";
    public static final String DYNAMIC_STUB_SUFFIX = "_DynamicStub";
    public static final String IDL_STUB_SUFFIX = "Stub";
    public static final String TIE_SUFIX = "_Tie";
    private static final IdentityHashMap tieCache = new IdentityHashMap();
    private static final IdentityHashMap tieToStubCache = new IdentityHashMap();
    private static final IdentityHashMap stubToTieCache = new IdentityHashMap();
    private static final java.lang.Object CACHE_MISS = new java.lang.Object();
    private static final UtilSystemException wrapper = UtilSystemException.self;
    private static final OMGSystemException omgWrapper = OMGSystemException.self;

    public static java.lang.Object autoConnect(java.lang.Object obj, org.omg.CORBA.ORB orb, boolean convertToStub) {
        if (obj == null) {
            return obj;
        }
        if (StubAdapter.isStub(obj)) {
            try {
                StubAdapter.getDelegate(obj);
            }
            catch (BAD_OPERATION okay) {
                try {
                    StubAdapter.connect(obj, orb);
                }
                catch (RemoteException e) {
                    throw wrapper.objectNotConnected(e, obj.getClass().getName());
                }
            }
            return obj;
        }
        if (obj instanceof Remote) {
            Remote remoteObj = (Remote)obj;
            Tie theTie = Util.getInstance().getTie(remoteObj);
            if (theTie != null) {
                try {
                    theTie.orb();
                }
                catch (SystemException okay) {
                    theTie.orb(orb);
                }
                if (convertToStub) {
                    Remote result = Utility.loadStub(theTie, null, null, true);
                    if (result != null) {
                        return result;
                    }
                    throw wrapper.couldNotLoadStub(obj.getClass().getName());
                }
                return StubAdapter.activateTie(theTie);
            }
            throw wrapper.objectNotExported(obj.getClass().getName());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tie loadTie(Remote obj) {
        Tie result = null;
        Class<?> objClass = obj.getClass();
        IdentityHashMap identityHashMap = tieCache;
        synchronized (identityHashMap) {
            java.lang.Object it = tieCache.get(obj);
            if (it == null) {
                try {
                    result = Utility.loadTie(objClass);
                    while (result == null && (objClass = objClass.getSuperclass()) != null && objClass != PortableRemoteObject.class && objClass != java.lang.Object.class) {
                        result = Utility.loadTie(objClass);
                    }
                }
                catch (Exception ex) {
                    wrapper.loadTieFailed(ex, objClass.getName());
                }
                if (result == null) {
                    tieCache.put(obj, CACHE_MISS);
                } else {
                    tieCache.put(obj, result);
                }
            } else if (it != CACHE_MISS) {
                try {
                    result = (Tie)it.getClass().newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private static Tie loadTie(Class theClass) {
        return com.sun.corba.ee.spi.orb.ORB.getStubFactoryFactory().getTie(theClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        IdentityHashMap identityHashMap = tieToStubCache;
        synchronized (identityHashMap) {
            tieToStubCache.clear();
        }
        identityHashMap = tieCache;
        synchronized (identityHashMap) {
            tieCache.clear();
        }
        identityHashMap = stubToTieCache;
        synchronized (identityHashMap) {
            stubToTieCache.clear();
        }
    }

    static Class loadClassOfType(String className, String remoteCodebase, ClassLoader loader, Class expectedType, ClassLoader expectedTypeClassLoader) throws ClassNotFoundException {
        Class<java.lang.Object> loadedClass;
        block7: {
            loadedClass = null;
            try {
                try {
                    String wpp = PackagePrefixChecker.withoutPackagePrefix(className);
                    loadedClass = !PackagePrefixChecker.hasOffendingPrefix(wpp) ? Util.getInstance().loadClass(wpp, remoteCodebase, loader) : Util.getInstance().loadClass(className, remoteCodebase, loader);
                }
                catch (ClassNotFoundException cnfe) {
                    loadedClass = Util.getInstance().loadClass(className, remoteCodebase, loader);
                }
                if (expectedType == null) {
                    return loadedClass;
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (expectedType != null) break block7;
                throw cnfe;
            }
        }
        if (loadedClass == null || !expectedType.isAssignableFrom(loadedClass)) {
            if (expectedType.getClassLoader() != expectedTypeClassLoader) {
                throw new IllegalArgumentException("expectedTypeClassLoader not class loader of expected Type.");
            }
            loadedClass = expectedTypeClassLoader != null ? expectedTypeClassLoader.loadClass(className) : ORBClassLoader.loadClass(className);
        }
        return loadedClass;
    }

    public static Class loadClassForClass(String className, String remoteCodebase, ClassLoader loader, Class relatedType, ClassLoader relatedTypeClassLoader) throws ClassNotFoundException {
        Class<?> loadedClass;
        block6: {
            if (relatedType == null) {
                return Util.getInstance().loadClass(className, remoteCodebase, loader);
            }
            loadedClass = null;
            try {
                loadedClass = Util.getInstance().loadClass(className, remoteCodebase, loader);
            }
            catch (ClassNotFoundException cnfe) {
                if (relatedType.getClassLoader() != null) break block6;
                throw cnfe;
            }
        }
        if (loadedClass == null || loadedClass.getClassLoader() != null && loadedClass.getClassLoader().loadClass(relatedType.getName()) != relatedType) {
            if (relatedType.getClassLoader() != relatedTypeClassLoader) {
                throw new IllegalArgumentException("relatedTypeClassLoader not class loader of relatedType.");
            }
            if (relatedTypeClassLoader != null) {
                loadedClass = relatedTypeClassLoader.loadClass(className);
            }
        }
        return loadedClass;
    }

    public static BoxedValueHelper getHelper(Class clazz, String codebase, String repId) {
        String className = null;
        if (clazz != null) {
            className = clazz.getName();
            if (codebase == null) {
                codebase = Util.getInstance().getCodebase(clazz);
            }
        } else {
            if (repId != null) {
                className = RepositoryId.cache.getId(repId).getClassName();
            }
            if (className == null) {
                throw wrapper.unableLocateValueHelper();
            }
        }
        try {
            ClassLoader clazzLoader = clazz == null ? null : clazz.getClassLoader();
            Class helperClass = Utility.loadClassForClass(className + "Helper", codebase, clazzLoader, clazz, clazzLoader);
            return (BoxedValueHelper)helperClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw wrapper.unableLocateValueHelper(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw wrapper.unableLocateValueHelper(iae);
        }
        catch (InstantiationException ie) {
            throw wrapper.unableLocateValueHelper(ie);
        }
        catch (ClassCastException cce) {
            throw wrapper.unableLocateValueHelper(cce);
        }
    }

    public static ValueFactory getFactory(Class clazz, String codebase, org.omg.CORBA.ORB orb, String repId) {
        ValueFactory factory = null;
        if (orb != null && repId != null) {
            try {
                factory = ((ORB)orb).lookup_value_factory(repId);
            }
            catch (BAD_PARAM ex) {
                // empty catch block
            }
        }
        String className = null;
        if (clazz != null) {
            className = clazz.getName();
            if (codebase == null) {
                codebase = Util.getInstance().getCodebase(clazz);
            }
        } else {
            if (repId != null) {
                className = RepositoryId.cache.getId(repId).getClassName();
            }
            if (className == null) {
                throw omgWrapper.unableLocateValueFactory();
            }
        }
        if (factory != null && (!factory.getClass().getName().equals(className + "DefaultFactory") || clazz == null && codebase == null)) {
            return factory;
        }
        try {
            ClassLoader clazzLoader = clazz == null ? null : clazz.getClassLoader();
            Class factoryClass = Utility.loadClassForClass(className + "DefaultFactory", codebase, clazzLoader, clazz, clazzLoader);
            return (ValueFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw omgWrapper.unableLocateValueFactory(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw omgWrapper.unableLocateValueFactory(iae);
        }
        catch (InstantiationException ie) {
            throw omgWrapper.unableLocateValueFactory(ie);
        }
        catch (ClassCastException cce) {
            throw omgWrapper.unableLocateValueFactory(cce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Remote loadStub(Tie tie, PresentationManager.StubFactory stubFactory, String remoteCodebase, boolean onlyMostDerived) {
        StubEntry entry = null;
        IdentityHashMap identityHashMap = tieToStubCache;
        synchronized (identityHashMap) {
            java.lang.Object cached = tieToStubCache.get(tie);
            if (cached == null) {
                entry = Utility.loadStubAndUpdateCache(tie, stubFactory, remoteCodebase, onlyMostDerived);
            } else if (cached != CACHE_MISS) {
                entry = (StubEntry)cached;
                if (!entry.mostDerived && onlyMostDerived) {
                    entry = Utility.loadStubAndUpdateCache(tie, null, remoteCodebase, true);
                } else if (stubFactory != null && !StubAdapter.getTypeIds(entry.stub)[0].equals(stubFactory.getTypeIds()[0])) {
                    entry = Utility.loadStubAndUpdateCache(tie, null, remoteCodebase, true);
                    if (entry == null) {
                        entry = Utility.loadStubAndUpdateCache(tie, stubFactory, remoteCodebase, onlyMostDerived);
                    }
                } else {
                    try {
                        Delegate stubDel = StubAdapter.getDelegate(entry.stub);
                    }
                    catch (Exception e2) {
                        try {
                            Delegate del = StubAdapter.getDelegate(tie);
                            StubAdapter.setDelegate(entry.stub, del);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (entry != null) {
            return (Remote)entry.stub;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static StubEntry loadStubAndUpdateCache(Tie tie, PresentationManager.StubFactory stubFactory, String remoteCodebase, boolean onlyMostDerived) {
        stub = null;
        entry = null;
        tieIsStub = StubAdapter.isStub(tie);
        if (stubFactory != null) {
            try {
                stub = stubFactory.makeStub();
            }
            catch (Throwable e) {
                Utility.wrapper.stubFactoryCouldNotMakeStub(e);
                if (!(e instanceof ThreadDeath)) ** GOTO lbl53
                throw (ThreadDeath)e;
            }
        } else {
            ids = null;
            ids = tieIsStub != false ? StubAdapter.getTypeIds(tie) : ((Servant)tie)._all_interfaces(null, null);
            if (remoteCodebase == null) {
                remoteCodebase = Util.getInstance().getCodebase(tie.getClass());
            }
            if (ids.length == 0) {
                stub = new _Remote_Stub();
            } else {
                errors = new ArrayList<Exception>();
                for (i = 0; i < ids.length; ++i) {
                    if (ids[i].length() == 0) {
                        stub = new _Remote_Stub();
                        break;
                    }
                    try {
                        stubFactoryFactory = com.sun.corba.ee.spi.orb.ORB.getStubFactoryFactory();
                        rid = RepositoryId.cache.getId(ids[i]);
                        className = rid.getClassName();
                        isIDLInterface = rid.isIDLType();
                        stubFactory = stubFactoryFactory.createStubFactory(className, isIDLInterface, remoteCodebase, null, ORBClassLoader.getClassLoader());
                        stub = stubFactory.makeStub();
                        break;
                    }
                    catch (Exception e) {
                        errors.add(e);
                        if (onlyMostDerived) break;
                        continue;
                    }
                }
                iter = errors.iterator();
                if (stub == null) {
                    while (iter.hasNext()) {
                        exc = (Exception)iter.next();
                        Utility.wrapper.failureInMakeStubFromRepositoryId(exc);
                    }
                    Utility.wrapper.couldNotMakeStubFromRepositoryId();
                } else {
                    while (iter.hasNext()) {
                        exc = (Exception)iter.next();
                        Utility.wrapper.errorInMakeStubFromRepositoryId(exc);
                    }
                }
            }
        }
lbl53:
        // 5 sources

        if (stub == null) {
            Utility.tieToStubCache.put(tie, Utility.CACHE_MISS);
        } else {
            if (tieIsStub) {
                try {
                    del = StubAdapter.getDelegate(tie);
                    StubAdapter.setDelegate(stub, del);
                }
                catch (Exception e1) {
                    var8_12 = Utility.stubToTieCache;
                    synchronized (var8_12) {
                        Utility.stubToTieCache.put(stub, tie);
                    }
                }
            } else {
                try {
                    delegate = StubAdapter.getDelegate(tie);
                    StubAdapter.setDelegate(stub, delegate);
                }
                catch (BAD_INV_ORDER bad) {
                    var8_12 = Utility.stubToTieCache;
                    synchronized (var8_12) {
                        Utility.stubToTieCache.put(stub, tie);
                    }
                }
                catch (Exception e) {
                    throw Utility.wrapper.noPoa(e);
                }
            }
            entry = new StubEntry(stub, onlyMostDerived);
            Utility.tieToStubCache.put(tie, entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tie getAndForgetTie(Object stub) {
        IdentityHashMap identityHashMap = stubToTieCache;
        synchronized (identityHashMap) {
            return (Tie)stubToTieCache.remove(stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeStubForTie(Tie tie) {
        StubEntry entry;
        IdentityHashMap identityHashMap = tieToStubCache;
        synchronized (identityHashMap) {
            entry = (StubEntry)tieToStubCache.remove(tie);
        }
        if (entry != null) {
            identityHashMap = stubToTieCache;
            synchronized (identityHashMap) {
                stubToTieCache.remove(entry.stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeTieAndServant(Tie tie) {
        IdentityHashMap identityHashMap = tieCache;
        synchronized (identityHashMap) {
            Remote target = tie.getTarget();
            if (target != null) {
                tieCache.remove(target);
            }
        }
    }

    public static String stubNameFromRepID(String repID) {
        RepositoryId id = RepositoryId.cache.getId(repID);
        String className = id.getClassName();
        className = id.isIDLType() ? Utility.idlStubName(className) : Utility.stubName(className);
        return className;
    }

    public static Remote loadStub(Object narrowFrom, Class narrowTo) {
        Remote result = null;
        try {
            String codebase = null;
            Delegate delegate = null;
            try {
                delegate = StubAdapter.getDelegate(narrowFrom);
                codebase = ((org.omg.CORBA_2_3.portable.Delegate)delegate).get_codebase(narrowFrom);
            }
            catch (ClassCastException e) {
                wrapper.classCastExceptionInLoadStub(e);
            }
            org.omg.CORBA.ORB orb = delegate.orb(narrowFrom);
            PresentationManager.StubFactoryFactory sff = null;
            if (orb instanceof com.sun.corba.ee.spi.orb.ORB) {
                sff = com.sun.corba.ee.spi.orb.ORB.getStubFactoryFactory();
            } else {
                PresentationManager pm = com.sun.corba.ee.spi.orb.ORB.getPresentationManager();
                sff = pm.getStubFactoryFactory(false);
            }
            PresentationManager.StubFactory sf = sff.createStubFactory(narrowTo.getName(), false, codebase, narrowTo, narrowTo.getClassLoader());
            result = (Remote)sf.makeStub();
            StubAdapter.setDelegate(result, StubAdapter.getDelegate(narrowFrom));
        }
        catch (Exception err) {
            wrapper.exceptionInLoadStub(err);
        }
        return result;
    }

    public static Class loadStubClass(String repID, String remoteCodebase, Class expectedType) throws ClassNotFoundException {
        if (repID.length() == 0) {
            throw new ClassNotFoundException();
        }
        String className = Utility.stubNameFromRepID(repID);
        ClassLoader expectedTypeClassLoader = expectedType == null ? null : expectedType.getClassLoader();
        try {
            return Utility.loadClassOfType(className, remoteCodebase, expectedTypeClassLoader, expectedType, expectedTypeClassLoader);
        }
        catch (ClassNotFoundException e) {
            return Utility.loadClassOfType(PackagePrefixChecker.packagePrefix() + className, remoteCodebase, expectedTypeClassLoader, expectedType, expectedTypeClassLoader);
        }
    }

    public static String stubName(String className) {
        return Utility.stubName(className, false);
    }

    public static String dynamicStubName(String className) {
        return Utility.stubName(className, true);
    }

    private static String stubName(String className, boolean isDynamic) {
        String name = Utility.stubNameForCompiler(className, isDynamic);
        if (PackagePrefixChecker.hasOffendingPrefix(name)) {
            name = PackagePrefixChecker.packagePrefix() + name;
        }
        return name;
    }

    public static String stubNameForCompiler(String className) {
        return Utility.stubNameForCompiler(className, false);
    }

    private static String stubNameForCompiler(String className, boolean isDynamic) {
        String suffix;
        int index = className.indexOf(36);
        if (index < 0) {
            index = className.lastIndexOf(46);
        }
        String string = suffix = isDynamic ? DYNAMIC_STUB_SUFFIX : RMI_STUB_SUFFIX;
        if (index > 0) {
            return className.substring(0, index + 1) + STUB_PREFIX + className.substring(index + 1) + suffix;
        }
        return STUB_PREFIX + className + suffix;
    }

    public static String tieName(String className) {
        return PackagePrefixChecker.hasOffendingPrefix(Utility.tieNameForCompiler(className)) ? PackagePrefixChecker.packagePrefix() + Utility.tieNameForCompiler(className) : Utility.tieNameForCompiler(className);
    }

    public static String tieNameForCompiler(String className) {
        int index = className.indexOf(36);
        if (index < 0) {
            index = className.lastIndexOf(46);
        }
        if (index > 0) {
            return className.substring(0, index + 1) + STUB_PREFIX + className.substring(index + 1) + TIE_SUFIX;
        }
        return STUB_PREFIX + className + TIE_SUFIX;
    }

    public static void throwNotSerializableForCorba(String className) {
        throw omgWrapper.notSerializable(className);
    }

    public static String idlStubName(String className) {
        String result = null;
        int index = className.lastIndexOf(46);
        result = index > 0 ? className.substring(0, index + 1) + STUB_PREFIX + className.substring(index + 1) + IDL_STUB_SUFFIX : STUB_PREFIX + className + IDL_STUB_SUFFIX;
        return result;
    }

    public static void printStackTrace() {
        Throwable thr = new Throwable("Printing stack trace:");
        thr.fillInStackTrace();
        thr.printStackTrace();
    }

    public static java.lang.Object readObjectAndNarrow(org.omg.CORBA.portable.InputStream in, Class narrowTo) throws ClassCastException {
        Object result = in.read_Object();
        if (result != null) {
            return PortableRemoteObject.narrow((java.lang.Object)result, (Class)narrowTo);
        }
        return null;
    }

    public static java.lang.Object readAbstractAndNarrow(InputStream in, Class narrowTo) throws ClassCastException {
        java.lang.Object result = in.read_abstract_interface();
        if (result != null) {
            return PortableRemoteObject.narrow((java.lang.Object)result, (Class)narrowTo);
        }
        return null;
    }

    static int hexOf(char x) {
        int val = x - 48;
        if (val >= 0 && val <= 9) {
            return val;
        }
        val = x - 97 + 10;
        if (val >= 10 && val <= 15) {
            return val;
        }
        val = x - 65 + 10;
        if (val >= 10 && val <= 15) {
            return val;
        }
        throw wrapper.badHexDigit();
    }
}

