/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import org.omg.CORBA.ORB;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class ByteBufferWithInfo {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ByteBuffer byteBuffer;
    private int needed;
    private boolean fragmented;
    private static Holder __$mm$__0;

    public ByteBufferWithInfo(ORB orb, ByteBuffer byteBuffer, int index) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        this.setByteBuffer(byteBuffer);
        this.position(index);
        this.setNumberOfBytesNeeded(0);
        this.setFragmented(false);
    }

    public ByteBufferWithInfo(ORB orb, ByteBuffer byteBuffer) {
        this(orb, byteBuffer, 0);
    }

    public ByteBufferWithInfo(ORB orb, BufferManagerWrite bufferManager) {
        this(orb, bufferManager, true);
    }

    @InfoMethod
    private void bufferMessage(String string, int n, String string2, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, n, string2}, n2, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    private void bbinfo(ByteBuffer byteBuffer) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[]{byteBuffer});
        }
        try {
            void __$mm$__;
            if (this.orb.transportDebugFlag) {
                void buff;
                int bbAddress = System.identityHashCode(buff);
                this.bufferMessage("constructor (ORB, BufferManagerWrite) - got ByteBuffer id (", bbAddress, ") from ByteBufferPool.", (MethodMonitor)__$mm$__, 0);
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    public ByteBufferWithInfo(ORB orb, BufferManagerWrite bufferManager, boolean usePooledByteBuffers) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        int bufferSize = bufferManager.getBufferSize();
        if (usePooledByteBuffers) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            this.setByteBuffer(byteBufferPool.getByteBuffer(bufferSize));
            this.bbinfo(this.getByteBuffer());
        } else {
            this.setByteBuffer(ByteBuffer.allocate(bufferSize));
        }
        this.position(0);
        this.setLength(bufferSize);
        this.setNumberOfBytesNeeded(0);
        this.setFragmented(false);
    }

    public ByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        this.orb = bbwi.orb;
        this.setByteBuffer(bbwi.getByteBuffer().duplicate());
        this.setLength(bbwi.getLength());
        this.position(bbwi.position());
        this.setNumberOfBytesNeeded(bbwi.getNumberOfBytesNeeded());
        this.setFragmented(bbwi.isFragmented());
    }

    public int getSize() {
        return this.position();
    }

    public int getCapacity() {
        return this.getByteBuffer().capacity();
    }

    public int getLength() {
        return this.getByteBuffer().limit();
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    private int getNumberOfBytesNeeded() {
        return this.needed;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int position() {
        return this.getByteBuffer().position();
    }

    public void position(int newPosition) {
        this.getByteBuffer().position(newPosition);
    }

    public void flip() {
        this.getByteBuffer().flip();
    }

    public void setLength(int theLength) {
        this.getByteBuffer().limit(theLength);
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    public void setNumberOfBytesNeeded(int needed) {
        this.needed = needed;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transport
    public void growBuffer(com.sun.corba.ee.spi.orb.ORB oRB) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(2, new Object[]{oRB});
        }
        try {
            void __$mm$__;
            void orb;
            int newLength;
            for (newLength = this.getLength() * 2; this.position() + this.getNumberOfBytesNeeded() >= newLength; newLength *= 2) {
            }
            ByteBufferPool byteBufferPool = orb.getByteBufferPool();
            ByteBuffer newBB = byteBufferPool.getByteBuffer(newLength);
            if (orb.transportDebugFlag) {
                int newbbAddress = System.identityHashCode(newBB);
                this.bufferMessage("growBuffer() - got ByteBuffer id (", newbbAddress, ") from ByteBufferPool.", (MethodMonitor)__$mm$__, 2);
            }
            this.flip();
            newBB.put(this.getByteBuffer());
            if (orb.transportDebugFlag) {
                int bbAddress = System.identityHashCode(this.getByteBuffer());
                this.bufferMessage("growBuffer() - releasing ByteBuffer id (", bbAddress, ") to ByteBufferPool.", (MethodMonitor)__$mm$__, 2);
            }
            byteBufferPool.releaseByteBuffer(this.getByteBuffer());
            this.setByteBuffer(newBB);
            this.setLength(newLength);
            if (__$mm$__ != null) {
                __$mm$__.exit(2);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(2);
            }
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer("ByteBufferWithInfo:");
        str.append(" length = " + this.getLength());
        str.append(" position = " + this.position());
        str.append(" needed = " + this.getNumberOfBytesNeeded());
        str.append(" byteBuffer = " + (this.getByteBuffer() == null ? "null" : "not null"));
        str.append(" fragmented = " + this.isFragmented());
        return str.toString();
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("ByteBufferWithInfo", msg);
    }

    static {
        MethodMonitorRegistry.registerClass(ByteBufferWithInfo.class);
    }
}

