/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.oa;

import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.copyobject.ObjectCopierFactory;
import com.sun.corba.ee.spi.protocol.PIHandler;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableInterceptor.ObjectReferenceFactory;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;

public abstract class ObjectAdapterBase
extends LocalObject
implements ObjectAdapter {
    protected static final POASystemException wrapper = POASystemException.self;
    private ORB orb;
    private IORTemplate iortemp;
    private byte[] adapterId;
    private ObjectReferenceTemplate adapterTemplate;
    private ObjectReferenceFactory currentFactory;
    private boolean isNameService = false;

    public ObjectAdapterBase(ORB orb) {
        this.orb = orb;
    }

    public final POASystemException wrapper() {
        return wrapper;
    }

    public final void initializeTemplate(ObjectKeyTemplate oktemp, boolean notifyORB, Policies policies, String codebase, String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        PIHandler pih;
        this.adapterId = oktemp.getAdapterId();
        this.iortemp = IORFactories.makeIORTemplate(oktemp);
        this.orb.getCorbaTransportManager().addToIORTemplate(this.iortemp, policies, codebase, objectAdapterManagerId, objectAdapterId);
        this.adapterTemplate = IORFactories.makeObjectReferenceTemplate(this.orb, this.iortemp);
        this.currentFactory = this.adapterTemplate;
        if (notifyORB && (pih = this.orb.getPIHandler()) != null) {
            pih.objectAdapterCreated(this);
        }
        this.iortemp.makeImmutable();
    }

    public final Object makeObject(String repId, byte[] oid) {
        if (repId == null) {
            throw wrapper.nullRepositoryId();
        }
        return this.currentFactory.make_object(repId, oid);
    }

    public final byte[] getAdapterId() {
        return this.adapterId;
    }

    @Override
    public final ORB getORB() {
        return this.orb;
    }

    @Override
    public abstract Policy getEffectivePolicy(int var1);

    @Override
    public final IORTemplate getIORTemplate() {
        return this.iortemp;
    }

    @Override
    public abstract int getManagerId();

    @Override
    public abstract short getState();

    @ManagedAttribute(id="State")
    @Description(value="The current Adapter state")
    private String getDisplayState() {
        short state = this.getState();
        switch (state) {
            case 0: {
                return "HOLDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "DISCARDING";
            }
            case 3: {
                return "INACTIVE";
            }
            case 4: {
                return "NON_EXISTENT";
            }
        }
        return "<INVALID>";
    }

    @Override
    public final ObjectReferenceTemplate getAdapterTemplate() {
        return this.adapterTemplate;
    }

    @Override
    public final ObjectReferenceFactory getCurrentFactory() {
        return this.currentFactory;
    }

    @Override
    public final void setCurrentFactory(ObjectReferenceFactory factory) {
        this.currentFactory = factory;
    }

    @Override
    public abstract Object getLocalServant(byte[] var1);

    @Override
    public abstract void getInvocationServant(OAInvocationInfo var1);

    @Override
    public abstract void returnServant();

    @Override
    public abstract void enter() throws OADestroyed;

    @Override
    public abstract void exit();

    protected abstract ObjectCopierFactory getObjectCopierFactory();

    @Override
    public OAInvocationInfo makeInvocationInfo(byte[] objectId) {
        OAInvocationInfo info = new OAInvocationInfo(this, objectId);
        info.setCopierFactory(this.getObjectCopierFactory());
        return info;
    }

    @Override
    public abstract String[] getInterfaces(java.lang.Object var1, byte[] var2);

    @Override
    public boolean isNameService() {
        return this.isNameService;
    }

    @Override
    public void setNameService(boolean flag) {
        this.isNameService = flag;
    }
}

