/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.Exceptions;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.UtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.StreamFormatVersion;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

@StreamFormatVersion
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public abstract class InputStreamHook
extends ObjectInputStream {
    static final OMGSystemException omgWrapper;
    static final UtilSystemException utilWrapper;
    protected ReadObjectState readObjectState = DEFAULT_STATE;
    protected static final ReadObjectState DEFAULT_STATE;
    protected static final ReadObjectState IN_READ_OBJECT_OPT_DATA;
    protected static final ReadObjectState IN_READ_OBJECT_NO_MORE_OPT_DATA;
    protected static final ReadObjectState IN_READ_OBJECT_DEFAULTS_SENT;
    protected static final ReadObjectState NO_READ_OBJECT_DEFAULTS_SENT;
    protected static final ReadObjectState IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED;
    protected static final ReadObjectState IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM;
    private static Holder __$mm$__0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @StreamFormatVersion
    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[0]);
        }
        try {
            void __$mm$__;
            this.readObjectState.beginDefaultReadObject(this);
            this.defaultReadObjectDelegate();
            this.readObjectState.endDefaultReadObject(this);
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    public abstract void defaultReadObjectDelegate();

    abstract void readFields(Map<String, Object> var1) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        this.readFields(fieldValueMap);
        this.readObjectState.endDefaultReadObject(this);
        return new HookGetFields(fieldValueMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @StreamFormatVersion
    protected void setState(ReadObjectState readObjectState) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(1, new Object[]{readObjectState});
        }
        try {
            void __$mm$__;
            void newState;
            this.readObjectState = newState;
            if (__$mm$__ != null) {
                __$mm$__.exit(1);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(1);
            }
            throw throwable;
        }
    }

    protected abstract byte getStreamFormatVersion();

    protected abstract InputStream getOrbStream();

    protected void throwOptionalDataIncompatibleException() {
        throw omgWrapper.rmiiiopOptionalDataIncompatible2();
    }

    static {
        MethodMonitorRegistry.registerClass(InputStreamHook.class);
        omgWrapper = OMGSystemException.self;
        utilWrapper = UtilSystemException.self;
        DEFAULT_STATE = new DefaultState();
        IN_READ_OBJECT_OPT_DATA = new InReadObjectOptionalDataState();
        IN_READ_OBJECT_NO_MORE_OPT_DATA = new InReadObjectNoMoreOptionalDataState();
        IN_READ_OBJECT_DEFAULTS_SENT = new InReadObjectDefaultsSentState();
        NO_READ_OBJECT_DEFAULTS_SENT = new NoReadObjectDefaultsSentState();
        IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED = new InReadObjectRemoteDidNotUseWriteObjectState();
        IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM = new InReadObjectPastDefaultsRemoteDidNotUseWOState();
    }

    protected static class NoReadObjectDefaultsSentState
    extends ReadObjectState {
        protected NoReadObjectDefaultsSentState() {
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }
    }

    protected static class InReadObjectNoMoreOptionalDataState
    extends InReadObjectOptionalDataState {
        protected InReadObjectNoMoreOptionalDataState() {
        }

        @Override
        public void readDataOverride(InputStreamHook stream) throws IOException {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectOptionalDataState
    extends ReadObjectState {
        protected InReadObjectOptionalDataState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }

        @Override
        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            throw Exceptions.self.defaultDataNotPresent();
        }
    }

    protected static class InReadObjectDefaultsSentState
    extends ReadObjectState {
        protected InReadObjectDefaultsSentState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }

        @Override
        public void endDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
            }
            stream.setState(IN_READ_OBJECT_OPT_DATA);
        }

        @Override
        public void readDataOverride(InputStreamHook stream) throws IOException {
            org.omg.CORBA.ORB orb = stream.getOrbStream().orb();
            if (orb == null || !(orb instanceof ORB)) {
                throw new StreamCorruptedException("Default data must be read first");
            }
            ORBVersion clientOrbVersion = ((ORB)orb).getORBVersion();
            if (ORBVersionFactory.getPEORB().compareTo(clientOrbVersion) <= 0 || clientOrbVersion.equals(ORBVersionFactory.getFOREIGN())) {
                throw Exceptions.self.defaultDataMustBeReadFirst();
            }
        }
    }

    protected static class InReadObjectPastDefaultsRemoteDidNotUseWOState
    extends ReadObjectState {
        protected InReadObjectPastDefaultsRemoteDidNotUseWOState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            throw Exceptions.self.defaultDataAlreadyRead();
        }

        @Override
        public void readDataOverride(InputStreamHook stream) {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectRemoteDidNotUseWriteObjectState
    extends ReadObjectState {
        protected InReadObjectRemoteDidNotUseWriteObjectState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endDefaultReadObjectOverride(InputStreamHook stream) {
            stream.setState(IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM);
        }

        @Override
        public void readDataOverride(InputStreamHook stream) {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class DefaultState
    extends ReadObjectState {
        protected DefaultState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) throws IOException {
            if (hasReadObject) {
                if (calledDefaultWriteObject) {
                    stream.setState(IN_READ_OBJECT_DEFAULTS_SENT);
                } else {
                    try {
                        if (stream.getStreamFormatVersion() == 2) {
                            ((ValueInputStream)stream.getOrbStream()).start_value();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    stream.setState(IN_READ_OBJECT_OPT_DATA);
                }
            } else if (calledDefaultWriteObject) {
                stream.setState(NO_READ_OBJECT_DEFAULTS_SENT);
            } else {
                throw new StreamCorruptedException("No default data sent");
            }
        }
    }

    @StreamFormatVersion
    @TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
    protected static class ReadObjectState {
        private final String name;
        private static Holder __$mm$__0;

        public ReadObjectState() {
            String className = this.getClass().getName();
            int index = className.indexOf(36);
            this.name = className.substring(index + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @StreamFormatVersion
        public final void beginUnmarshalCustomValue(InputStreamHook inputStreamHook, boolean bl, boolean bl2) throws IOException {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(1, new Object[]{inputStreamHook, bl, bl2});
            }
            try {
                void __$mm$__;
                void hasReadObject;
                void calledDefaultWriteObject;
                void stream;
                this.beginUnmarshalCustomValueOverride((InputStreamHook)stream, (boolean)calledDefaultWriteObject, (boolean)hasReadObject);
                if (__$mm$__ != null) {
                    __$mm$__.exit(1);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(1);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @StreamFormatVersion
        public final void endUnmarshalCustomValue(InputStreamHook inputStreamHook) throws IOException {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(3, new Object[]{inputStreamHook});
            }
            try {
                void __$mm$__;
                void stream;
                this.endUnmarshalCustomValueOverride((InputStreamHook)stream);
                if (__$mm$__ != null) {
                    __$mm$__.exit(3);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(3);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @StreamFormatVersion
        public final void beginDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(0, new Object[]{inputStreamHook});
            }
            try {
                void __$mm$__;
                void stream;
                this.beginDefaultReadObjectOverride((InputStreamHook)stream);
                if (__$mm$__ != null) {
                    __$mm$__.exit(0);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(0);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @StreamFormatVersion
        public final void endDefaultReadObject(InputStreamHook inputStreamHook) throws IOException {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(2, new Object[]{inputStreamHook});
            }
            try {
                void __$mm$__;
                void stream;
                this.endDefaultReadObjectOverride((InputStreamHook)stream);
                if (__$mm$__ != null) {
                    __$mm$__.exit(2);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @StreamFormatVersion
        public final void readData(InputStreamHook inputStreamHook) throws IOException {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(4, new Object[]{inputStreamHook});
            }
            try {
                void __$mm$__;
                void stream;
                this.readDataOverride((InputStreamHook)stream);
                if (__$mm$__ != null) {
                    __$mm$__.exit(4);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(4);
                }
                throw throwable;
            }
        }

        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) throws IOException {
        }

        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
        }

        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
        }

        public void endDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
        }

        public void readDataOverride(InputStreamHook stream) throws IOException {
        }

        public String toString() {
            return this.name;
        }

        static {
            MethodMonitorRegistry.registerClass(ReadObjectState.class);
        }
    }

    private class HookGetFields
    extends ObjectInputStream.GetField {
        private Map<String, Object> fields = null;

        HookGetFields(Map<String, Object> fields) {
            this.fields = fields;
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }

        @Override
        public boolean defaulted(String name) throws IOException, IllegalArgumentException {
            return !this.fields.containsKey(name);
        }

        @Override
        public boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Boolean)this.fields.get(name);
        }

        @Override
        public char get(String name, char defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return ((Character)this.fields.get(name)).charValue();
        }

        @Override
        public byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Byte)this.fields.get(name);
        }

        @Override
        public short get(String name, short defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Short)this.fields.get(name);
        }

        @Override
        public int get(String name, int defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Integer)this.fields.get(name);
        }

        @Override
        public long get(String name, long defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Long)this.fields.get(name);
        }

        @Override
        public float get(String name, float defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return ((Float)this.fields.get(name)).floatValue();
        }

        @Override
        public double get(String name, double defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Double)this.fields.get(name);
        }

        @Override
        public Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return this.fields.get(name);
        }

        public String toString() {
            return this.fields.toString();
        }
    }
}

