/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaOutboundConnectionCacheProbeProvider;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="Cache of connections originated by the ORB")
@AMXMetadata(type="corba-outbound-connection-cache-mon", group="monitoring")
public class CorbaOutboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements CorbaOutboundConnectionCache {
    protected Map<CorbaContactInfo, CorbaConnection> connectionCache;
    private CorbaOutboundConnectionCacheProbeProvider pp = new CorbaOutboundConnectionCacheProbeProvider();

    public CorbaOutboundConnectionCacheImpl(ORB orb, CorbaContactInfo contactInfo) {
        super(orb, contactInfo.getConnectionCacheType(), contactInfo.getMonitoringName());
        this.connectionCache = new HashMap<CorbaContactInfo, CorbaConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CorbaConnection get(CorbaContactInfo contactInfo) {
        Object object = this.backingStore();
        synchronized (object) {
            this.cacheStatisticsInfo();
            return this.connectionCache.get(contactInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(CorbaContactInfo contactInfo, CorbaConnection connection) {
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.put(contactInfo, connection);
            connection.setConnectionCache(this);
            this.pp.connectionOpenedEvent(contactInfo.toString(), connection.toString());
            this.cacheStatisticsInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CorbaContactInfo contactInfo) {
        Object object = this.backingStore();
        synchronized (object) {
            if (contactInfo != null) {
                CorbaConnection connection = this.connectionCache.remove(contactInfo);
                this.pp.connectionClosedEvent(contactInfo.toString(), connection.toString());
            }
            this.cacheStatisticsInfo();
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache.values();
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }

    public String toString() {
        return "CorbaOutboundConnectionCacheImpl[" + this.connectionCache + "]";
    }
}

