/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.logging;

import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.LogLevel;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.logex.WrapperGenerator;
import com.sun.corba.ee.spi.orbutil.logex.corba.CS;
import com.sun.corba.ee.spi.orbutil.logex.corba.CSValue;
import com.sun.corba.ee.spi.orbutil.logex.corba.CorbaExtension;
import com.sun.corba.ee.spi.orbutil.logex.corba.ORBException;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;

@ExceptionWrapper(idPrefix="IOP")
@ORBException(omgException=true, group=0)
public interface OMGSystemException {
    public static final OMGSystemException self = (OMGSystemException)WrapperGenerator.makeWrapper(OMGSystemException.class, (WrapperGenerator.Extension)CorbaExtension.self);
    public static final int NOT_SERIALIZABLE = CorbaExtension.self.getMinorCode(OMGSystemException.class, "notSerializable");
    public static final String soBadAddress = "string_to_object conversion failed due to bad address in name {0}";
    public static final int INVALID_PROFILE_ID = CorbaExtension.self.getMinorCode(OMGSystemException.class, "invalidProfileId");
    public static final String unableLocateValueFactory = "Unable to locate value factory";
    public static final int RMIIIOP_OPTIONAL_DATA_INCOMPATIBLE = CorbaExtension.self.getMinorCode(OMGSystemException.class, "rmiiiopOptionalDataIncompatible1");
    public static final String missingLocalValueImpl = "Missing local value implementation";
    public static final String noObjectAdaptor = "Failed to create or locate Object Adaptor";
    public static final String adapterActivatorException = "System exception in POA::unknown_adapter for POA {0} with parent POA {1}";
    public static final String unknownUserException = "Unlisted user exception received by client ";

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="IDL context not found")
    public BAD_CONTEXT idlContextNotFound();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="No matching IDL context property")
    public BAD_CONTEXT noMatchingIdlContext();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Dependency exists in IFR preventing destruction of this object")
    public BAD_INV_ORDER depPreventDestruction();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Attempt to destroy indestructible objects in IFR")
    public BAD_INV_ORDER destroyIndestructible();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Operation would deadlock")
    public BAD_INV_ORDER shutdownWaitForCompletionDeadlock();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="ORB has shutdown")
    public BAD_INV_ORDER badOperationAfterShutdown();

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Attempt to invoke send or invoke operation of the same Request object more than once ")
    public BAD_INV_ORDER badInvoke();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Attempt to set a servant manager after one has already been set")
    public BAD_INV_ORDER badSetServantManager();

    @Log(level=LogLevel.WARNING, id=7)
    @Message(value="ServerRequest::arguments called more than once or after a call to ServerRequest::set_exception")
    public BAD_INV_ORDER badArgumentsCall();

    @Log(level=LogLevel.WARNING, id=8)
    @Message(value="ServerRequest::ctx called more than once or before ServerRequest::arguments or after ServerRequest::ctx, ServerRequest::set_result or ServerRequest::set_exception")
    public BAD_INV_ORDER badCtxCall();

    @Log(level=LogLevel.WARNING, id=9)
    @Message(value="ServerRequest::set_result called more than once or before ServerRequest::arguments or after ServerRequest::set_result or ServerRequest::set_exception")
    public BAD_INV_ORDER badResultCall();

    @Log(level=LogLevel.WARNING, id=10)
    @Message(value="Attempt to send a DII request after it was sent previously")
    public BAD_INV_ORDER badSend();

    @Log(level=LogLevel.WARNING, id=11)
    @Message(value="Attempt to poll a DII request or to retrieve its result before the request was sent")
    public BAD_INV_ORDER badPollBefore();

    @Log(level=LogLevel.WARNING, id=12)
    @Message(value="Attempt to poll a DII request or to retrieve its result after the result was retrieved previously")
    public BAD_INV_ORDER badPollAfter();

    @Log(level=LogLevel.WARNING, id=13)
    @Message(value="Attempt to poll a synchronous DII request or to retrieve results from a synchronous DII request")
    public BAD_INV_ORDER badPollSync();

    @Log(level=LogLevel.FINE, id=14)
    @Message(value="Invalid call to forward_reference() when reply status is not LOCATION_FORWARD")
    public BAD_INV_ORDER invalidPiCall1();

    @Log(level=LogLevel.FINE, id=14)
    @Message(value="Cannot access this attribute or method at this point")
    public BAD_INV_ORDER invalidPiCall2();

    @Log(level=LogLevel.FINE, id=14)
    @Message(value="Cannot call set_slot from within an ORBInitializer")
    public BAD_INV_ORDER invalidPiCall3();

    @Log(level=LogLevel.FINE, id=14)
    @Message(value="Cannot call get_slot from within an ORBInitializer")
    public BAD_INV_ORDER invalidPiCall4();

    @Log(level=LogLevel.FINE, id=15)
    @Message(value="Service context add failed in portable interceptor because a service context with id {0} already exists")
    public BAD_INV_ORDER serviceContextAddFailed(int var1);

    @Log(level=LogLevel.WARNING, id=16)
    @Message(value="Registration of PolicyFactory failed because a factory already exists for the given PolicyType {0}")
    public BAD_INV_ORDER policyFactoryRegFailed(int var1);

    @Log(level=LogLevel.WARNING, id=17)
    @Message(value="POA cannot create POAs while undergoing destruction")
    public BAD_INV_ORDER createPoaDestroy();

    @Log(level=LogLevel.WARNING, id=18)
    @Message(value="Attempt to reassign priority")
    public BAD_INV_ORDER priorityReassign();

    @Log(level=LogLevel.WARNING, id=19)
    @Message(value="An OTS/XA integration xa_start() call returned XAER_OUTSIDE")
    public BAD_INV_ORDER xaStartOutsize();

    @Log(level=LogLevel.WARNING, id=20)
    @Message(value="An OTS/XA integration xa_ call returned XAER_PROTO")
    public BAD_INV_ORDER xaStartProto();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="ServantManager returned wrong servant type")
    public BAD_OPERATION badServantManagerType();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Operation or attribute not known to target object ")
    public BAD_OPERATION operationUnknownToTarget();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Failure to register, unregister or lookup value factory")
    public BAD_PARAM unableRegisterValueFactory();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="RID already defined in IFR")
    public BAD_PARAM ridAlreadyDefined();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Name already used in the context in IFR ")
    public BAD_PARAM nameUsedIfr();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Target is not a valid container")
    public BAD_PARAM targetNotContainer();

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Name clash in inherited context")
    public BAD_PARAM nameClash();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Class {0} is not Serializable")
    @CS(value=CSValue.MAYBE)
    public BAD_PARAM notSerializable(String var1);

    @Log(level=LogLevel.FINE, id=7)
    @Message(value="string_to_object conversion failed due to bad scheme name {0}")
    public BAD_PARAM soBadSchemeName(String var1);

    @Log(level=LogLevel.FINE, id=8)
    @Message(value="string_to_object conversion failed due to bad address in name {0}")
    public BAD_PARAM soBadAddress(@Chain Throwable var1, String var2);

    @Log(level=LogLevel.FINE, id=8)
    @Message(value="string_to_object conversion failed due to bad address in name {0}")
    public BAD_PARAM soBadAddress(String var1);

    @Log(level=LogLevel.FINE, id=9)
    @Message(value="string_to_object conversion failed due to bad schema specific part in name {0}")
    public BAD_PARAM soBadSchemaSpecific(@Chain Exception var1, String var2);

    @Log(level=LogLevel.WARNING, id=10)
    @Message(value="string_to_object conversion failed due to non specific reason")
    public BAD_PARAM soNonSpecific();

    @Log(level=LogLevel.WARNING, id=11)
    @Message(value="Attempt to derive abstract interface from non-abstract base interface in the Interface Repository")
    public BAD_PARAM irDeriveAbsIntBase();

    @Log(level=LogLevel.WARNING, id=12)
    @Message(value="Attempt to let a ValueDef support more than one non-abstract interface in the Interface Repository")
    public BAD_PARAM irValueSupport();

    @Log(level=LogLevel.WARNING, id=13)
    @Message(value="Attempt to use an incomplete TypeCode as a parameter")
    public BAD_PARAM incompleteTypecode();

    @Log(level=LogLevel.WARNING, id=14)
    @Message(value="Invalid object id passed to POA::create_reference_by_id ")
    public BAD_PARAM invalidObjectId();

    @Log(level=LogLevel.WARNING, id=15)
    @Message(value="Bad name argument in TypeCode operation")
    public BAD_PARAM typecodeBadName();

    @Log(level=LogLevel.WARNING, id=16)
    @Message(value="Bad RepositoryId argument in TypeCode operation")
    public BAD_PARAM typecodeBadRepid();

    @Log(level=LogLevel.WARNING, id=17)
    @Message(value="Invalid member name in TypeCode operation ")
    public BAD_PARAM typecodeInvMember();

    @Log(level=LogLevel.WARNING, id=18)
    @Message(value="Duplicate label value in create_union_tc ")
    public BAD_PARAM tcUnionDupLabel();

    @Log(level=LogLevel.WARNING, id=19)
    @Message(value="Incompatible TypeCode of label and discriminator in create_union_tc ")
    public BAD_PARAM tcUnionIncompatible();

    @Log(level=LogLevel.WARNING, id=20)
    @Message(value="Supplied discriminator type illegitimate in create_union_tc ")
    public BAD_PARAM tcUnionBadDisc();

    @Log(level=LogLevel.WARNING, id=21)
    @Message(value="Any passed to ServerRequest::set_exception does not contain an exception ")
    public BAD_PARAM setExceptionBadAny();

    @Log(level=LogLevel.WARNING, id=22)
    @Message(value="Unlisted user exception passed to ServerRequest::set_exception ")
    public BAD_PARAM setExceptionUnlisted();

    @Log(level=LogLevel.WARNING, id=23)
    @Message(value="wchar transmission code set not in service context")
    public BAD_PARAM noClientWcharCodesetCtx();

    @Log(level=LogLevel.WARNING, id=24)
    @Message(value="Service context is not in OMG-defined range")
    public BAD_PARAM illegalServiceContext();

    @Log(level=LogLevel.WARNING, id=25)
    @Message(value="Enum value out of range")
    public BAD_PARAM enumOutOfRange();

    @Log(level=LogLevel.FINE, id=26)
    @Message(value="Invalid service context Id in portable interceptor")
    public BAD_PARAM invalidServiceContextId();

    @Log(level=LogLevel.WARNING, id=27)
    @Message(value="Attempt to call register_initial_reference with a null Object")
    public BAD_PARAM rirWithNullObject();

    @Log(level=LogLevel.FINE, id=28)
    @Message(value="Invalid component Id {0} in portable interceptor")
    public BAD_PARAM invalidComponentId(int var1);

    @Log(level=LogLevel.WARNING, id=29)
    @Message(value="Profile ID does not define a known profile or it is impossible to add components to that profile")
    public BAD_PARAM invalidProfileId();

    @Log(level=LogLevel.WARNING, id=30)
    @Message(value="Two or more Policy objects with the same PolicyType value supplied to Object::set_policy_overrides or PolicyManager::set_policy_overrides")
    public BAD_PARAM policyTypeDuplicate();

    @Log(level=LogLevel.WARNING, id=31)
    @Message(value="Attempt to define a oneway operation with non-void result, out or inout parameters or user exceptions")
    public BAD_PARAM badOnewayDefinition();

    @Log(level=LogLevel.WARNING, id=32)
    @Message(value="DII asked to create request for an implicit operation")
    public BAD_PARAM diiForImplicitOperation();

    @Log(level=LogLevel.WARNING, id=33)
    @Message(value="An OTS/XA integration xa_ call returned XAER_INVAL")
    public BAD_PARAM xaCallInval();

    @Log(level=LogLevel.WARNING, id=34)
    @Message(value="Union branch modifier method called with bad case label discriminator")
    public BAD_PARAM unionBadDiscriminator();

    @Log(level=LogLevel.WARNING, id=35)
    @Message(value="Illegal IDL context property name")
    public BAD_PARAM ctxIllegalPropertyName();

    @Log(level=LogLevel.WARNING, id=36)
    @Message(value="Illegal IDL property search string")
    public BAD_PARAM ctxIllegalSearchString();

    @Log(level=LogLevel.WARNING, id=37)
    @Message(value="Illegal IDL context name")
    public BAD_PARAM ctxIllegalName();

    @Log(level=LogLevel.WARNING, id=38)
    @Message(value="Non-empty IDL context")
    public BAD_PARAM ctxNonEmpty();

    @Log(level=LogLevel.WARNING, id=39)
    @Message(value="Unsupported RMI/IDL custom value type stream format {0}")
    public BAD_PARAM invalidStreamFormatVersion(int var1);

    @Log(level=LogLevel.WARNING, id=40)
    @Message(value="ORB output stream does not support ValueOutputStream interface")
    @CS(value=CSValue.MAYBE)
    public BAD_PARAM notAValueoutputstream();

    @Log(level=LogLevel.WARNING, id=41)
    @Message(value="ORB input stream does not support ValueInputStream interface")
    public BAD_PARAM notAValueinputstream();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Attempt to marshal incomplete TypeCode")
    public BAD_TYPECODE marshallIncompleteTypecode();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Member type code illegitimate in TypeCode operation")
    public BAD_TYPECODE badMemberTypecode();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Illegal parameter type")
    public BAD_TYPECODE illegalParameter();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Character does not map to negotiated transmission code set")
    public DATA_CONVERSION charNotInCodeset(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Failure of PriorityMapping object")
    public DATA_CONVERSION priorityMapFailre();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Unable to use any profile in IOR")
    public IMP_LIMIT noUsableProfile();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Priority range too restricted for ORB")
    public INITIALIZE priorityRangeRestrict();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="wchar Code Set support not specified")
    public INV_OBJREF noServerWcharCodesetCmp();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Codeset component required for type using wchar or wstring data")
    public INV_OBJREF codesetComponentRequired();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Unable to reconcile IOR specified policy with effective policy override")
    public INV_POLICY iorPolicyReconcileError();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Invalid PolicyType")
    public INV_POLICY policyUnknown();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="No PolicyFactory has been registered for the given PolicyType")
    public INV_POLICY noPolicyFactory();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="An OTS/XA integration xa_ call returned XAER_RMERR")
    public INTERNAL xaRmerr();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="An OTS/XA integration xa_ call returned XAER_RMFAIL")
    public INTERNAL xaRmfail();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Interface Repository not available")
    public INTF_REPOS noIr();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="No entry for requested interface in Interface Repository")
    public INTF_REPOS noInterfaceInIr();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="Unable to locate value factory")
    @CS(value=CSValue.MAYBE)
    public MARSHAL unableLocateValueFactory();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="Unable to locate value factory")
    @CS(value=CSValue.MAYBE)
    public MARSHAL unableLocateValueFactory(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="ServerRequest::set_result called before ServerRequest::ctx when the operation IDL contains a context clause ")
    public MARSHAL setResultBeforeCtx();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="NVList passed to ServerRequest::arguments does not describe all parameters passed by client")
    public MARSHAL badNvlist();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Attempt to marshal Local object")
    public MARSHAL notAnObjectImpl(@Chain BAD_PARAM var1);

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="wchar or wstring data erroneously sent by client over GIOP 1.0 connection ")
    public MARSHAL wcharBadGiopVersionSent();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="wchar or wstring data erroneously returned by server over GIOP 1.0 connection ")
    public MARSHAL wcharBadGiopVersionReturned();

    @Log(level=LogLevel.WARNING, id=7)
    @Message(value="Unsupported RMI/IDL custom value type stream format")
    @CS(value=CSValue.MAYBE)
    public MARSHAL unsupportedFormatVersion();

    @Log(level=LogLevel.FINE, id=8)
    @Message(value="No optional data available")
    public MARSHAL rmiiiopOptionalDataIncompatible1();

    @Log(level=LogLevel.FINE, id=8)
    @Message(value="Not enough space left in current chunk")
    public MARSHAL rmiiiopOptionalDataIncompatible2();

    @Log(level=LogLevel.FINE, id=8)
    @Message(value="Not enough optional data available")
    public MARSHAL rmiiiopOptionalDataIncompatible3();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Missing local value implementation")
    @CS(value=CSValue.MAYBE)
    public NO_IMPLEMENT missingLocalValueImpl(@Chain Throwable var1);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Missing local value implementation")
    @CS(value=CSValue.MAYBE)
    public NO_IMPLEMENT missingLocalValueImpl();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Incompatible value implementation version")
    @CS(value=CSValue.MAYBE)
    public NO_IMPLEMENT incompatibleValueImpl(@Chain Throwable var1);

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Unable to use any profile in IOR")
    public NO_IMPLEMENT noUsableProfile2();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Attempt to use DII on Local object")
    public NO_IMPLEMENT diiLocalObject();

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Biomolecular Sequence Analysis iterator cannot be reset")
    public NO_IMPLEMENT bioReset();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Biomolecular Sequence Analysis metadata is not available as XML")
    public NO_IMPLEMENT bioMetaNotAvailable();

    @Log(level=LogLevel.WARNING, id=7)
    @Message(value="Genomic Maps iterator cannot be reset")
    public NO_IMPLEMENT bioGenomicNoIterator();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The portable Java bindings do not support arguments()")
    public NO_RESOURCES piOperationNotSupported1();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The portable Java bindings do not support exceptions()")
    public NO_RESOURCES piOperationNotSupported2();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The portable Java bindings do not support contexts()")
    public NO_RESOURCES piOperationNotSupported3();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The portable Java bindings do not support operation_context()")
    public NO_RESOURCES piOperationNotSupported4();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The portable Java bindings do not support result()")
    public NO_RESOURCES piOperationNotSupported5();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The object ID was never set")
    public NO_RESOURCES piOperationNotSupported6();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="The ObjectKeyTemplate was never set")
    public NO_RESOURCES piOperationNotSupported7();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="ServerRequest::arguments() was never called")
    public NO_RESOURCES piOperationNotSupported8();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="No connection for request's priority")
    public NO_RESOURCES noConnectionPriority();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="An OTS/XA integration xa_ call returned XAER_RB")
    public TRANSACTION_ROLLEDBACK xaRb();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="An OTS/XA integration xa_ call returned XAER_NOTA")
    public TRANSACTION_ROLLEDBACK xaNota();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="OTS/XA integration end() was called with success set to TRUE while transaction rollback was deferred")
    public TRANSACTION_ROLLEDBACK xaEndTrueRollbackDeferred();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Request discarded because of resource exhaustion in POA or because POA is in DISCARDING state")
    public TRANSIENT poaRequestDiscard();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="No usable profile in IOR")
    public TRANSIENT noUsableProfile3();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Request cancelled")
    public TRANSIENT requestCancelled();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="POA destroyed")
    public TRANSIENT poaDestroyed();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Attempt to pass an unactivated (unregistered) value as an object reference")
    public OBJECT_NOT_EXIST unregisteredValueAsObjref();

    @Log(level=LogLevel.FINE, id=2)
    @Message(value="Failed to create or locate Object Adaptor")
    public OBJECT_NOT_EXIST noObjectAdaptor(@Chain Exception var1);

    @Log(level=LogLevel.FINE, id=2)
    @Message(value="Failed to create or locate Object Adaptor")
    public OBJECT_NOT_EXIST noObjectAdaptor();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Biomolecular Sequence Analysis Service is no longer available")
    public OBJECT_NOT_EXIST bioNotAvailable();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Object Adapter Inactive")
    public OBJECT_NOT_EXIST objectAdapterInactive();

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="System exception in POA::unknown_adapter for POA {0} with parent POA {1}")
    public OBJ_ADAPTER adapterActivatorException(@Chain Exception var1, String var2, ObjectAdapterId var3);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="System exception in POA::unknown_adapter for POA {0} with parent POA {1}")
    public OBJ_ADAPTER adapterActivatorException(String var1, ObjectAdapterId var2);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Incorrect servant type returned by servant manager ")
    public OBJ_ADAPTER badServantType();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="No default servant available [POA policy]")
    public OBJ_ADAPTER noDefaultServant();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="No servant manager available [POA Policy]")
    public OBJ_ADAPTER noServantManager();

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Violation of POA policy by ServantActivator::incarnate")
    public OBJ_ADAPTER badPolicyIncarnate();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Exception in PortableInterceptor::IORInterceptor.components_established")
    public OBJ_ADAPTER piExcCompEstablished();

    @Log(level=LogLevel.FINE, id=7)
    @Message(value="Null servant returned by servant manager")
    public OBJ_ADAPTER nullServantReturned();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="Unlisted user exception received by client ")
    @CS(value=CSValue.MAYBE)
    public UNKNOWN unknownUserException();

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="Unlisted user exception received by client ")
    @CS(value=CSValue.MAYBE)
    public UNKNOWN unknownUserException(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Non-standard System Exception not supported")
    public UNKNOWN unsupportedSystemException();

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="An unknown user exception received by a portable interceptor")
    public UNKNOWN piUnknownUserException();
}

