/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.logging;

import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.LogLevel;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.logex.WrapperGenerator;
import com.sun.corba.ee.spi.orbutil.logex.corba.CS;
import com.sun.corba.ee.spi.orbutil.logex.corba.CSValue;
import com.sun.corba.ee.spi.orbutil.logex.corba.CorbaExtension;
import com.sun.corba.ee.spi.orbutil.logex.corba.ORBException;
import java.io.IOException;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

@ExceptionWrapper(idPrefix="IOP")
@ORBException(omgException=false, group=6)
public interface UtilSystemException {
    public static final UtilSystemException self = (UtilSystemException)WrapperGenerator.makeWrapper(UtilSystemException.class, (WrapperGenerator.Extension)CorbaExtension.self);
    public static final String unableLocateValueHelper = "Could not locate value helper";

    @Log(level=LogLevel.FINE, id=1)
    @Message(value="StubFactory failed on makeStub call")
    public BAD_OPERATION stubFactoryCouldNotMakeStub(@Chain Throwable var1);

    @Log(level=LogLevel.FINE, id=2)
    @Message(value="Error in making stub given RepositoryId")
    public BAD_OPERATION errorInMakeStubFromRepositoryId(@Chain Throwable var1);

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Failure in making stub given RepositoryId")
    public BAD_OPERATION failureInMakeStubFromRepositoryId(@Chain Throwable var1);

    @Log(level=LogLevel.FINE, id=4)
    @Message(value="ClassCastException in loadStub")
    public BAD_OPERATION classCastExceptionInLoadStub(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Exception in loadStub")
    public BAD_OPERATION exceptionInLoadStub(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Unable to make stub from any of the repository IDs of the interface")
    public BAD_OPERATION couldNotMakeStubFromRepositoryId();

    @Log(level=LogLevel.WARNING, id=7)
    @Message(value="An IOException occurred while creating an IIOPOutputStream")
    public BAD_OPERATION exceptionInCreateIiopOutputStream(@Chain IOException var1);

    @Log(level=LogLevel.WARNING, id=8)
    @Message(value="An IOException occurred while creating an IIOPInputStream")
    public BAD_OPERATION exceptionInCreateIiopInputStream(@Chain IOException var1);

    @Log(level=LogLevel.WARNING, id=9)
    @Message(value="Only one call to the Util constructor is allowed; normally Util.getInstance should be called")
    public BAD_OPERATION onlyOneCallToConstructorAllowed();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Error in loadStubAndUpdateCache caused by _this_object")
    public BAD_PARAM noPoa(@Chain Exception var1);

    @Log(level=LogLevel.FINE, id=3)
    @Message(value="Tried to connect already connected Stub Delegate to a different ORB")
    public BAD_PARAM connectWrongOrb();

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Tried to connect unconnected Stub Delegate but no Tie was found")
    public BAD_PARAM connectNoTie();

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Tried to connect unconnected stub with Tie in a different ORB")
    public BAD_PARAM connectTieWrongOrb();

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Tried to connect unconnected stub to unconnected Tie")
    public BAD_PARAM connectTieNoServant();

    @Log(level=LogLevel.FINE, id=7)
    @Message(value="Failed to load Tie of class {0}")
    public BAD_PARAM loadTieFailed(@Chain Exception var1, String var2);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Bad hex digit in string_to_object")
    public DATA_CONVERSION badHexDigit();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Could not locate value helper")
    @CS(value=CSValue.MAYBE)
    public MARSHAL unableLocateValueHelper();

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Could not locate value helper")
    @CS(value=CSValue.MAYBE)
    public MARSHAL unableLocateValueHelper(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Invalid indirection {0}")
    public MARSHAL invalidIndirection(@Chain IOException var1, int var2);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="{0} did not originate from a connected object")
    public INV_OBJREF objectNotConnected(@Chain Exception var1, String var2);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Could not load stub for class {0}")
    public INV_OBJREF couldNotLoadStub(String var1);

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Class {0} not exported, or else is actually a JRMP stub")
    public INV_OBJREF objectNotExported(String var1);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Error in setting object field {0} in {1} to {2}")
    public INTERNAL errorSetObjectField(@Chain Exception var1, String var2, Object var3, Object var4);

    @Log(level=LogLevel.WARNING, id=2)
    @Message(value="Error in setting boolean field {0} in {1} to {2}")
    public INTERNAL errorSetBooleanField(@Chain Exception var1, String var2, Object var3, boolean var4);

    @Log(level=LogLevel.WARNING, id=3)
    @Message(value="Error in setting byte field {0} in {1} to {2}")
    public INTERNAL errorSetByteField(@Chain Exception var1, String var2, Object var3, byte var4);

    @Log(level=LogLevel.WARNING, id=4)
    @Message(value="Error in setting char field {0} in {1} to {2}")
    public INTERNAL errorSetCharField(@Chain Exception var1, String var2, Object var3, char var4);

    @Log(level=LogLevel.WARNING, id=5)
    @Message(value="Error in setting short field {0} in {1} to {2}")
    public INTERNAL errorSetShortField(@Chain Exception var1, String var2, Object var3, short var4);

    @Log(level=LogLevel.WARNING, id=6)
    @Message(value="Error in setting int field {0} in {1} to {2}")
    public INTERNAL errorSetIntField(@Chain Exception var1, String var2, Object var3, int var4);

    @Log(level=LogLevel.WARNING, id=7)
    @Message(value="Error in setting long field {0} in {1} to {2}")
    public INTERNAL errorSetLongField(@Chain Exception var1, String var2, Object var3, long var4);

    @Log(level=LogLevel.WARNING, id=8)
    @Message(value="Error in setting float field {0} in {1} to {2}")
    public INTERNAL errorSetFloatField(@Chain Exception var1, String var2, Object var3, float var4);

    @Log(level=LogLevel.WARNING, id=9)
    @Message(value="Error in setting double field {0} in {1} to {2}")
    public INTERNAL errorSetDoubleField(@Chain Exception var1, String var2, Object var3, double var4);

    @Log(level=LogLevel.WARNING, id=10)
    @Message(value="IllegalAccessException while trying to write to field {0}")
    public INTERNAL illegalFieldAccess(String var1);

    @Log(level=LogLevel.WARNING, id=11)
    @Message(value="State should be saved and reset first")
    public INTERNAL badBeginUnmarshalCustomValue();

    @Log(level=LogLevel.WARNING, id=12)
    @Message(value="Failure while loading specific Java remote exception class: {0}")
    public INTERNAL classNotFound(String var1);

    @Log(level=LogLevel.WARNING, id=13)
    @Message(value="Could not find the expected Value Handler implementation in the JDK: Wrong JDK Version?")
    public INTERNAL couldNotFindJdkValueHandler(@Chain Exception var1);

    @Log(level=LogLevel.FINE, id=14)
    @Message(value=" Bad Operation or Bad Invocation Order : The Servant has not been associated with an ORB instance")
    public INTERNAL handleSystemException(@Chain SystemException var1);

    @Log(level=LogLevel.INFO, id=15)
    @Message(value="This is a test exception with number {0}")
    public INTERNAL testException(int var1);

    @Log(level=LogLevel.WARNING, id=16)
    @Message(value="This is another test exception with no parameters")
    @CS(value=CSValue.MAYBE)
    public INTERNAL simpleTestException(@Chain Exception var1);

    @Log(level=LogLevel.WARNING, id=1)
    @Message(value="Unknown System Exception")
    public UNKNOWN unknownSysex();
}

