/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class VersionedHashSet<E>
extends HashSet<E> {
    private long version = 0L;

    public synchronized long version() {
        return this.version;
    }

    public VersionedHashSet() {
    }

    public VersionedHashSet(Collection<? extends E> c) {
        super(c);
    }

    public VersionedHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public VersionedHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public synchronized boolean add(E e) {
        boolean result = super.add(e);
        if (result) {
            ++this.version;
        }
        return result;
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result) {
            ++this.version;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator state = super.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return state.hasNext();
            }

            @Override
            public E next() {
                return state.next();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                VersionedHashSet versionedHashSet = VersionedHashSet.this;
                synchronized (versionedHashSet) {
                    state.remove();
                    VersionedHashSet.this.version++;
                }
            }
        };
    }
}

