/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.interceptors.CallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;

class CallbackChainImpl {
    protected BaseContainer container;
    protected CallbackInterceptor[] interceptors;
    protected int size;

    CallbackChainImpl(BaseContainer container, CallbackInterceptor[] interceptors) {
        this.container = container;
        this.interceptors = interceptors;
        this.size = interceptors == null ? 0 : interceptors.length;
    }

    public Object invokeNext(int index, CallbackInvocationContext invContext) throws Throwable {
        Object result = null;
        if (index < this.size) {
            result = this.interceptors[index].intercept(invContext);
        }
        return result;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder("CallbackInterceptorChainImpl");
        for (CallbackInterceptor inter : this.interceptors) {
            bldr.append("\n\t\t").append(inter);
        }
        return bldr.toString();
    }

    public void prependInterceptor(CallbackInterceptor interceptor) {
        ++this.size;
        CallbackInterceptor[] newArray = new CallbackInterceptor[this.size];
        newArray[0] = interceptor;
        for (int i = 1; i < this.size; ++i) {
            newArray[i] = this.interceptors[i - 1];
        }
        this.interceptors = newArray;
    }
}

