/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.factory;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public final class EJBSecurityManagerFactory
extends SecurityManagerFactory {
    private static Logger _logger = null;
    @Inject
    InvocationManager invMgr;
    private Map<String, ArrayList<String>> CONTEXT_IDS = new HashMap<String, ArrayList<String>>();
    private Map<String, Map<String, EJBSecurityManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, EJBSecurityManager>>();

    public <T> EJBSecurityManager getManager(String ctxId, String name, boolean remove) {
        return (EJBSecurityManager)((Object)this.getManager(this.SECURITY_MANAGERS, ctxId, name, remove));
    }

    public <T> ArrayList<EJBSecurityManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> ArrayList<EJBSecurityManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public <T> void addManagerToApp(String ctxId, String name, String appName, EJBSecurityManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, ctxId, name, appName, (Object)manager);
    }

    public EJBSecurityManager createManager(EjbDescriptor ejbDesc, boolean register) {
        String ctxId = EJBSecurityManager.getContextID(ejbDesc);
        String ejbName = ejbDesc.getName();
        EJBSecurityManager manager = null;
        if (register) {
            manager = this.getManager(ctxId, ejbName, false);
        }
        if (manager == null || !register) {
            try {
                manager = new EJBSecurityManager(ejbDesc, this.invMgr, this);
                if (register) {
                    String appName = ejbDesc.getApplication().getRegistrationName();
                    this.addManagerToApp(ctxId, ejbName, appName, manager);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "[EJB-Security] FATAL Exception. Unable to create EJBSecurityManager: " + ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
        return manager;
    }

    static {
        _logger = LogDomains.getLogger(EJBSecurityManagerFactory.class, (String)"javax.enterprise.system.core.security");
    }
}

