/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.TimeStatistic;
import org.glassfish.api.statistics.impl.CountStatisticImpl;
import org.glassfish.api.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;

@ManagedObject
@Description(value="Ejb Security Deployment statistics")
public class EjbSecurityStatsProvider {
    TimeStatisticImpl deploymentTime = null;
    CountStatisticImpl ejbSMCount = null;
    CountStatisticImpl ejbPCCount = null;

    @ManagedAttribute(id="DepolymentTime")
    public TimeStatistic getDeploymentTime() {
        this.deploymentTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "deploymentTime", "milliseconds", "Deployment Time", 0L, 0L);
        return this.deploymentTime.getStatistic();
    }

    @ManagedAttribute(id="SecurityManagerCount")
    public CountStatistic getSecurityManagerCount() {
        this.ejbSMCount = new CountStatisticImpl("SecurityManagerCount", "count", "Count of EJB Security managers");
        return this.ejbSMCount.getStatistic();
    }

    @ManagedAttribute(id="PolicyConfigurationCount")
    public CountStatistic getPolicyConfigurationCount() {
        this.ejbPCCount = new CountStatisticImpl("PolicyConfigurationCount", "count", "Count of Policy Configuration");
        return this.ejbPCCount.getStatistic();
    }

    @ProbeListener(value="ejb-security:ejb-container:ejb:ejbSecDeploymentStartedEvent")
    public void ejbSecDeploymentStartedEvent(@ProbeParam(value="appName") String appName) {
        this.deploymentTime.setStartTime(System.currentTimeMillis());
        this.ejbSMCount.increment();
    }

    @ProbeListener(value="ejb-security:ejb-container:ejb:ejbSecDeploymentEndedEvent")
    public void ejbSecDeploymentEndedEvent(@ProbeParam(value="appName") String appName) {
        this.ejbSMCount.decrement();
    }

    @ProbeListener(value="ejb-security:ejb-container:ejb:ejbPCCreationStartEvent")
    public void ejbPCCreationStartEvent(@ProbeParam(value="contextId") String contextId) {
        this.ejbPCCount.increment();
    }

    @ProbeListener(value="ejb-security:ejb-container:ejb:ejbPCDestructionStartEvent")
    public void ejbPCDestructionStartEvent(@ProbeParam(value="contextId") String contextId) {
        this.ejbPCCount.decrement();
    }
}

