/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.util.Utility;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.ORB;

@Service
public class EjbNamingReferenceManagerImpl
implements EjbNamingReferenceManager {
    private static final String CORBANAME = "corbaname:";
    private static final String IIOPURL = "iiop://";
    @Inject
    InvocationManager invMgr;
    @Inject
    Habitat habitat;
    private volatile EjbContainerUtil ejbContainerUtil;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object resolveEjbReference(EjbReferenceDescriptor ejbRefDesc, Context context) throws NamingException {
        Object jndiObj = null;
        if (ejbRefDesc.isLocal()) return EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
        String remoteJndiName = EJBUtils.getRemoteEjbJndiName(ejbRefDesc);
        ClassLoader origClassLoader = Utility.getClassLoader();
        boolean setCL = false;
        try {
            try {
                try {
                    String refInterface = ejbRefDesc.isEJB30ClientView() ? ejbRefDesc.getEjbInterface() : ejbRefDesc.getHomeClassName();
                    origClassLoader.loadClass(refInterface);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader referringBundleClassLoader = ejbRefDesc.getReferringBundleDescriptor().getClassLoader();
                    Utility.setContextClassLoader((ClassLoader)referringBundleClassLoader);
                    setCL = true;
                }
                if (remoteJndiName.startsWith(CORBANAME)) {
                    GlassFishORBHelper orbHelper = (GlassFishORBHelper)this.habitat.getComponent(GlassFishORBHelper.class);
                    ORB orb = orbHelper.getORB();
                    jndiObj = orb.string_to_object(remoteJndiName);
                }
                jndiObj = context.lookup(remoteJndiName);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Exception resolving Ejb for '" + ejbRefDesc + "' .  Actual (possibly internal) Remote JNDI name used for lookup is '" + remoteJndiName + "'");
                ne.initCause(e);
                throw ne;
            }
            Object var10_12 = null;
            if (!setCL) return EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!setCL) throw throwable;
            Utility.setContextClassLoader((ClassLoader)origClassLoader);
            throw throwable;
        }
        Utility.setContextClassLoader((ClassLoader)origClassLoader);
        return EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
    }

    public boolean isEjbReferenceCacheable(EjbReferenceDescriptor ejbRefDesc) {
        return false;
    }

    public Object getEJBContextObject(String contextType) {
        ComponentInvocation currentInv = this.invMgr.getCurrentInvocation();
        if (currentInv == null) {
            throw new IllegalStateException("no current invocation");
        }
        if (currentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            throw new IllegalStateException("Illegal invocation type for EJB Context : " + currentInv.getInvocationType());
        }
        EjbInvocation ejbInv = (EjbInvocation)currentInv;
        Object returnObject = ejbInv.context;
        if (contextType.equals("javax.ejb.TimerService")) {
            if (this.ejbContainerUtil == null) {
                this.ejbContainerUtil = (EjbContainerUtil)this.habitat.getByContract(EjbContainerUtil.class);
            }
            if (this.ejbContainerUtil == null) {
                throw new IllegalStateException("EJB Timer Service not available. And EjbContainerUtil is null");
            }
            if (this.ejbContainerUtil.getEJBTimerService() == null) {
                throw new IllegalStateException("EJB Timer Service not available");
            }
            returnObject = new EJBTimerServiceWrapper(this.ejbContainerUtil.getEJBTimerService(), (EJBContextImpl)ejbInv.context);
        }
        return returnObject;
    }
}

