/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="Ejb Security Deployment statistics")
public class EjbSecurityStatsProvider {
    TimeStatisticImpl deploymentTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "deploymentTime", "milliseconds", "Deployment Time", 0L, 0L);
    CountStatisticImpl ejbSMCount = new CountStatisticImpl("SecurityManagerCount", "count", "Count of EJB Security managers");
    CountStatisticImpl ejbPCCount = new CountStatisticImpl("PolicyConfigurationCount", "count", "Count of Policy Configuration");

    @ManagedAttribute(id="DepolymentTime")
    public TimeStatistic getDeploymentTime() {
        return this.deploymentTime.getStatistic();
    }

    @ManagedAttribute(id="SecurityManagerCount")
    public CountStatistic getSecurityManagerCount() {
        return this.ejbSMCount.getStatistic();
    }

    @ManagedAttribute(id="PolicyConfigurationCount")
    public CountStatistic getPolicyConfigurationCount() {
        return this.ejbPCCount.getStatistic();
    }

    @ProbeListener(value="glassfish:ejb-container:ejb:ejbSecDeploymentStartedEvent")
    public void ejbSecDeploymentStartedEvent(@ProbeParam(value="appName") String appName) {
        this.deploymentTime.setStartTime(System.currentTimeMillis());
        this.ejbSMCount.increment();
    }

    @ProbeListener(value="glassfish:ejb-container:ejb:ejbSecDeploymentEndedEvent")
    public void ejbSecDeploymentEndedEvent(@ProbeParam(value="appName") String appName) {
        this.ejbSMCount.decrement();
    }

    @ProbeListener(value="glassfish:ejb-container:ejb:ejbPCCreationStartEvent")
    public void ejbPCCreationStartEvent(@ProbeParam(value="contextId") String contextId) {
        this.ejbPCCount.increment();
    }

    @ProbeListener(value="glassfish:ejb-container:ejb:ejbPCDestructionStartEvent")
    public void ejbPCDestructionStartEvent(@ProbeParam(value="contextId") String contextId) {
        this.ejbPCCount.decrement();
    }
}

