/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.codegen.StaticRmiStubGenerator;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.ejb.spi.CMPService;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication> {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected Habitat habitat;
    @Inject
    protected PolicyLoader policyLoader;
    @Inject
    protected EJBSecurityManagerFactory ejbSecManagerFactory;
    @Inject
    private ComponentEnvManager compEnvManager;
    private static final String APP_UNIQUE_ID_PROP = "org.glassfish.ejb.container.application_unique_id";
    private AtomicLong uniqueIdCounter = new AtomicLong(System.currentTimeMillis());
    private static final Logger _logger = LogDomains.getLogger(EjbDeployer.class, (String)"javax.enterprise.system.container.ejb");

    protected String getModuleType() {
        return "ejb";
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        long uniqueAppId;
        super.load((Container)containerStarter, dc);
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null) {
            throw new RuntimeException("Null EjbBundleDescriptor " + dc.getSourceDir() + " in EjbDeployer.load()");
        }
        Properties appProps = dc.getAppProps();
        if (!appProps.containsKey(APP_UNIQUE_ID_PROP)) {
            uniqueAppId = this.getNextEjbAppUniqueId();
            appProps.setProperty(APP_UNIQUE_ID_PROP, uniqueAppId + "");
        } else {
            uniqueAppId = Long.parseLong(appProps.getProperty(APP_UNIQUE_ID_PROP));
        }
        Application app = ejbBundle.getApplication();
        if (!app.isUniqueIdSet()) {
            app.setUniqueId(uniqueAppId);
        }
        if (ejbBundle.containsCMPEntity()) {
            CMPService cmpService = (CMPService)this.habitat.getByContract(CMPService.class);
            if (cmpService == null) {
                throw new RuntimeException("CMP Module is not available");
            }
            if (!cmpService.isReady()) {
                throw new RuntimeException("CMP Module is not initialized");
            }
        }
        EjbApplication ejbApp = new EjbApplication(ejbBundle, dc, dc.getClassLoader(), this.habitat, this.ejbSecManagerFactory);
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)ejbBundle);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering ejb bundle level resources", e);
        }
        ejbApp.loadContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        EjbBundleDescriptor ejbBundle = ejbApplication.getEjbBundleDescriptor();
        try {
            this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)ejbBundle);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error unbinding ejb bundle " + ejbBundle.getModuleName() + " dependency namespace", e);
        }
    }

    public void clean(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin == OpsParams.Origin.undeploy) {
            String[] contextIds;
            CMPDeployer cmpDeployer = (CMPDeployer)this.habitat.getByContract(CMPDeployer.class);
            if (cmpDeployer != null) {
                cmpDeployer.clean(dc);
            }
            String appName = params.name();
            for (String contextId : contextIds = this.ejbSecManagerFactory.getContextsForApp(appName, false)) {
                try {
                    SecurityUtil.removePolicy((String)contextId);
                }
                catch (IASSecurityException ex) {
                    _logger.log(Level.WARNING, "Error removing the policy file for application " + appName + " " + (Object)((Object)ex));
                }
            }
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.deploy) {
            return;
        }
        RegisteredComponentInvocationHandler handler = (RegisteredComponentInvocationHandler)this.habitat.getComponent(RegisteredComponentInvocationHandler.class, "ejbSecurityCIH");
        handler.register();
        EjbBundleDescriptor bundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        this.policyLoader.loadPolicy();
        if (bundle != null) {
            for (EjbDescriptor desc : bundle.getEjbs()) {
                this.ejbSecManagerFactory.createManager(desc, false);
            }
        }
        DeployCommandParameters dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        boolean generateRmicStubs = dcp.generatermistubs;
        if (generateRmicStubs) {
            StaticRmiStubGenerator staticStubGenerator = new StaticRmiStubGenerator();
            try {
                staticStubGenerator.ejbc(this.habitat, dc);
            }
            catch (Exception e) {
                throw new DeploymentException("Static RMI-IIOP Stub Generation exception for " + dc.getSourceDir(), (Throwable)e);
            }
        }
        if (bundle == null || !bundle.containsCMPEntity()) {
            return;
        }
        CMPDeployer cmpDeployer = (CMPDeployer)this.habitat.getByContract(CMPDeployer.class);
        if (cmpDeployer == null) {
            throw new DeploymentException("No CMP Deployer is available to deploy this module");
        }
        cmpDeployer.deploy(dc);
    }

    private long getNextEjbAppUniqueId() {
        long next = this.uniqueIdCounter.incrementAndGet();
        return next << 16;
    }
}

