/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.builder;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.util.CheckpointPolicyImpl;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.builder.BaseContainerBuilder;
import com.sun.ejb.containers.builder.CachePassivatorTask;
import com.sun.ejb.containers.builder.ExpiredSessionsRemovalTask;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.ejb.spi.container.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.initialization.PersistenceStrategyBuilder;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class StatefulContainerBuilder
extends BaseContainerBuilder {
    private static final Level TRACE_LEVEL = Level.FINE;
    private StatefulSessionContainer sfsbContainer;
    private SFSBContainerInitialization containerInitialization;
    @Inject
    private Habitat habitat;
    @Inject
    private CacheProperties cacheProps;
    @Inject
    private EJBServerConfigLookup ejbConfigLookup;
    private LruSessionCache sessionCache;
    private SFSBStoreManager sfsbStoreManager;
    private boolean HAEnabled = false;

    public BaseContainer createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader) throws Exception {
        this.cacheProps.init(ejbDescriptor);
        this.ejbConfigLookup.initWithEjbDescriptor(ejbDescriptor);
        this.sfsbContainer = new StatefulSessionContainer(ejbDescriptor, loader);
        this.containerInitialization = this.sfsbContainer;
        return this.sfsbContainer;
    }

    public void buildComponents() throws Exception {
        this.HAEnabled = this.ejbConfigLookup.calculateEjbAvailabilityEnabledFromConfig();
        this.buildCheckpointPolicy(this.HAEnabled);
        this.buildSFSBUUIDUtil();
        this.buildStoreManager();
        this.buildCache();
        this.scheduleTimerTasks(this.sfsbContainer);
    }

    private final void buildCheckpointPolicy(boolean haEnabled) {
        this.containerInitialization.setCheckpointPolicy(new CheckpointPolicyImpl(haEnabled));
    }

    private void buildSFSBUUIDUtil() {
        this.containerInitialization.setSFSBUUIDUtil(this.HAEnabled ? new ScrambledKeyGenerator(this.getIPAddress(), this.getPort()) : new SimpleKeyGenerator(this.getIPAddress(), this.getPort()));
    }

    private void buildStoreManager() {
        String persistenceStoreType = this.ejbConfigLookup.getPersistenceStoreType();
        PersistenceStrategyBuilder storeBuilder = (PersistenceStrategyBuilder)this.habitat.getComponent(PersistenceStrategyBuilder.class, persistenceStoreType);
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "++SFSBBuilder:: HAEnabled: " + this.HAEnabled + "; specifiedStoreType: " + persistenceStoreType + "; builder: " + storeBuilder);
        }
        storeBuilder.initializePersistenceStrategy(this.containerInitialization, this.ejbDescriptor);
        this.sfsbStoreManager = this.containerInitialization.getSFSBStoreManager();
    }

    private void buildCache() {
        String cacheName = this.ejbDescriptor.getEjbClassName();
        String victimPolicy = this.cacheProps.getVictimSelectionPolicy();
        this.sessionCache = this.cacheProps.getMaxCacheSize() <= 0 ? new UnBoundedSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("lru".equalsIgnoreCase(victimPolicy) ? new LruSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("fifo".equalsIgnoreCase(victimPolicy) ? new FIFOSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : new NRUSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds())));
        float ratio = (float)(1.0 * (double)this.cacheProps.getNumberOfVictimsToSelect() / (double)this.cacheProps.getMaxCacheSize());
        float loadFactor = (float)(1.0 - (double)ratio);
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        if (this.cacheProps.getMaxCacheSize() <= 0) {
            this.sessionCache.init(16384, loadFactor, null);
        } else {
            this.sessionCache.init(this.cacheProps.getMaxCacheSize(), loadFactor, null);
        }
        this.sessionCache.addCacheListener(this.sfsbContainer);
        this.sessionCache.setSessionStore(this.sfsbStoreManager);
        this.sfsbContainer.setSessionCache(this.sessionCache);
        if (this.cacheProps.getNumberOfVictimsToSelect() > 8) {
            this.sfsbContainer.setPassivationBatchCount(this.cacheProps.getNumberOfVictimsToSelect());
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "Created cache [for " + this.ejbDescriptor.getName() + "] " + this.cacheProps + "; loadFactor: " + loadFactor + "; storeManager: " + this.sfsbStoreManager);
        }
    }

    private void scheduleTimerTasks(StatefulSessionContainer container) {
        long timeout;
        String ejbName = this.ejbDescriptor.getEjbClassName();
        if (this.cacheProps.getCacheIdleTimeoutInSeconds() > 0) {
            timeout = this.cacheProps.getCacheIdleTimeoutInSeconds() * 1000;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new CachePassivatorTask(ejbName, this.sessionCache, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added CachePassivator for: " + ejbName + ". To run after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_idle_passivatortask_failed", th);
            }
        }
        if (this.cacheProps.getRemovalTimeoutInSeconds() > 0) {
            timeout = this.cacheProps.getRemovalTimeoutInSeconds() * 1000;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new ExpiredSessionsRemovalTask(ejbName, this.sfsbContainer, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added StorePassivator for: " + ejbName + ". To run after " + "after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_remove_passivatortask_failed", th);
            }
        }
    }
}

