/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="entity-bean-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Entity Bean Statistics")
public class EntityBeanStatsProvider {
    private BoundedRangeStatisticImpl pooledCount = null;
    private BoundedRangeStatisticImpl readyCount = null;
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    private String appName = null;
    private String moduleName = null;
    private String beanName = null;
    private boolean registered = false;
    private EntityContainer delegate;

    public EntityBeanStatsProvider(EntityContainer delegate, String appName, String moduleName, String beanName) {
        this.delegate = delegate;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        long now = System.currentTimeMillis();
        this.pooledCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxPoolSize(), (long)delegate.getSteadyPoolSize(), "PooledCount", "count", "Number of entity beans in pooled state", now, now);
        this.readyCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxCacheSize(), 0L, "ReadyCount", "count", "Number of entity beans in ready state", now, now);
    }

    public void register() {
        String node = EjbMonitoringUtils.registerSubComponent(this.appName, this.moduleName, this.beanName, "entity-beans", this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ManagedAttribute(id="pooledcount")
    @Description(value="Number of entity beans in pooled state")
    public RangeStatistic getPooledCount() {
        return EjbMonitoringUtils.getRangeStatisticForCurrentValue(this.pooledCount, this.delegate.getPooledCount());
    }

    @ManagedAttribute(id="readycount")
    @Description(value="Number of entity beans in ready state")
    public RangeStatistic getReadyCount() {
        return EjbMonitoringUtils.getRangeStatisticForCurrentValue(this.readyCount, this.delegate.getReadyCount());
    }
}

