/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.ModuleExploder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerImpl
extends EJBContainer {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private final Server server;
    private final EmbeddedEjbContainer ejbContainer;
    private final EmbeddedDeployer deployer;
    private String deployedAppName;
    private boolean open = true;

    EJBContainerImpl(Server server, EmbeddedEjbContainer ejbContainer, EmbeddedDeployer deployer) {
        this.server = server;
        this.ejbContainer = ejbContainer;
        this.deployer = deployer;
    }

    void deploy(Map<?, ?> properties, Set<File> modules) throws EJBException {
        File app = null;
        try {
            app = this.getOrCreateApplication(modules);
            _logger.info("==> Deploying app: " + app);
            DeployCommandParameters dp = new DeployCommandParameters(app);
            if (properties != null) {
                dp.name = (String)properties.get("javax.ejb.embeddable.appName");
            }
            if (dp.name == null) {
                dp.name = app.getName();
            }
            this.deployedAppName = this.deployer.deploy(app, dp);
        }
        catch (IOException e) {
            throw new EJBException("Failed to deploy EJB modules", (Exception)e);
        }
        if (this.deployedAppName == null) {
            throw new EJBException("Failed to deploy EJB modules - see log for details");
        }
    }

    public Context getContext() {
        _logger.info("IN getContext()");
        try {
            return new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.cannot_create_context"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        _logger.info("IN close()");
        if (this.deployedAppName != null) {
            try {
                this.deployer.undeploy(this.deployedAppName, null);
            }
            catch (Exception e) {
                _logger.warning("Cannot undeploy deployed modules: " + e.getMessage());
            }
        }
        try {
            try {
                this.server.stop();
            }
            catch (LifecycleException e) {
                _logger.warning("Cannot stop embedded container " + e.getMessage());
                Object var3_4 = null;
                this.open = false;
            }
            Object var3_3 = null;
            this.open = false;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.open = false;
            throw throwable;
        }
    }

    boolean isOpen() {
        return this.open;
    }

    private File getOrCreateApplication(Set<File> modules) throws EJBException, IOException {
        File result = null;
        if (modules == null || modules.size() == 0) {
            _logger.info("==> No modules found");
        } else if (modules.size() == 1) {
            result = modules.iterator().next();
        } else {
            result = File.createTempFile("ejb-app", "");
            if (!result.delete() || !result.mkdirs()) {
                throw new EJBException("Not able to create temp dir " + result.getAbsolutePath());
            }
            _logger.info("==> temp dir created at " + result.getAbsolutePath());
            for (File f : modules) {
                File out;
                int lastpart;
                String filename = f.toURI().getSchemeSpecificPart();
                if (filename.endsWith(File.separator) || filename.endsWith("/")) {
                    int length = filename.length();
                    filename = filename.substring(0, length - 1);
                }
                if ((lastpart = filename.lastIndexOf(File.separatorChar)) == -1) {
                    lastpart = filename.lastIndexOf(47);
                }
                String name = filename.substring(lastpart + 1);
                _logger.info("==> Converted file name: " + filename + " to " + name);
                if (f.isDirectory()) {
                    out = new File(result, name + "_jar");
                    _logger.info("==> Copying directory to: " + out);
                    FileUtils.copy((File)f, (File)out);
                    continue;
                }
                out = new File(result, FileUtils.makeFriendlyFilename((String)name));
                _logger.info("==> Exploding jar to: " + out);
                ModuleExploder.explodeJar((File)f, (File)out);
            }
        }
        return result;
    }
}

