/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.ejb.embedded.DomainXmlTransformer;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.ejb.embedded.EjbBuilder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final String GF_INSTALLATION_ROOT = "org.glassfish.ejb.embedded.glassfish.installation.root";
    private static final String GF_INSTANCE_ROOT = "org.glassfish.ejb.embedded.glassfish.instance.root";
    private static final String GF_DOMAIN_FILE = "org.glassfish.ejb.embedded.glassfish.configuration.file";
    private static final String JAR_FILE_EXT = ".jar";
    private static final Attributes.Name ATTRIBUTE_NAME_SKIP = new Attributes.Name("Bundle-SymbolicName");
    private static final String[] ATTRIBUTE_VALUES_SKIP = new String[]{"org.glassfish.", "com.sun.enterprise.", "org.eclipse."};
    private static final String[] ATTRIBUTE_VALUES_OK = new String[]{"sample", "test"};
    private static final Logger _logger = LogDomains.getLogger(EJBContainerProviderImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static Server server;
    private static Habitat habitat;
    private static ArchiveFactory archiveFactory;
    private static Class[] ejbAnnotations;

    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("javax.ejb.embeddable.provider") == null || properties.get("javax.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            if (container != null && container.isOpen()) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_exists_container"));
            }
            this.init(properties);
            try {
                Set<File> modules = this.addEJBModules(properties);
                if (modules.isEmpty()) {
                    _logger.log(Level.SEVERE, "ejb.embedded.no_modules_found");
                } else {
                    container.deploy(properties, modules);
                }
                return container;
            }
            catch (Throwable t) {
                if (container != null) {
                    try {
                        _logger.info("==> Cleaning up on failure ...");
                        container.close();
                    }
                    catch (Throwable t1) {
                        _logger.info("==> Error cleaning up..." + t1);
                    }
                }
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Map<?, ?> properties) throws EJBException {
        Object object = lock;
        synchronized (object) {
            Server.Builder builder = new Server.Builder("GFEJBContainerProviderImpl");
            Result rs = this.getLocations(properties);
            if (rs == null) {
                server = builder.build();
            } else {
                EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
                efsb.configurationFile(rs.domain_file);
                efsb.installRoot(rs.installed_root, true);
                efsb.instanceRoot(rs.instance_root);
                builder.embeddedFileSystem(efsb.build());
                server = builder.build();
            }
            EjbBuilder ejb = (EjbBuilder)server.createConfig(EjbBuilder.class);
            habitat = ejb.habitat;
            archiveFactory = (ArchiveFactory)habitat.getComponent(ArchiveFactory.class);
            EmbeddedEjbContainer ejbContainer = (EmbeddedEjbContainer)server.addContainer((ContainerBuilder)ejb);
            server.addContainer(ContainerBuilder.Type.jpa);
            try {
                server.start();
            }
            catch (LifecycleException e) {
                throw new EJBException((Exception)((Object)e));
            }
            EmbeddedDeployer deployer = server.getDeployer();
            Sniffer sniffer = (Sniffer)habitat.getComponent(Sniffer.class, "Ejb");
            ejbAnnotations = sniffer.getAnnotationTypes();
            container = new EJBContainerImpl(server, ejbContainer, deployer);
        }
    }

    private Set<File> addEJBModules(Map<?, ?> properties) {
        HashSet<File> modules = new HashSet<File>();
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        HashSet<String> moduleNames = new HashSet<String>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof String) {
                moduleNames.add(obj);
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    moduleNames.add((String)s);
                }
            } else if (obj instanceof File) {
                this.addEJBModule(modules, moduleNames, obj);
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    this.addEJBModule(modules, moduleNames, (File)f);
                }
            }
        }
        if (modules.isEmpty()) {
            String[] entries;
            String path = System.getProperty("java.class.path");
            _logger.info("==> Looking for EJB modules in classpath: " + path);
            for (String s0 : entries = path.split(File.pathSeparator)) {
                this.addEJBModule(modules, moduleNames, new File(s0));
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRequestedEJBModule(File file, Set<String> moduleNames) throws Exception {
        boolean bl;
        InputStream is;
        block8: {
            String fileName = file.getName();
            _logger.info("... Testing ... " + fileName);
            ReadableArchive archive = null;
            is = null;
            try {
                boolean handles = false;
                String moduleName = DeploymentUtils.getDefaultEEName((String)fileName);
                archive = archiveFactory.openArchive(file);
                is = archive.getEntry("META-INF/ejb-jar.xml");
                if (is != null) {
                    handles = true;
                    EjbDeploymentDescriptorFile eddf = new EjbDeploymentDescriptorFile();
                    eddf.setXMLValidation(false);
                    EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)eddf.read(is);
                    ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
                    moduleDesc.setArchiveUri(fileName);
                    moduleName = moduleDesc.getModuleName();
                } else {
                    GenericAnnotationDetector detector = new GenericAnnotationDetector(ejbAnnotations);
                    handles = detector.hasAnnotationInArchive(archive);
                }
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info("... is EJB module: " + handles);
                    if (handles) {
                        _logger.info("... is Requested EJB module [" + moduleName + "]: " + (moduleNames.isEmpty() || moduleNames.contains(moduleName)));
                    }
                }
                bl = handles && (moduleNames.isEmpty() || moduleNames.contains(moduleName));
                Object var12_12 = null;
                if (archive == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var12_13 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    if (is == null) break block9;
                    is.close();
                }
                throw throwable;
            }
            archive.close();
        }
        if (is != null) {
            is.close();
        }
        return bl;
    }

    private void addEJBModule(Set<File> modules, Set<String> moduleNames, File f) {
        try {
            if (f.exists() && this.isRequestedEJBModule(f, moduleNames) && !this.skipJar(f)) {
                modules.add(f);
                _logger.info("... Added EJB Module .... " + f.getName());
            }
        }
        catch (Exception ioe) {
            _logger.log(Level.INFO, "ejb.embedded.io_exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean skipJar(File file) throws Exception {
        if (!file.isFile()) {
            return false;
        }
        jf = null;
        try {
            jf = new JarFile(file);
            m = jf.getManifest();
            if (m != null && (value = (attributes = m.getMainAttributes()).getValue(EJBContainerProviderImpl.ATTRIBUTE_NAME_SKIP)) != null) {
                for (String skipValue : EJBContainerProviderImpl.ATTRIBUTE_VALUES_SKIP) {
                    if (!value.startsWith(skipValue)) continue;
                    for (String okValue : EJBContainerProviderImpl.ATTRIBUTE_VALUES_OK) {
                        if (value.indexOf(okValue) <= 0) continue;
                        var14_15 = false;
                        var16_16 = null;
                        if (jf == null) return var14_15;
                        try {
                            jf.close();
                            return var14_15;
                        }
                        catch (IOException ex) {
                            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                        }
                        return var14_15;
                    }
                    var10_11 = true;
                    var16_17 = null;
                    if (jf == null) return var10_11;
                    ** try [egrp 1[TRYBLOCK] [4 : 174->181)] { 
lbl27:
                    // 1 sources

                    jf.close();
                    return var10_11;
lbl29:
                    // 1 sources

                    catch (IOException ex) {
                        EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                    }
                    return var10_11;
                }
            }
        }
        catch (Throwable var15_24) {
            var16_19 = null;
            if (jf == null) throw var15_24;
            ** try [egrp 1[TRYBLOCK] [4 : 174->181)] { 
lbl38:
            // 1 sources

            jf.close();
            throw var15_24;
lbl40:
            // 1 sources

            catch (IOException ex) {
                EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            }
            throw var15_24;
        }
        var16_18 = null;
        if (jf == null) return false;
        try {}
        catch (IOException ex) {
            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            return false;
        }
        jf.close();
        return false;
    }

    private File getValidFile(String location) {
        File f = new File(location);
        if (!f.exists()) {
            _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", location);
            f = null;
        }
        return f;
    }

    private Result getLocations(Map<?, ?> properties) {
        File installed_root;
        Result rs = null;
        String installed_root_location = null;
        String instance_root_location = null;
        String domain_file_location = null;
        if (properties != null) {
            installed_root_location = (String)properties.get(GF_INSTALLATION_ROOT);
            instance_root_location = (String)properties.get(GF_INSTANCE_ROOT);
            domain_file_location = (String)properties.get(GF_DOMAIN_FILE);
        }
        if (installed_root_location == null) {
            try {
                installed_root_location = Which.jarFile(this.getClass()).getParentFile().getParentFile().getAbsolutePath();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "ejb.embedded.cannot_determine_installation_location");
                _logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        _logger.info("+++ installed_root_location : " + installed_root_location);
        if (installed_root_location != null && (installed_root = this.getValidFile(installed_root_location)) != null) {
            if (instance_root_location == null) {
                instance_root_location = installed_root_location + File.separatorChar + "domains" + File.separatorChar + "domain1";
            }
            _logger.info("+++ instance_root_location: " + instance_root_location);
            File instance_root = this.getValidFile(instance_root_location);
            if (instance_root != null) {
                if (domain_file_location == null) {
                    domain_file_location = instance_root_location + File.separatorChar + "config" + File.separatorChar + "domain.xml";
                }
                _logger.info("+++ domain_file_location : " + domain_file_location);
                File domain_file = this.getValidFile(domain_file_location);
                if (domain_file != null) {
                    DomainXmlTransformer dxf = new DomainXmlTransformer(domain_file, _logger);
                    File temp_domain_file = dxf.transform();
                    if (temp_domain_file != null) {
                        domain_file = temp_domain_file;
                    } else {
                        _logger.log(Level.SEVERE, "ejb.embedded.failed_create_temporary_domain_xml_file");
                    }
                    rs = new Result(installed_root, instance_root, domain_file);
                }
            }
        }
        return rs;
    }

    static {
        ejbAnnotations = null;
    }

    private class Result {
        File installed_root;
        File instance_root;
        File domain_file;

        Result(File installed_root, File instance_root, File domain_file) {
            this.installed_root = installed_root;
            this.instance_root = instance_root;
            this.domain_file = domain_file;
        }
    }
}

