/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.store;

import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileStoreManager
implements SFSBStoreManager,
MonitorableSFSBStoreManager {
    protected static final Logger _logger = LogDomains.getLogger(FileStoreManager.class, (String)"javax.enterprise.system.container.ejb");
    protected String clusterId = "";
    protected long containerId;
    protected File baseDir;
    protected String storeName;
    protected int passivationTimeoutInSeconds;
    private int loadCount;
    private int loadSuccessCount;
    private int loadErrorCount;
    private int storeCount;
    private int storeSuccessCount;
    private int storeErrorCount;
    private int expiredSessionCount;
    private boolean shutdown;
    private Level TRACE_LEVEL = Level.FINE;
    private int gracePeriodInSeconds;

    public void checkpointSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        this.saveState(beanState, false);
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, this.storeName + "Checkpoint saved: " + beanState.getId());
        }
    }

    public SFSBBeanState createSFSBBeanState(Object sessionId, long lastAccess, boolean isNew, byte[] state) {
        return new SFSBBeanState(this.clusterId, this.containerId, sessionId, lastAccess, isNew, state, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SFSBBeanState getState(Object sessionKey) {
        SFSBBeanState beanState;
        block18: {
            block19: {
                FileInputStream fis;
                BufferedInputStream bis;
                String fileName;
                block15: {
                    int count;
                    File file;
                    fileName = sessionKey.toString();
                    beanState = null;
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        _logger.log(this.TRACE_LEVEL, this.storeName + "Attempting to load session: " + sessionKey);
                    }
                    if (!(file = new File(this.baseDir, fileName)).exists()) break block19;
                    int dataSize = (int)file.length();
                    byte[] data = new byte[dataSize];
                    bis = null;
                    fis = null;
                    ++this.loadCount;
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    int offset = 0;
                    for (int toRead = dataSize; toRead > 0; toRead -= count) {
                        count = bis.read(data, offset, toRead);
                        offset += count;
                    }
                    beanState = new SFSBBeanState("", -1L, sessionKey, -1L, false, data, this);
                    ++this.loadSuccessCount;
                    if (!_logger.isLoggable(this.TRACE_LEVEL)) break block15;
                    _logger.log(this.TRACE_LEVEL, this.storeName + " Successfully loaded session: " + sessionKey);
                }
                Object var13_13 = null;
                try {
                    bis.close();
                }
                catch (Exception ex2) {
                    _logger.log(Level.FINEST, this.storeName + " Error while " + "closing buffered input stream", ex2);
                }
                try {
                    fis.close();
                }
                catch (Exception ex2) {
                    _logger.log(Level.FINEST, this.storeName + " Error while " + "closing file input stream", ex2);
                }
                break block18;
                {
                    catch (Exception ex) {
                        ++this.loadErrorCount;
                        _logger.log(Level.WARNING, "ejb.sfsb_storemgr_loadstate_failed", new Object[]{fileName});
                        _logger.log(Level.WARNING, "ejb.sfsb_storemgr_loadstate_exception", ex);
                        Object var13_14 = null;
                        try {
                            bis.close();
                        }
                        catch (Exception ex2) {
                            _logger.log(Level.FINEST, this.storeName + " Error while " + "closing buffered input stream", ex2);
                        }
                        try {
                            fis.close();
                        }
                        catch (Exception ex2) {
                            _logger.log(Level.FINEST, this.storeName + " Error while " + "closing file input stream", ex2);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    try {
                        bis.close();
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.FINEST, this.storeName + " Error while " + "closing buffered input stream", ex2);
                    }
                    try {
                        fis.close();
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.FINEST, this.storeName + " Error while " + "closing file input stream", ex2);
                    }
                    throw throwable;
                }
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(Level.WARNING, this.storeName + "Could not find passivated " + "file for: " + sessionKey);
            }
        }
        return beanState;
    }

    public void initSessionStore(Map storeEnv) {
        this.storeName = (String)storeEnv.get("com.sun.ejb.spi.sfsb.store.name");
        try {
            Long cId = (Long)storeEnv.get("com.sun.ejb.spi.sfsb.store.containerid");
            this.containerId = cId;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Couldn't get containerID", ex);
        }
        String baseDirName = (String)storeEnv.get("com.sun.ejb.spi.sfsb.store.directory");
        this.baseDir = new File(baseDirName);
        try {
            Integer sessionTimeout = (Integer)storeEnv.get("com.sun.ejb.spi.sfsb.store.timeout");
            if (sessionTimeout != null) {
                this.passivationTimeoutInSeconds = sessionTimeout;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Couldn't get session timeout", ex);
        }
        try {
            Integer graceTimeout = (Integer)storeEnv.get("com.sun.ejb.spi.sfsb.store.grace.timeout");
            if (graceTimeout != null) {
                this.gracePeriodInSeconds = graceTimeout;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Couldn't get session timeout", ex);
        }
        try {
            if (!this.baseDir.mkdirs() && !this.baseDir.isDirectory()) {
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_mdirs_failed", new Object[]{baseDirName});
            } else if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "Successfully Initialized FileStoreManager for: " + this.storeName);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_init_failed", new Object[]{baseDirName});
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_init_exception", ex);
        }
    }

    public void passivateSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        this.saveState(beanState, true);
    }

    public void remove(Object sessionKey) {
        try {
            this.removeFile(new File(this.baseDir, sessionKey.toString()));
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_failed", new Object[]{sessionKey.toString()});
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_exception", ex);
        }
    }

    public void removeAll() {
        try {
            String[] fileNames = this.baseDir.list();
            if (fileNames == null) {
                return;
            }
            for (int i = 0; i < fileNames.length; ++i) {
                this.remove(fileNames[i]);
            }
            if (!this.baseDir.delete() && this.baseDir.exists()) {
                Object[] params = new Object[]{this.baseDir.getAbsolutePath()};
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removedir_failed", params);
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removeall_exception", th);
        }
    }

    public void removeExpired() {
        this.expiredSessionCount += this.removeExpiredSessions();
    }

    public int removeExpiredSessions() {
        if (this.passivationTimeoutInSeconds <= 0) {
            return 0;
        }
        long threshold = System.currentTimeMillis() - (long)(this.passivationTimeoutInSeconds * 1000) - (long)(this.gracePeriodInSeconds * 1000);
        int expiredSessions = 0;
        try {
            String[] fileNames = this.baseDir.list();
            if (fileNames == null) {
                return 0;
            }
            int size = fileNames.length;
            for (int i = 0; i < size && !this.shutdown; ++i) {
                long lastAccessed;
                File file = new File(this.baseDir, fileNames[i]);
                if (!file.exists() || (lastAccessed = file.lastModified()) >= threshold) continue;
                if (!file.delete()) {
                    if (!file.exists()) continue;
                    _logger.log(Level.WARNING, this.storeName + "Couldn't remove file: " + fileNames[i]);
                    continue;
                }
                ++expiredSessions;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, this.storeName + "Exception while getting " + "expired files", ex);
        }
        return expiredSessions;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void updateLastAccessTime(Object sessionKey, long time) throws SFSBStoreManagerException {
        block4: {
            String fileName = sessionKey.toString();
            try {
                File file = new File(this.baseDir, fileName);
                if (file.setLastModified(time)) break block4;
                if (!file.exists()) {
                    _logger.log(Level.WARNING, this.storeName + ": Cannot update timsestamp for: " + sessionKey + "; File does not exist");
                    break block4;
                }
                throw new SFSBStoreManagerException(this.storeName + ": Cannot update timsestamp for: " + sessionKey);
            }
            catch (SFSBStoreManagerException sfsbSMEx) {
                throw sfsbSMEx;
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, this.storeName + ": Exception while updating timestamp", ex);
                throw new SFSBStoreManagerException("Cannot update timsestamp for: " + sessionKey + "; Got exception: " + ex);
            }
        }
    }

    public int getCurrentSize() {
        try {
            String[] fileList = this.baseDir.list();
            if (fileList != null) {
                return fileList.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getLoadCount() {
        return this.loadCount;
    }

    public int getLoadSuccessCount() {
        return this.loadSuccessCount;
    }

    public int getLoadErrorCount() {
        return this.loadErrorCount;
    }

    public int getPassivationCount() {
        return this.storeCount;
    }

    public int getPassivationSuccessCount() {
        return this.storeSuccessCount;
    }

    public int getPassivationErrorCount() {
        return this.storeErrorCount;
    }

    public int getCheckpointCount() {
        return this.storeCount;
    }

    public int getCheckpointSuccessCount() {
        return this.storeSuccessCount;
    }

    public int getCheckpointErrorCount() {
        return this.storeErrorCount;
    }

    public int getExpiredSessionCount() {
        return this.expiredSessionCount;
    }

    /*
     * Loose catch block
     */
    private void saveState(SFSBBeanState beanState, boolean isPassivated) throws SFSBStoreManagerException {
        block23: {
            FileOutputStream fos;
            FilterOutputStream bos;
            File file;
            String fileName;
            block21: {
                Object sessionKey = beanState.getId();
                fileName = sessionKey.toString();
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    _logger.log(this.TRACE_LEVEL, this.storeName + " Attempting to save " + "session: " + sessionKey);
                }
                file = null;
                bos = null;
                fos = null;
                ++this.storeCount;
                file = new File(this.baseDir, fileName);
                if (file.exists()) {
                    if (beanState.isNew()) {
                        _logger.log(Level.WARNING, this.storeName + " [InternalError] " + "isNew() must be false for: " + sessionKey);
                    }
                } else if (!beanState.isNew()) {
                    _logger.log(Level.WARNING, this.storeName + " [InternalError] " + "isNew() must be true for: " + sessionKey);
                }
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                byte[] data = beanState.getState();
                ((BufferedOutputStream)bos).write(data, 0, data.length);
                ++this.storeSuccessCount;
                if (!_logger.isLoggable(this.TRACE_LEVEL)) break block21;
                _logger.log(this.TRACE_LEVEL, this.storeName + " Successfully saved " + "session: " + sessionKey);
            }
            Object var11_10 = null;
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Error while closing buffered output stream", ex);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                break block23;
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Error while closing file output stream", ex);
            }
            break block23;
            {
                catch (Exception ex) {
                    ++this.storeErrorCount;
                    _logger.log(Level.WARNING, "ejb.sfsb_storemgr_savestate_failed", new Object[]{fileName});
                    _logger.log(Level.WARNING, "ejb.sfsb_storemgr_savestate_exception", ex);
                    try {
                        this.removeFile(file);
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                    String errMsg = "Could not save session: " + beanState.getId();
                    throw new SFSBStoreManagerException(errMsg, ex);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Error while closing buffered output stream", ex);
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Error while closing file output stream", ex);
                }
                throw throwable;
            }
        }
    }

    private boolean removeFile(final File file) {
        boolean success = false;
        success = System.getSecurityManager() == null ? file.delete() : ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.delete();
            }
        })).booleanValue();
        if (!success) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_failed", new Object[]{file.getName()});
        } else if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, this.storeName + " Removed session: " + file.getName());
        }
        return success;
    }

    public MonitorableSFSBStoreManager getMonitorableSFSBStoreManager() {
        return this;
    }

    public long getCurrentStoreSize() {
        try {
            return this.baseDir.list().length;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void appendStats(StringBuffer sbuf) {
    }

    public void monitoringLevelChanged(boolean monitoringOn) {
    }
}

