/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMethodStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="ejb-application-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Ejb Application Statistics")
public class EjbMonitoringStatsProvider {
    private Map<Method, String> methodMappingMap = new HashMap<Method, String>();
    private Map<String, EjbMethodStatsProvider> methodMonitorMap = new HashMap<String, EjbMethodStatsProvider>();
    String appName = null;
    String moduleName = null;
    String beanName = null;
    boolean registered = false;
    private CountStatisticImpl createStat = new CountStatisticImpl("CreateCount", "count", "Number of times EJB create method is called");
    private CountStatisticImpl removeStat = new CountStatisticImpl("RemoveCount", "count", "Number of times EJB remove method is called");
    static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();

    public EjbMonitoringStatsProvider(String appName, String moduleName, String beanName) {
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
    }

    public void addMethods(String appName, String moduleName, String beanName, Method[] methods) {
        if (this.isValidRequest(appName, moduleName, beanName)) {
            for (Method m : methods) {
                String mname = EjbMonitoringUtils.stringify(m);
                this.methodMappingMap.put(m, mname);
                if (this.methodMonitorMap.get(mname) != null) continue;
                EjbMethodStatsProvider monitor = new EjbMethodStatsProvider(mname);
                this.methodMonitorMap.put(mname, monitor);
            }
        }
    }

    public void register() {
        String beanSubTreeNode = EjbMonitoringUtils.registerComponent(this.appName, this.moduleName, this.beanName, this);
        if (beanSubTreeNode != null) {
            this.registered = true;
            for (String mname : this.methodMonitorMap.keySet()) {
                EjbMethodStatsProvider monitor;
                String node = EjbMonitoringUtils.registerMethod(beanSubTreeNode, mname, monitor = this.methodMonitorMap.get(mname));
                if (node == null) continue;
                monitor.registered();
            }
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
            for (EjbMethodStatsProvider monitor : this.methodMonitorMap.values()) {
                if (!monitor.isRegistered()) continue;
                monitor.unregistered();
                StatsProviderManager.unregister((Object)monitor);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodStartEvent")
    public void ejbMethodStartEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="method") Method method) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbMethodStartEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(this.methodMappingMap.get(EjbMonitoringUtils.stringify(method)));
            if (monitor != null) {
                monitor.methodStart();
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodEndEvent")
    public void ejbMethodEndEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="exception") Throwable exception, @ProbeParam(value="method") Method method) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbMethodEndEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(this.methodMappingMap.get(EjbMonitoringUtils.stringify(method)));
            if (monitor != null) {
                monitor.methodEnd(exception == null);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanCreatedEvent")
    public void ejbBeanCreatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbBeanCreatedEvent");
            this.createStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanDestroyedEvent")
    public void ejbBeanDestroyedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbBeanDestroyedEvent");
            this.removeStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanActivatedEvent")
    public void ejbBeanActivatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbBeanActivatedEvent");
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanPassivatedEvent")
    public void ejbBeanPassivatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("ejbBeanPassivatedEvent");
        }
    }

    @ManagedAttribute(id="createcount")
    @Description(value="Number of times EJB create method is called")
    public CountStatistic getCreateCount() {
        return this.createStat.getStatistic();
    }

    @ManagedAttribute(id="removecount")
    @Description(value="Number of times EJB remove method is called")
    public CountStatistic getRemoveCount() {
        return this.removeStat.getStatistic();
    }

    boolean isValidRequest(String appName, String moduleName, String beanName) {
        if (this.appName == null && appName != null || this.appName != null && !this.appName.equals(appName)) {
            return false;
        }
        if (this.moduleName == null && moduleName != null || this.moduleName != null && !this.moduleName.equals(moduleName)) {
            return false;
        }
        return (this.beanName != null || beanName == null) && (this.beanName == null || this.beanName.equals(beanName));
    }

    void log(String mname, String provider) {
        _logger.fine("===> In " + provider + " for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName);
    }

    private void log(String mname) {
        this.log(mname, "EjbMonitoringStatsProvider");
    }

    private void log(String mname, Method m) {
        _logger.fine("===> In EjbMonitoringStatsProvider for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName + "::" + EjbMonitoringUtils.stringify(m));
    }
}

