/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;

public class StatefulSessionBeanStatsProvider
extends EjbMonitoringStatsProvider {
    private BoundedRangeStatisticImpl methodReadyStat = null;
    private BoundedRangeStatisticImpl passiveCount = null;
    private int methodReadyCount = 0;
    private StatefulSessionContainer delegate;

    public StatefulSessionBeanStatsProvider(StatefulSessionContainer delegate, String appName, String moduleName, String beanName) {
        super(appName, moduleName, beanName);
        this.delegate = delegate;
        long now = System.currentTimeMillis();
        this.methodReadyStat = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxCacheSize(), 0L, "MethodReadyCount", "count", "Number of stateful session beans in MethodReady state", now, now);
        this.passiveCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "PassiveCount", "count", "Number of stateful session beans in Passive state", now, now);
    }

    @ManagedAttribute(id="methodreadycount")
    @Description(value="Number of stateful session beans in MethodReady state")
    public RangeStatistic getMethodReadyCount() {
        this.methodReadyStat.setCurrent((long)this.methodReadyCount);
        return this.methodReadyStat.getStatistic();
    }

    @ManagedAttribute(id="passivecount")
    @Description(value="Number of stateful session beans in Passive state")
    public RangeStatistic getPassiveCount() {
        this.passiveCount.setCurrent(this.delegate.getPassiveCount());
        return this.passiveCount.getStatistic();
    }

    @ProbeListener(value="glassfish:ejb:bean:methodReadyAddEvent")
    public void methodReadyAddEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("methodReadyAddEvent", "StatefulSessionBeanStatsProvider");
            ++this.methodReadyCount;
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodReadyRemoveEvent")
    public void methodReadyRemoveEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidRequest(appName, modName, ejbName)) {
            this.log("methodReadyRemoveEvent", "StatefulSessionBeanStatsProvider");
            --this.methodReadyCount;
        }
    }
}

