/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.ejb.api.DistributedEJBTimerService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-timers")
@I18n(value="list.timers")
public class ListTimers
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListTimers.class);
    @Param(primary=true, optional=true)
    String target;
    @Inject
    DistributedEJBTimerService timerService;
    @Inject
    Servers servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.target != null && !this.target.equals("server")) {
            report.setMessage(localStrings.getLocalString("list.timers.invalid.target", "Invalid target specified as Operand"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        try {
            String[] timerList;
            for (String timer : timerList = this.timerService.listTimers(new String[]{((Server)this.servers.getServer().get(0)).getName()})) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(timer);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.timers.failed", "List Timers command failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

