/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.builder;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.util.CheckpointPolicyImpl;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.builder.BaseContainerBuilder;
import com.sun.ejb.containers.builder.CachePassivatorTask;
import com.sun.ejb.containers.builder.ExpiredSessionsRemovalTask;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.ejb.spi.container.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class StatefulContainerBuilder
extends BaseContainerBuilder {
    private static final Level TRACE_LEVEL = Level.FINE;
    private StatefulSessionContainer sfsbContainer;
    private SFSBContainerInitialization containerInitialization;
    @Inject
    private Habitat habitat;
    @Inject
    private CacheProperties cacheProps;
    @Inject
    private EJBServerConfigLookup ejbConfigLookup;
    @Inject
    private AvailabilityService availabilityService;
    @Inject
    private EjbContainerAvailability ejbAvailability;
    @Inject
    EjbContainer ejbContainerConfig;
    private LruSessionCache sessionCache;
    private BackingStore<Serializable, SFSBBeanState> backingStore;
    private boolean HAEnabled = false;

    public BaseContainer createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader) throws Exception {
        this.cacheProps.init(ejbDescriptor);
        this.ejbConfigLookup.initWithEjbDescriptor(ejbDescriptor);
        this.sfsbContainer = new StatefulSessionContainer(ejbDescriptor, loader);
        this.containerInitialization = this.sfsbContainer;
        return this.sfsbContainer;
    }

    public void buildComponents() throws Exception {
        this.HAEnabled = this.ejbConfigLookup.calculateEjbAvailabilityEnabledFromConfig();
        this.buildCheckpointPolicy(this.HAEnabled);
        this.buildSFSBUUIDUtil();
        this.buildStoreManager();
        this.buildCache();
        this.scheduleTimerTasks(this.sfsbContainer);
    }

    private final void buildCheckpointPolicy(boolean haEnabled) {
        this.containerInitialization.setCheckpointPolicy(new CheckpointPolicyImpl(haEnabled));
    }

    private void buildSFSBUUIDUtil() {
        this.containerInitialization.setSFSBUUIDUtil(this.HAEnabled ? new ScrambledKeyGenerator(this.getIPAddress(), this.getPort()) : new SimpleKeyGenerator(this.getIPAddress(), this.getPort()));
    }

    private void buildStoreManager() throws BackingStoreException {
        String persistenceStoreType = this.ejbConfigLookup.getPersistenceStoreType();
        BackingStoreFactory factory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, persistenceStoreType);
        Properties env = new Properties();
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        String storeName = this.ejbDescriptor.getName() + "-" + this.getContainer().getComponentId() + "-" + "BackingStore";
        String subDirName = "";
        if (this.ejbDescriptor.getApplication().isVirtual()) {
            String archURI = this.ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
            subDirName = subDirName + FileUtils.makeFriendlyFilename((String)archURI);
            subDirName = subDirName + "_" + FileUtils.makeFriendlyFilename((String)this.ejbDescriptor.getName());
        } else {
            subDirName = subDirName + FileUtils.makeFriendlyFilename((String)this.ejbDescriptor.getApplication().getRegistrationName());
            subDirName = subDirName + "_" + FileUtils.makeFriendlyFilename((String)this.ejbDescriptor.getEjbBundleDescriptor().getName());
            subDirName = subDirName + "_" + FileUtils.makeFriendlyFilename((String)this.ejbDescriptor.getName());
        }
        conf.setShortUniqueName("" + this.ejbDescriptor.getUniqueId()).setStoreName(storeName).setStoreType(persistenceStoreType).setBaseDirectory(new File(this.ejbContainerConfig.getSessionStore(), subDirName)).setKeyClazz(Serializable.class).setValueClazz(SFSBBeanState.class);
        this.backingStore = factory == null ? null : factory.createBackingStore(conf);
        _logger.log(Level.WARNING, "StatefulContainerbuilder instantiated store: " + this.backingStore.getClass().getName() + " ==> " + conf.getStoreName());
    }

    private void buildCache() {
        String cacheName = this.ejbDescriptor.getEjbClassName();
        String victimPolicy = this.cacheProps.getVictimSelectionPolicy();
        this.sessionCache = this.cacheProps.getMaxCacheSize() <= 0 ? new UnBoundedSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("lru".equalsIgnoreCase(victimPolicy) ? new LruSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("fifo".equalsIgnoreCase(victimPolicy) ? new FIFOSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : new NRUSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds())));
        float ratio = (float)(1.0 * (double)this.cacheProps.getNumberOfVictimsToSelect() / (double)this.cacheProps.getMaxCacheSize());
        float loadFactor = (float)(1.0 - (double)ratio);
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        if (this.cacheProps.getMaxCacheSize() <= 0) {
            this.sessionCache.init(16384, loadFactor, null);
        } else {
            this.sessionCache.init(this.cacheProps.getMaxCacheSize(), loadFactor, null);
        }
        this.sessionCache.addCacheListener(this.sfsbContainer);
        this.sfsbContainer.setSessionCache(this.sessionCache);
        this.sessionCache.setBackingStore(this.backingStore);
        this.sfsbContainer.setBackingStore(this.backingStore);
        if (this.cacheProps.getNumberOfVictimsToSelect() > 8) {
            this.sfsbContainer.setPassivationBatchCount(this.cacheProps.getNumberOfVictimsToSelect());
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "Created cache [for " + this.ejbDescriptor.getName() + "] " + this.cacheProps + "; loadFactor: " + loadFactor + "; backingStore: " + this.backingStore);
        }
    }

    private void scheduleTimerTasks(StatefulSessionContainer container) {
        long timeout;
        String ejbName = this.ejbDescriptor.getEjbClassName();
        if (this.cacheProps.getCacheIdleTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getCacheIdleTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new CachePassivatorTask(ejbName, this.sessionCache, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added CachePassivator for: " + ejbName + ". To run after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_idle_passivatortask_failed", th);
            }
        }
        if (this.cacheProps.getRemovalTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getRemovalTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new ExpiredSessionsRemovalTask(ejbName, this.sfsbContainer, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added StorePassivator for: " + ejbName + ". To run after " + "after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_remove_passivatortask_failed", th);
            }
        }
    }
}

