/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerTask;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerLocal;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerSchedule;
import com.sun.ejb.containers.TimerState;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.server.ServerEnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBTimerService {
    private static EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
    private long nextTimerIdMillis_ = 0L;
    private long nextTimerIdCounter_ = 0L;
    private String serverName_;
    private String domainName_;
    private static final String TIMER_ID_SEP = "@@";
    private String ownerIdOfThisServer_;
    private TimerCache timerCache_;
    private TimerLocal timerLocal_;
    private boolean shutdown_;
    private long totalTimedObjectsInitialized_ = 0L;
    private static final Logger logger = LogDomains.getLogger(EJBTimerService.class, (String)"javax.enterprise.system.container.ejb");
    private static final int MAX_REDELIVERIES = 1;
    private static final long REDELIVERY_INTERVAL = 5000L;
    private String appID;
    private long minimumDeliveryInterval_ = 1000L;
    private long maxRedeliveries_ = 1L;
    private long redeliveryInterval_ = 5000L;
    private static final String TIMER_SERVICE_FILE = "__timer_service_shutdown__.dat";
    private static final String TIMER_SERVICE_DOWNTIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private boolean performDBReadBeforeTimeout = false;
    private static final String strDBReadBeforeTimeout = "com.sun.ejb.timer.ReadDBBeforeTimeout";
    private boolean foundSysPropDBReadBeforeTimeout = false;
    private Agent agent = ejbContainerUtil.getCallFlowAgent();

    public EJBTimerService(String appID, TimerLocal timerLocal) {
        this.timerLocal_ = timerLocal;
        this.timerCache_ = new TimerCache();
        this.shutdown_ = false;
        this.appID = appID;
        ServerEnvironmentImpl env = ejbContainerUtil.getServerEnvironment();
        this.domainName_ = env.getDomainName();
        this.serverName_ = env.getInstanceName();
        this.initProperties();
    }

    private void initProperties() {
        try {
            EjbContainer ejbc = ejbContainerUtil.getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            if (ejbt != null) {
                long val;
                String valString = ejbt.getMinimumDeliveryIntervalInMillis();
                long l = val = valString != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.minimumDeliveryInterval_ = val;
                }
                long l2 = val = (valString = ejbt.getMaxRedeliveries()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.maxRedeliveries_ = val;
                }
                long l3 = val = (valString = ejbt.getRedeliveryIntervalInternalInMillis()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.redeliveryInterval_ = val;
                }
                this.foundSysPropDBReadBeforeTimeout = this.getDBReadBeforeTimeoutProperty();
                this.setPerformDBReadBeforeTimeout(false);
            }
            this.ownerIdOfThisServer_ = ejbContainerUtil.getServerEnvironment().getInstanceName();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
        logger.log(Level.FINE, "EJB Timer Service properties : min delivery interval = " + this.minimumDeliveryInterval_ + "\nmax redeliveries = " + this.maxRedeliveries_ + "\nredelivery interval = " + this.redeliveryInterval_);
    }

    synchronized void timedObjectCount() {
        ++this.totalTimedObjectsInitialized_;
    }

    String getOwnerIdOfThisServer() {
        return this.ownerIdOfThisServer_;
    }

    private EJBException createEJBException(Exception ex) {
        EJBException ejbEx = new EJBException();
        ejbEx.initCause((Throwable)ex);
        return ejbEx;
    }

    public String[] listTimers(String[] serverIds) {
        String[] totalTimers = null;
        try {
            totalTimers = this.timerLocal_.countTimersOwnedByServerIds(serverIds);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception in listTimers() : ", ex);
            EJBException ejbEx = this.createEJBException(ex);
            throw ejbEx;
        }
        return totalTimers;
    }

    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from an active server instance " + ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from  an active server instance " + ownerIdOfThisServer);
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner " + fromOwnerId + " to " + ownerIdOfThisServer);
        JavaEETransactionManager tm = ejbContainerUtil.getTransactionManager();
        Set<TimerState> toRestore = new HashSet();
        int totalTimersMigrated = 0;
        try {
            tm.begin();
            toRestore = this.timerLocal_.findTimersOwnedBy(fromOwnerId);
            totalTimersMigrated = this.timerLocal_.migrateTimers(fromOwnerId, ownerIdOfThisServer);
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "timer migration error", e);
            try {
                tm.rollback();
            }
            catch (Exception re) {
                logger.log(Level.FINE, "timer migration rollback error", re);
            }
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        if (totalTimersMigrated > 0) {
            boolean success = false;
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of " + toRestore.size() + " timers.  Now reactivating timers...");
                tm.begin();
                this._restoreTimers(toRestore);
                success = true;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "timer restoration error", e);
                EJBException ejbEx = this.createEJBException(e);
                throw ejbEx;
            }
            finally {
                block15: {
                    try {
                        tm.commit();
                    }
                    catch (Exception re) {
                        logger.log(Level.FINE, "timer migration error", re);
                        if (!success) break block15;
                        EJBException ejbEx = this.createEJBException(re);
                        throw ejbEx;
                    }
                }
            }
        }
        logger.log(Level.INFO, fromOwnerId + " has 0 timers in need " + "of migration");
        return totalTimersMigrated;
    }

    public void setPerformDBReadBeforeTimeout(boolean defaultDBReadValue) {
        if (!this.foundSysPropDBReadBeforeTimeout) {
            this.performDBReadBeforeTimeout = defaultDBReadValue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
            }
        }
    }

    private boolean getDBReadBeforeTimeoutProperty() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty(strDBReadBeforeTimeout);
            if (null != str) {
                str = str.toLowerCase();
                this.performDBReadBeforeTimeout = Boolean.valueOf(str);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
                }
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "ContainerFactoryImpl.getDebugMonitoringDetails(),  Exception when trying to get the System properties - ", e);
        }
        return result;
    }

    public boolean restoreEJBTimers() {
        boolean rc = false;
        try {
            if (this.totalTimedObjectsInitialized_ > 0L) {
                this.restoreTimers();
                rc = true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception restoring EJB Timers", ex);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        JavaEETransactionManager tm = ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServer());
        }
        catch (Exception e) {
            ejbContainerUtil.setEJBTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            return;
        }
        finally {
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            }
        }
    }

    private Set<TimerState> _restoreTimers(Set<TimerState> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<TimerState> result = new HashSet<TimerState>();
        for (TimerState timer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = this.getPrimaryKey(timer);
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: " + timer);
                result.add(timer);
                continue;
            }
            long containerId = timer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                Date initialExpiration = timer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.containerType == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = timer.getTimedObjectPrimaryKey();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, timer.getIntervalDuration(), container, timedObjectPrimaryKey, timer.getTimerSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = timer.getLastExpiration();
                    TimerSchedule ts = timer.getTimerSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ". Timer expirations should " + " have been delivered starting at " + initialExpiration);
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > timer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ".  Last timer expiration " + "occurred at " + lastExpiration);
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + timerState + ". Timer expiration should " + " have been delivered at " + initialExpiration);
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer " + timerState + " that will never expire again");
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(timer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer " + timerId + " for container that is not up: " + containerId);
        }
        if (timerIdsToRemove.size() > 0) {
            this.timerLocal_.remove(timerIdsToRemove);
        }
        for (Map.Entry next : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)next.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)next.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    void shutdown() {
        this.shutdown_ = true;
    }

    void cancelEntityBeanTimers(long containerId, Object primaryKey) {
        try {
            Collection<TimerState> timers = this.getTimers(containerId, primaryKey);
            if (logger.isLoggable(Level.FINE) && timers.isEmpty()) {
                logger.log(Level.FINE, "0 cancelEntityBeanTimers for " + containerId + ", " + primaryKey);
            }
            this.timerLocal_.cancelTimers(timers);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.cancel_entity_timers", new Object[]{String.valueOf(containerId), primaryKey});
            logger.log(Level.WARNING, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void destroyTimers(long containerId) {
        block20: {
            Set timerIds = null;
            JavaEETransactionManager tm = ejbContainerUtil.getTransactionManager();
            tm.begin();
            timerIds = this.timerLocal_.findTimerIdsByContainer(containerId);
            timerIds.addAll(this.timerCache_.getNonPersistentTimerIdsForContainer(containerId));
            for (TimerPrimaryKey nextTimerId : timerIds) {
                RuntimeTimerState nextTimerState = null;
                try {
                    nextTimerState = this.getTimerState(nextTimerId);
                    if (nextTimerState == null) continue;
                    RuntimeTimerState runtimeTimerState = nextTimerState;
                    synchronized (runtimeTimerState) {
                        if (nextTimerState.isScheduled()) {
                            EJBTimerTask timerTask = nextTimerState.getCurrentTimerTask();
                            timerTask.cancel();
                        }
                    }
                    if (!nextTimerState.isPersistent()) continue;
                    this.timerLocal_.remove(nextTimerId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ejb.destroy_timer_error", new Object[]{nextTimerId});
                    logger.log(Level.WARNING, "", e);
                }
                finally {
                    if (nextTimerState == null) continue;
                    this.timerCache_.removeTimer(nextTimerId);
                }
            }
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(containerId)});
                logger.log(Level.WARNING, "", e);
            }
            break block20;
            catch (Exception ex) {
                try {
                    logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(containerId)});
                    logger.log(Level.WARNING, "", ex);
                }
                catch (Throwable throwable) {
                    try {
                        tm.commit();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(containerId)});
                        logger.log(Level.WARNING, "", e);
                    }
                    throw throwable;
                }
                try {
                    tm.commit();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(containerId)});
                    logger.log(Level.WARNING, "", e);
                }
                return;
            }
        }
    }

    void rescheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, true);
    }

    void scheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(TimerPrimaryKey timerId, Date expiration, boolean rescheduled) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                Date cutoff;
                Date timerExpiration = expiration;
                if (!rescheduled && expiration.before(cutoff = new Date(new Date().getTime() + this.getMinimumDeliveryInterval()))) {
                    timerExpiration = cutoff;
                }
                EJBTimerTask timerTask = new EJBTimerTask(timerExpiration, timerId, this);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, (rescheduled ? "RE-" : "") + "Scheduling " + timerState + " for timeout at " + timerExpiration);
                }
                if (rescheduled) {
                    timerState.rescheduled(timerTask);
                } else {
                    timerState.scheduled(timerTask);
                }
                Timer jdkTimer = ejbContainerUtil.getTimer();
                jdkTimer.schedule((TimerTask)timerTask, timerExpiration);
            }
        } else {
            logger.log(Level.FINE, "No timer state found for " + (rescheduled ? "RE-schedule" : "schedule") + " request of " + timerId + " for timeout at " + expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date cancelTask(TimerPrimaryKey timerId) {
        Date timeout = null;
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isCreated()) {
                    timeout = timerState.getInitialExpiration();
                } else if (timerState.isScheduled()) {
                    EJBTimerTask timerTask = timerState.getCurrentTimerTask();
                    timeout = timerTask.getTimeout();
                    timerTask.cancel();
                }
                timerState.cancelled();
            }
        } else {
            logger.log(Level.FINE, "No timer state found for cancelTask request of " + timerId);
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTaskToDelivered(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                timerState.restoredToDelivered();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Restoring " + timerId + " to delivered state after it was cancelled and " + " rolled back from within its own ejbTimeout method");
            }
        } else {
            logger.log(Level.FINE, "No timer state found for restoreTaskToDelivered request of " + timerId);
        }
    }

    void expungeTimer(TimerPrimaryKey timerId) {
        this.expungeTimer(timerId, false);
    }

    private Date calcInitialFixedRateExpiration(long timerServiceWentDownAt, RuntimeTimerState timerState) {
        long now2initialDiff;
        long count;
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException();
        }
        Date now = new Date();
        long nowMillis = now.getTime();
        long initialExpiration = timerState.getInitialExpiration().getTime();
        long previousExpiration = initialExpiration + (count = (now2initialDiff = nowMillis - initialExpiration) / timerState.getIntervalDuration()) * timerState.getIntervalDuration();
        if (previousExpiration >= timerServiceWentDownAt && previousExpiration <= nowMillis) {
            logger.log(Level.INFO, "ejb.deliver_missed_timer", new Object[]{timerState.getTimerId(), new Date(previousExpiration)});
            return now;
        }
        return this.calcNextFixedRateExpiration(timerState);
    }

    private Date calcNextFixedRateExpiration(RuntimeTimerState timerState) {
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException("Timer " + timerState + " is " + "not a periodic timer");
        }
        TimerSchedule ts = timerState.getTimerSchedule();
        if (ts != null) {
            return this.getNextScheduledTimeout(ts);
        }
        Date initialExpiration = timerState.getInitialExpiration();
        long intervalDuration = timerState.getIntervalDuration();
        return this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
    }

    private Date calcNextFixedRateExpiration(Date initialExpiration, long intervalDuration) {
        Date now = new Date();
        long nowMillis = now.getTime();
        Date nextExpirationTime = initialExpiration;
        if (now.after(initialExpiration)) {
            long timeSinceInitialExpire = nowMillis - initialExpiration.getTime();
            long numIntervals = timeSinceInitialExpire / intervalDuration;
            nextExpirationTime = new Date(initialExpiration.getTime() + (numIntervals + 1L) * intervalDuration);
        }
        return nextExpirationTime;
    }

    private void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        if (removeTimerBean) {
            this.removeTimerBean(timerId);
        }
        this.timerCache_.removeTimer(timerId);
    }

    TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        Date now = new Date();
        Date initialExpiration = new Date(now.getTime() + initialDuration);
        return this.createTimer(containerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, null, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, TimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, timedObjectPrimaryKey, null, 0L, schedule, timerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerPrimaryKey createTimer(long containerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, TimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        BaseContainer container = this.getContainer(containerId);
        if (container == null) {
            throw new CreateException("invalid container id " + containerId + " in createTimer request");
        }
        Class ejbClass = container.getEJBClass();
        if (!container.isTimedObject()) {
            throw new CreateException("Attempt to create an EJB Timer from a bean that is not a Timed Object.  EJB class " + ejbClass + " must implement javax.ejb.TimedObject or " + " annotation a timeout method with @Timeout");
        }
        TimerPrimaryKey timerId = new TimerPrimaryKey(this.getNextTimerId());
        boolean expired = false;
        if (schedule != null) {
            Calendar next = schedule.getNextTimeout();
            if (!schedule.isValid(next)) {
                logger.log(Level.INFO, "Schedule: " + schedule.getScheduleAsString() + " already expired");
                expired = true;
                initialExpiration = new Date();
            } else {
                initialExpiration = next.getTime();
            }
        }
        if (timerConfig == null) {
            timerConfig = new TimerConfig();
        }
        RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, intervalDuration, container, timedObjectPrimaryKey, schedule, timerConfig.getInfo(), timerConfig.isPersistent());
        if (expired) {
            timerState.expired();
        }
        RuntimeTimerState runtimeTimerState = timerState;
        synchronized (runtimeTimerState) {
            this.timerCache_.addTimer(timerId, timerState);
            try {
                if (timerConfig.isPersistent()) {
                    this.timerLocal_.createTimer(timerId.getTimerId(), containerId, this.ownerIdOfThisServer_, timedObjectPrimaryKey, initialExpiration, intervalDuration, schedule, timerConfig);
                } else {
                    this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{String.valueOf(containerId), timedObjectPrimaryKey, timerConfig.getInfo()});
                logger.log(Level.SEVERE, "", e);
                this.timerCache_.removeTimer(timerId);
                if (e instanceof CreateException) {
                    throw (CreateException)((Object)e);
                }
                EJBException ejbEx = new EJBException();
                ejbEx.initCause((Throwable)e);
                throw ejbEx;
            }
        }
        return timerId;
    }

    Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        JavaEETransactionManager tm = ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            Set<TimerState> timers = this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServerByContainer(containerId));
            if (timers.size() > 0) {
                logger.log(Level.FINE, "Found " + timers.size() + " persistent timers for containerId: " + containerId);
            }
            for (TimerState timer : timers) {
                TimerSchedule ts = timer.getTimerSchedule();
                if (ts == null || !ts.isAutomatic()) continue;
                for (Method m : schedules.keySet()) {
                    if (!m.getName().equals(ts.getTimerMethodName()) || m.getParameterTypes().length != ts.getMethodParamCount()) continue;
                    result.put(new TimerPrimaryKey(timer.getTimerId()), m);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "@@@ FOUND existing schedule: " + ts.getScheduleAsString() + " FOR method: " + m);
                }
            }
            for (Method m : schedules.keySet()) {
                for (ScheduledTimerDescriptor sch : schedules.get(m)) {
                    boolean persistent = sch.getPersistent();
                    if (persistent && !deploy) continue;
                    TimerSchedule ts = new TimerSchedule(sch, m.getName(), m.getParameterTypes().length);
                    TimerConfig tc = new TimerConfig();
                    String info = sch.getInfo();
                    if (info != null && !info.equals("")) {
                        tc.setInfo((Serializable)((Object)info));
                    }
                    tc.setPersistent(persistent);
                    result.put(this.createTimer(containerId, null, ts, tc), m);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "@@@ CREATED new schedule: " + ts.getScheduleAsString() + " FOR method: " + m);
                }
            }
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Timer restore or schedule creation error", e);
            try {
                tm.rollback();
            }
            catch (Exception re) {
                logger.log(Level.FINE, "Timer restore or schedule creation rollback error", re);
            }
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        return result;
    }

    private Collection<TimerState> getTimers(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerState> activeTimers;
        HashSet<TimerState> timersForTimedObject = activeTimers = this.timerLocal_.findActiveTimersByContainer(containerId);
        if (timedObjectPrimaryKey != null) {
            timersForTimedObject = new HashSet<TimerState>();
            for (TimerState timer : activeTimers) {
                Object nextTimedObjectPrimaryKey = timer.getTimedObjectPrimaryKey();
                if (!nextTimedObjectPrimaryKey.equals(timedObjectPrimaryKey)) continue;
                timersForTimedObject.add(timer);
            }
        }
        return timersForTimedObject;
    }

    Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        Set<TimerPrimaryKey> timerIdsForTimedObject = new HashSet();
        if (timedObjectPrimaryKey == null) {
            timerIdsForTimedObject = this.timerLocal_.findActiveTimerIdsByContainer(containerId);
        } else {
            Collection<TimerState> timersForTimedObject = this.getTimers(containerId, timedObjectPrimaryKey);
            for (TimerState timer : timersForTimedObject) {
                timerIdsForTimedObject.add(this.getPrimaryKey(timer));
            }
        }
        timerIdsForTimedObject.addAll(this.timerCache_.getNonPersistentActiveTimerIdsForContainer(containerId));
        return timerIdsForTimedObject;
    }

    ClassLoader getTimerClassLoader(long containerId) {
        BaseContainer container = this.getContainer(containerId);
        return container != null ? container.getClassLoader() : null;
    }

    private RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getTimerState(timerId);
    }

    private RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getNonPersistentTimerState(timerId);
    }

    Set<TimerPrimaryKey> getActiveTimerIdsByThisServer() {
        return this.timerCache_.getActiveTimerIdsByThisServer();
    }

    void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null) {
            if (rt.isCancelled()) {
                return;
            }
            this.cancelTimerSynchronization(null, timerId, rt.getContainerId(), this.ownerIdOfThisServer_, false);
        } else {
            this.timerLocal_.cancel(timerId);
        }
    }

    Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        Date initialExpiration = null;
        long intervalDuration = 0L;
        TimerSchedule ts = null;
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            initialExpiration = rt.getInitialExpiration();
            intervalDuration = rt.getIntervalDuration();
            ts = rt.getTimerSchedule();
        } else {
            TimerState timer = this.getPersistentTimer(timerId);
            initialExpiration = timer.getInitialExpiration();
            intervalDuration = timer.getIntervalDuration();
            ts = timer.getTimerSchedule();
        }
        Date nextTimeout = initialExpiration;
        if (ts != null) {
            nextTimeout = this.getNextScheduledTimeout(ts);
        } else if (intervalDuration > 0L) {
            nextTimeout = this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
        }
        return nextTimeout;
    }

    Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return rt.getInfo();
        }
        TimerState timer = this.getPersistentTimer(timerId);
        return timer.getInfo();
    }

    ScheduleExpression getScheduleExpression(TimerPrimaryKey timerId) throws FinderException {
        TimerSchedule ts = this.getTimerSchedule(timerId);
        return ts == null ? null : ts.getScheduleExpression();
    }

    boolean isCalendarTimer(TimerPrimaryKey timerId) throws FinderException {
        TimerSchedule ts = this.getTimerSchedule(timerId);
        return ts != null;
    }

    boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return false;
        }
        TimerState timer = this.getPersistentTimer(timerId);
        return true;
    }

    boolean timerExists(TimerPrimaryKey timerId) {
        TimerState timer;
        boolean exists = false;
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null) {
            exists = rt.isActive();
        }
        if ((timer = this.timerLocal_.findTimer(timerId)) != null) {
            exists = timer.isActive();
        }
        return exists;
    }

    private TimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        TimerSchedule ts = null;
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            ts = rt.getTimerSchedule();
        } else {
            TimerState timer = this.getPersistentTimer(timerId);
            ts = timer.getTimerSchedule();
        }
        return ts;
    }

    private void removeTimerBean(TimerPrimaryKey timerId) {
        try {
            this.timerLocal_.remove(timerId);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "ejb.remove_timer_failure", new Object[]{timerId});
            logger.log(Level.WARNING, "", t);
        }
    }

    private TimerState getPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        TimerState timer = this.timerLocal_.findTimer(timerId);
        if (timer == null || timer.isCancelled()) {
            throw new FinderException("timer " + timerId + " does not exist");
        }
        return timer;
    }

    private RuntimeTimerState getNonPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null && rt.isCancelled()) {
            throw new FinderException("Non-persistent timer " + timerId + " does not exist");
        }
        return rt;
    }

    private BaseContainer getContainer(long containerId) {
        return ejbContainerUtil.getContainer(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTimeout(TimerPrimaryKey timerId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService.deliverTimeout(): work thread is processing work for timerId = " + timerId);
        }
        if (this.shutdown_) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown.  Expiration " + " will occur when server is restarted.");
            }
            return;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState == null) {
            logger.log(Level.FINE, "Timer state is NULL for timer " + timerId + " in deliverTimeout");
            return;
        }
        BaseContainer container = this.getContainer(timerState.getContainerId());
        RuntimeTimerState runtimeTimerState = timerState;
        synchronized (runtimeTimerState) {
            if (container == null) {
                logger.log(Level.FINE, "Unknown container for timer " + timerId + " in deliverTimeout.  Expunging timer.");
                this.expungeTimer(timerId, true);
                return;
            }
            if (!timerState.isBeingDelivered()) {
                logger.log(Level.FINE, "Timer state = " + timerState.stateToString() + "for timer " + timerId + " before callEJBTimeout");
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Calling ejbTimeout for timer " + timerState);
            }
        }
        try {
            boolean redeliver;
            this.agent.requestStart(RequestType.TIMER_EJB);
            container.onEnteringContainer();
            if (this.performDBReadBeforeTimeout) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "For Timer :" + timerId + ": check the database to ensure that the timer is still " + " valid, before delivering the ejbTimeout call");
                }
                if (!this.checkForTimerValidity(timerId)) {
                    return;
                }
            }
            boolean bl = redeliver = timerState.isExpired() ? false : container.callEJBTimeout(timerState, this);
            if (this.shutdown_) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown. Expiration will " + " occur on server restart");
                }
                return;
            }
            timerState = this.getTimerState(timerId);
            if (timerState == null) {
                logger.log(Level.FINE, "Timer no longer exists for " + timerId + " after callEJBTimeout");
                return;
            }
            RuntimeTimerState runtimeTimerState2 = timerState;
            synchronized (runtimeTimerState2) {
                Date now = new Date();
                if (!timerState.isCancelled()) {
                    if (timerState.isExpired()) {
                        this.cancelTimer(timerId);
                    } else if (redeliver) {
                        if ((long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries()) {
                            Date redeliveryTimeout = new Date(now.getTime() + this.getRedeliveryInterval());
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Redelivering " + timerState);
                            }
                            this.rescheduleTask(timerId, redeliveryTimeout);
                        } else {
                            int numDeliv = timerState.getNumFailedDeliveries() + 1;
                            logger.log(Level.INFO, "ejb.timer_exceeded_max_deliveries", new Object[]{timerState.toString(), new Integer(numDeliv)});
                            this.expungeTimer(timerId, true);
                        }
                    } else if (timerState.isPeriodic()) {
                        Date expiration = this.calcNextFixedRateExpiration(timerState);
                        if (expiration != null) {
                            this.scheduleTask(timerId, expiration);
                        } else {
                            this.cancelTimer(timerId);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "callEJBTimeout threw exception for timer id " + timerId, e);
            this.expungeTimer(timerId, true);
        }
        finally {
            container.onLeavingContainer();
            this.agent.requestEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean postEjbTimeout(TimerPrimaryKey timerId) {
        boolean success = true;
        if (this.shutdown_) {
            return success;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            BaseContainer container = this.getContainer(timerState.getContainerId());
            container.incrementDeliveredTimedObject();
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (!timerState.isCancelled()) {
                    try {
                        TimerState timer = null;
                        if (timerState.isPersistent() && null == (timer = this.getValidTimerFromDB(timerId))) {
                            return false;
                        }
                        if (timerState.isPeriodic()) {
                            Date now = new Date();
                            if (timerState.isPersistent()) {
                                timer.setLastExpiration(now);
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Setting last expiration  for periodic timer " + timerState + " to " + now);
                            }
                        } else {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Single-action timer " + timerState + " was successfully delivered. " + " Removing...");
                            }
                            this.cancelTimer(timerId);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Error in post-ejbTimeout timer processing for " + timerState, e);
                        success = false;
                    }
                }
            }
        }
        return success;
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.getValidTimerFromDB(timerId);
        if (null == timer) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerState getValidTimerFromDB(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.timerLocal_.findTimer(timerId);
        try {
            if (timer != null) {
                if (!timer.getOwnerId().equals(this.ownerIdOfThisServer_)) {
                    logger.log(Level.WARNING, "The timer (" + timerId + ") is not owned by " + "server (" + this.ownerIdOfThisServer_ + ") that " + "initiated the ejbTimeout. This timer is now " + "owned by (" + timer.getOwnerId() + "). \n" + "Hence delete the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                    result = false;
                }
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Timer :" + timerId + ": has been cancelled by another server instance. " + "Expunging the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                }
                result = false;
            }
        }
        finally {
            if (!result) {
                this.expungeTimer(timerId, false);
                timer = null;
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Timer :" + timerId + ": is a valid timer for the server (" + this.ownerIdOfThisServer_ + ")");
            }
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskExpired(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isScheduled()) {
                    timerState.delivered();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Adding work pool task for timer " + timerId);
                    }
                    TaskExpiredWork work = new TaskExpiredWork(this, timerId);
                    ejbContainerUtil.addWork(work);
                } else {
                    logger.log(Level.FINE, "Timer " + timerId + " is not in scheduled state.  Current state = " + timerState.stateToString());
                }
            }
        } else {
            logger.log(Level.FINE, "null timer state for timer id " + timerId);
        }
    }

    private synchronized String getNextTimerId() {
        if (this.nextTimerIdCounter_ <= 0L) {
            this.nextTimerIdMillis_ = System.currentTimeMillis();
            this.nextTimerIdCounter_ = 1L;
        } else {
            ++this.nextTimerIdCounter_;
        }
        return new String(this.nextTimerIdCounter_ + TIMER_ID_SEP + this.nextTimerIdMillis_ + TIMER_ID_SEP + this.serverName_ + TIMER_ID_SEP + this.domainName_);
    }

    private long getMinimumDeliveryInterval() {
        return this.minimumDeliveryInterval_;
    }

    private long getMaxRedeliveries() {
        return this.maxRedeliveries_;
    }

    private long getRedeliveryInterval() {
        return this.redeliveryInterval_;
    }

    private TimerPrimaryKey getPrimaryKey(TimerState timer) {
        return new TimerPrimaryKey(timer.getTimerId());
    }

    TimerLocal getTimerLocal() {
        return this.timerLocal_;
    }

    void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId) throws Exception {
        this.addTimerSynchronization(context_, timerId, initialExpiration, containerId, ownerId, true);
    }

    void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            TimerPrimaryKey pk = new TimerPrimaryKey(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId, persistent);
            if (containerSynch == null) {
                this.scheduleTask(pk, initialExpiration);
                ejbContainerUtil.getContainer(containerId).incrementCreatedTimedObject();
            } else {
                TimerSynch timerSynch = new TimerSynch(pk, 0, initialExpiration, ejbContainerUtil.getContainer(containerId), this);
                containerSynch.addTimerSynchronization(pk, timerSynch);
            }
        }
    }

    void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId) throws Exception {
        this.cancelTimerSynchronization(context_, timerId, containerId, ownerId, true);
    }

    void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            Date nextTimeout = this.cancelTask(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId.getTimerId(), persistent);
            if (containerSynch == null) {
                this.expungeTimer(timerId);
                ejbContainerUtil.getContainer(containerId).incrementRemovedTimedObject();
            } else {
                Synchronization timerSynch = containerSynch.getTimerSynchronization(timerId);
                if (timerSynch != null) {
                    containerSynch.removeTimerSynchronization(timerId);
                    this.expungeTimer(timerId);
                } else {
                    timerSynch = new TimerSynch(timerId, 1, nextTimeout, ejbContainerUtil.getContainer(containerId), this);
                    containerSynch.addTimerSynchronization(timerId, timerSynch);
                }
            }
        }
    }

    private boolean timerOwnedByThisServer(String ownerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        return ownerIdOfThisServer != null && ownerIdOfThisServer.equals(ownerId);
    }

    private Date getNextScheduledTimeout(TimerSchedule ts) {
        Calendar next = ts.getNextTimeout();
        if (ts.isValid(next)) {
            return next.getTime();
        }
        return null;
    }

    private ContainerSynchronization getContainerSynch(EJBContextImpl context_, String timerId, boolean persistent) throws Exception {
        Transaction transaction = null;
        if (context_ != null) {
            transaction = context_.getTransaction();
        }
        if (transaction == null) {
            ComponentInvocation i = ejbContainerUtil.getCurrentInvocation();
            if (i == null) {
                transaction = ejbContainerUtil.getTransactionManager().getTransaction();
            } else {
                transaction = (Transaction)i.getTransaction();
                if (context_ != null && transaction != null) {
                    logger.log(Level.WARNING, "Context transaction in TimerBean = null. Using invocation instead.");
                }
            }
        }
        if (transaction == null) {
            if (persistent) {
                throw new Exception("transaction = null in getContainerSynch for timerId = " + timerId);
            }
            return null;
        }
        return ejbContainerUtil.getContainerSync(transaction);
    }

    static String txStatusToString(int txStatus) {
        String txStatusStr = "UNMATCHED TX STATUS";
        switch (txStatus) {
            case 0: {
                txStatusStr = "TX_STATUS_ACTIVE";
                break;
            }
            case 3: {
                txStatusStr = "TX_STATUS_COMMITTED";
                break;
            }
            case 8: {
                txStatusStr = "TX_STATUS_COMMITTING";
                break;
            }
            case 1: {
                txStatusStr = "TX_STATUS_MARKED_ROLLBACK";
                break;
            }
            case 6: {
                txStatusStr = "TX_STATUS_NO_TRANSACTION";
                break;
            }
            case 2: {
                txStatusStr = "TX_STATUS_PREPARED";
                break;
            }
            case 7: {
                txStatusStr = "TX_STATUS_PREPARING";
                break;
            }
            case 4: {
                txStatusStr = "TX_STATUS_ROLLEDBACK";
                break;
            }
            case 9: {
                txStatusStr = "TX_STATUS_ROLLING_BACK";
                break;
            }
            case 5: {
                txStatusStr = "TX_STATUS_UNKNOWN";
                break;
            }
            default: {
                txStatusStr = "UNMATCHED TX STATUS";
            }
        }
        return txStatusStr;
    }

    private File getTimerServiceShutdownFile() throws Exception {
        String j2eeAppPath = ConfigBeansUtilities.getLocation((String)this.appID);
        File timerServiceShutdownDirectory = new File(j2eeAppPath + File.separator);
        timerServiceShutdownDirectory.mkdirs();
        File timerServiceShutdownFile = new File(j2eeAppPath + File.separator + TIMER_SERVICE_FILE);
        return timerServiceShutdownFile;
    }

    private long getTimerServiceDownAt() {
        long timerServiceWentDownAt = -1L;
        try {
            File timerServiceShutdownFile = this.getTimerServiceShutdownFile();
            if (timerServiceShutdownFile.exists()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
                FileReader fr = new FileReader(timerServiceShutdownFile);
                BufferedReader br = new BufferedReader(fr, 128);
                String line = br.readLine();
                Date myDate = dateFormat.parse(line);
                timerServiceWentDownAt = myDate.getTime();
                logger.log(Level.INFO, "ejb.timer_service_last_shutdown", new Object[]{line});
            } else {
                logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{timerServiceShutdownFile});
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{""});
            logger.log(Level.WARNING, "", th);
        }
        return timerServiceWentDownAt;
    }

    public void onShutdown() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
            String downTimeStr = dateFormat.format(new Date());
            File timerServiceShutdownFile = this.getTimerServiceShutdownFile();
            FileWriter fw = new FileWriter(timerServiceShutdownFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(downTimeStr);
            pw.flush();
            pw.close();
            fw.close();
            logger.log(Level.INFO, "ejb.timer_service_shutdown_msg", new Object[]{downTimeStr});
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "ejb.timer_service_shutdown_unknown", new Object[]{TIMER_SERVICE_FILE});
            logger.log(Level.WARNING, "", th);
        }
    }

    private static class TimerSynch
    implements Synchronization {
        private TimerPrimaryKey timerId_;
        private int state_;
        private Date timeout_;
        private BaseContainer container_;
        private EJBTimerService timerService_;

        public TimerSynch(TimerPrimaryKey timerId, int state, Date timeout, BaseContainer container, EJBTimerService timerService) {
            this.timerId_ = timerId;
            this.state_ = state;
            this.timeout_ = timeout;
            this.container_ = container;
            this.timerService_ = timerService;
        }

        public void afterCompletion(int status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TimerSynch::afterCompletion. timer state = " + TimerState.stateToString(this.state_) + " , " + "timer id = " + this.timerId_ + " , JTA TX status = " + EJBTimerService.txStatusToString(status) + " , " + "timeout = " + this.timeout_);
            }
            switch (this.state_) {
                case 0: {
                    if (status == 3) {
                        this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                        this.container_.incrementCreatedTimedObject();
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    break;
                }
                case 1: {
                    if (status == 4) {
                        if (this.timeout_ != null) {
                            this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                            break;
                        }
                        this.timerService_.restoreTaskToDelivered(this.timerId_);
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    this.container_.incrementRemovedTimedObject();
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    private static class TaskExpiredWork
    implements Runnable {
        private EJBTimerService timerService_;
        private TimerPrimaryKey timerId_;

        public TaskExpiredWork(EJBTimerService timerService, TimerPrimaryKey timerId) {
            this.timerService_ = timerService;
            this.timerId_ = timerId;
        }

        public void run() {
            this.timerService_.deliverTimeout(this.timerId_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimerCache {
        private Map timers_ = new HashMap();
        private Map containerTimers_ = new HashMap();
        private Map<TimerPrimaryKey, RuntimeTimerState> nonpersistentTimers_ = new HashMap<TimerPrimaryKey, RuntimeTimerState>();

        public synchronized void addTimer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding timer " + timerState);
            }
            this.timers_.put(timerId, timerState);
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.put(timerId, timerState);
            }
            Long containerId = new Long(timerState.getContainerId());
            Object containerInfo = this.containerTimers_.get(containerId);
            if (timerState.timedObjectIsEntity()) {
                ArrayList<Object> entityBeans;
                if (containerInfo == null) {
                    entityBeans = new ArrayList<Object>();
                    this.containerTimers_.put(containerId, entityBeans);
                } else {
                    entityBeans = (ArrayList<Object>)containerInfo;
                }
                entityBeans.add(timerState.getTimedObjectPrimaryKey());
            } else {
                Long timerCount = containerInfo == null ? new Long(1L) : new Long((Long)containerInfo + 1L);
                this.containerTimers_.put(containerId, timerCount);
            }
        }

        public synchronized void removeTimer(TimerPrimaryKey timerId) {
            Long containerId;
            Object containerInfo;
            RuntimeTimerState timerState;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing timer " + timerId);
            }
            if ((timerState = (RuntimeTimerState)this.timers_.remove(timerId)) == null) {
                return;
            }
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.remove(timerId);
            }
            if ((containerInfo = this.containerTimers_.get(containerId = new Long(timerState.getContainerId()))) != null) {
                if (timerState.timedObjectIsEntity()) {
                    Collection entityBeans = (Collection)containerInfo;
                    if (entityBeans.size() == 1) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        entityBeans.remove(timerState.getTimedObjectPrimaryKey());
                    }
                } else {
                    long timerCount = (Long)containerInfo;
                    if (timerCount == 1L) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        Long newCount = new Long(timerCount - 1L);
                        this.containerTimers_.put(containerId, newCount);
                    }
                }
            }
        }

        public synchronized RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
            return (RuntimeTimerState)this.timers_.get(timerId);
        }

        public synchronized RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
            return this.nonpersistentTimers_.get(timerId);
        }

        public synchronized boolean entityBeanHasTimers(long containerId, Object pkey) {
            Object containerInfo = this.containerTimers_.get(new Long(containerId));
            return containerInfo != null ? ((Collection)containerInfo).contains(pkey) : false;
        }

        public synchronized boolean containerHasTimers(long containerId) {
            return this.containerTimers_.containsKey(new Long(containerId));
        }

        public synchronized void validate() {
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (TimerPrimaryKey key : this.nonpersistentTimers_.keySet()) {
                RuntimeTimerState rt = this.nonpersistentTimers_.get(key);
                if (rt.getContainerId() != containerId_) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (TimerPrimaryKey key : this.nonpersistentTimers_.keySet()) {
                RuntimeTimerState rt = this.nonpersistentTimers_.get(key);
                if (rt.getContainerId() != containerId_ || !rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getActiveTimerIdsByThisServer() {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (TimerPrimaryKey key : this.nonpersistentTimers_.keySet()) {
                RuntimeTimerState rt = this.nonpersistentTimers_.get(key);
                if (!rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }
    }
}

