/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.codegen.StaticRmiStubGenerator;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.ejb.spi.CMPService;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication> {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected PolicyLoader policyLoader;
    @Inject
    protected EJBSecurityManagerFactory ejbSecManagerFactory;
    @Inject
    private ComponentEnvManager compEnvManager;
    private Object lock = new Object();
    private volatile CMPDeployer cmpDeployer = null;
    private static final String APP_UNIQUE_ID_PROP = "org.glassfish.ejb.container.application_unique_id";
    private AtomicLong uniqueIdCounter = new AtomicLong(System.currentTimeMillis());
    private static final Logger _logger = LogDomains.getLogger(EjbDeployer.class, (String)"javax.enterprise.system.container.ejb");

    protected String getModuleType() {
        return "ejb";
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public boolean prepare(DeploymentContext dc) {
        long uniqueAppId;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null) {
            throw new RuntimeException("Unable to load EJB module.  DeploymentContext does not contain any EJB  Check archive to ensure correct packaging for " + dc.getSourceDir());
        }
        Properties appProps = dc.getAppProps();
        if (!appProps.containsKey(APP_UNIQUE_ID_PROP)) {
            uniqueAppId = this.getNextEjbAppUniqueId();
            appProps.setProperty(APP_UNIQUE_ID_PROP, uniqueAppId + "");
        } else {
            uniqueAppId = Long.parseLong(appProps.getProperty(APP_UNIQUE_ID_PROP));
        }
        Application app = ejbBundle.getApplication();
        if (!app.isUniqueIdSet()) {
            app.setUniqueId(uniqueAppId);
        }
        return super.prepare(dc);
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        super.load((Container)containerStarter, dc);
        RegisteredComponentInvocationHandler handler = (RegisteredComponentInvocationHandler)this.habitat.getComponent(RegisteredComponentInvocationHandler.class, "ejbSecurityCIH");
        handler.register();
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null) {
            throw new RuntimeException("Unable to load EJB module.  DeploymentContext does not contain any EJB  Check archive to ensure correct packaging for " + dc.getSourceDir());
        }
        ejbBundle.setClassLoader(dc.getClassLoader());
        if (ejbBundle.containsCMPEntity()) {
            CMPService cmpService = (CMPService)this.habitat.getByContract(CMPService.class);
            if (cmpService == null) {
                throw new RuntimeException("CMP Module is not available");
            }
            if (!cmpService.isReady()) {
                throw new RuntimeException("CMP Module is not initialized");
            }
        }
        EjbApplication ejbApp = new EjbApplication(ejbBundle, dc, dc.getClassLoader(), this.habitat, this.ejbSecManagerFactory);
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)ejbBundle);
            RootDeploymentDescriptor rootDesc = ejbBundle.getModuleDescriptor().getDescriptor();
            if (rootDesc != ejbBundle && rootDesc instanceof WebBundleDescriptor) {
                WebBundleDescriptor webBundle = (WebBundleDescriptor)rootDesc;
                this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)webBundle);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering ejb bundle level resources", e);
        }
        ejbApp.loadContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        EjbBundleDescriptor ejbBundle = ejbApplication.getEjbBundleDescriptor();
        try {
            this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)ejbBundle);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error unbinding ejb bundle " + ejbBundle.getModuleName() + " dependency namespace", e);
        }
        if (ejbBundle.containsCMPEntity()) {
            this.initCMPDeployer();
            if (this.cmpDeployer != null) {
                this.cmpDeployer.unload(ejbBundle.getClassLoader());
            }
        }
    }

    public void clean(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if ((params.origin.isUndeploy() || params.origin.isDeploy()) && (this.env.isDas() || this.env.isEmbedded())) {
            String appName;
            String[] contextIds;
            if (this.cmpDeployer != null) {
                this.cmpDeployer.clean(dc);
            }
            if ((contextIds = this.ejbSecManagerFactory.getContextsForApp(appName = params.name(), false)) != null) {
                for (String contextId : contextIds) {
                    try {
                        SecurityUtil.removePolicy((String)contextId);
                    }
                    catch (IASSecurityException ex) {
                        _logger.log(Level.WARNING, "Error removing the policy file for application " + appName + " " + (Object)((Object)ex));
                    }
                    ArrayList<EJBSecurityManager> managers = this.ejbSecManagerFactory.getManagers(contextId, false);
                    if (managers == null) continue;
                    for (EJBSecurityManager m : managers) {
                        m.destroy();
                    }
                }
            }
            SecurityUtil.removeRoleMapper((DeploymentContext)dc);
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (!params.origin.isDeploy() || !this.env.isDas() && !this.env.isEmbedded()) {
            return;
        }
        EjbBundleDescriptor bundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        this.policyLoader.loadPolicy();
        if (bundle != null) {
            for (EjbDescriptor desc : bundle.getEjbs()) {
                this.ejbSecManagerFactory.createManager(desc, true);
            }
        }
        DeployCommandParameters dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        boolean generateRmicStubs = dcp.generatermistubs;
        dc.addTransientAppMetaData("org.glassfish.ejb.spi.module.classpath", (Object)this.getModuleClassPath(dc));
        if (generateRmicStubs) {
            StaticRmiStubGenerator staticStubGenerator = new StaticRmiStubGenerator(this.habitat);
            try {
                staticStubGenerator.ejbc(dc);
            }
            catch (Exception e) {
                throw new DeploymentException("Static RMI-IIOP Stub Generation exception for " + dc.getSourceDir(), (Throwable)e);
            }
        }
        if (bundle == null || !bundle.containsCMPEntity()) {
            return;
        }
        this.initCMPDeployer();
        if (this.cmpDeployer == null) {
            throw new DeploymentException("No CMP Deployer is available to deploy this module");
        }
        this.cmpDeployer.deploy(dc);
    }

    private long getNextEjbAppUniqueId() {
        long next = this.uniqueIdCounter.incrementAndGet();
        return next << 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCMPDeployer() {
        if (this.cmpDeployer == null) {
            Object object = this.lock;
            synchronized (object) {
                this.cmpDeployer = (CMPDeployer)this.habitat.getByContract(CMPDeployer.class);
            }
        }
    }
}

